/*
 * Decompiled with CFR 0.152.
 */
package com.wuwenze.poi.xlsx;

import com.wuwenze.poi.convert.WriteConverter;
import com.wuwenze.poi.exception.ExcelKitRuntimeException;
import com.wuwenze.poi.pojo.ExcelMapping;
import com.wuwenze.poi.pojo.ExcelProperty;
import com.wuwenze.poi.util.DateUtil;
import com.wuwenze.poi.util.POIUtil;
import com.wuwenze.poi.util.ValidatorUtil;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class ExcelXlsxWriter {
    private final ExcelMapping mExcelMapping;
    private final Integer mMaxSheetRecords;
    private CellStyle mHeaderCellStyle = null;

    public ExcelXlsxWriter(ExcelMapping excelMapping, Integer maxSheetRecords) {
        this.mExcelMapping = excelMapping;
        this.mMaxSheetRecords = maxSheetRecords;
    }

    public SXSSFWorkbook generateXlsxWorkbook(List<?> data, boolean isTemplate) {
        SXSSFWorkbook workbook = POIUtil.newSXSSFWorkbook();
        List<ExcelProperty> propertyList = this.mExcelMapping.getPropertyList();
        double sheetNo = Math.ceil((double)data.size() / (double)this.mMaxSheetRecords.intValue());
        int index = 0;
        while (true) {
            double d = index;
            double d2 = sheetNo == 0.0 ? sheetNo : sheetNo - 1.0;
            if (!(d <= d2)) break;
            String sheetName = this.mExcelMapping.getName() + (index == 0 ? "" : "_" + index);
            SXSSFSheet sheet = this.generateXlsxHeader(workbook, propertyList, sheetName, isTemplate);
            if (null != data && data.size() > 0) {
                int startNo = index * this.mMaxSheetRecords;
                int endNo = Math.min(startNo + this.mMaxSheetRecords, data.size());
                for (int i = startNo; i < endNo; ++i) {
                    SXSSFRow bodyRow = POIUtil.newSXSSFRow(sheet, i + 1 - startNo);
                    for (int j = 0; j < propertyList.size(); ++j) {
                        SXSSFCell cell = POIUtil.newSXSSFCell(bodyRow, j);
                        ExcelXlsxWriter.buildCellValueByExcelProperty(cell, data.get(i), propertyList.get(j));
                    }
                }
            }
            ++index;
        }
        return workbook;
    }

    private SXSSFSheet generateXlsxHeader(SXSSFWorkbook workbook, List<ExcelProperty> propertyList, String sheetName, boolean isTemplate) {
        SXSSFDrawing sxssfDrawing = null;
        SXSSFSheet sheet = POIUtil.newSXSSFSheet(workbook, sheetName);
        SXSSFRow headerRow = POIUtil.newSXSSFRow(sheet, 0);
        for (int i = 0; i < propertyList.size(); ++i) {
            ExcelProperty property = propertyList.get(i);
            SXSSFCell cell = POIUtil.newSXSSFCell(headerRow, i);
            POIUtil.setColumnWidth(sheet, i, property.getWidth(), property.getColumn());
            if (isTemplate) {
                POIUtil.setColumnCellRange(sheet, property.getOptions(), 1, this.mMaxSheetRecords, i, i);
                if (null == sxssfDrawing) {
                    sxssfDrawing = sheet.createDrawingPatriarch();
                }
                if (!ValidatorUtil.isEmpty(property.getComment())) {
                    Comment cellComment = sxssfDrawing.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, i, 0, i, 0));
                    XSSFRichTextString xssfRichTextString = new XSSFRichTextString(property.getComment());
                    Font commentFormatter = workbook.createFont();
                    xssfRichTextString.applyFont(commentFormatter);
                    cellComment.setString((RichTextString)xssfRichTextString);
                    cell.setCellComment(cellComment);
                }
            }
            cell.setCellStyle(this.getHeaderCellStyle(workbook));
            String headerColumnValue = property.getColumn();
            if (isTemplate && null != property.getRequired() && property.getRequired().booleanValue()) {
                headerColumnValue = headerColumnValue + "[*]";
            }
            cell.setCellValue(headerColumnValue);
        }
        return sheet;
    }

    private static void buildCellValueByExcelProperty(SXSSFCell cell, Object entity, ExcelProperty property) {
        Object cellValue;
        try {
            cellValue = BeanUtils.getProperty((Object)entity, (String)property.getName());
        }
        catch (Throwable e) {
            throw new ExcelKitRuntimeException(e);
        }
        if (null != cellValue) {
            String dateFormat = property.getDateFormat();
            if (!ValidatorUtil.isEmpty(dateFormat)) {
                if (cellValue instanceof Date) {
                    cell.setCellValue(DateUtil.format(dateFormat, (Date)cellValue));
                } else if (cellValue instanceof String) {
                    try {
                        Date parse = DateUtil.ENGLISH_LOCAL_DF.parse((String)cellValue);
                        cell.setCellValue(DateUtil.format(dateFormat, parse));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    return;
                }
            }
            String writeConverterExp = property.getWriteConverterExp();
            WriteConverter writeConverter = property.getWriteConverter();
            if (!ValidatorUtil.isEmpty(writeConverterExp)) {
                try {
                    cellValue = POIUtil.convertByExp(cellValue, writeConverterExp);
                }
                catch (Throwable e) {
                    throw new ExcelKitRuntimeException(e);
                }
            } else if (null != writeConverter) {
                cell.setCellValue(writeConverter.convert(cellValue));
                return;
            }
            cell.setCellValue(String.valueOf(cellValue));
        }
    }

    public CellStyle getHeaderCellStyle(SXSSFWorkbook wb) {
        if (null == this.mHeaderCellStyle) {
            this.mHeaderCellStyle = wb.createCellStyle();
            Font font = wb.createFont();
            this.mHeaderCellStyle.setFillForegroundColor((short)12);
            this.mHeaderCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.mHeaderCellStyle.setBorderTop(BorderStyle.DOTTED);
            this.mHeaderCellStyle.setBorderRight(BorderStyle.DOTTED);
            this.mHeaderCellStyle.setBorderBottom(BorderStyle.DOTTED);
            this.mHeaderCellStyle.setBorderLeft(BorderStyle.DOTTED);
            this.mHeaderCellStyle.setAlignment(HorizontalAlignment.LEFT);
            this.mHeaderCellStyle.setFillForegroundColor(HSSFColor.GREEN.index);
            this.mHeaderCellStyle.setFillBackgroundColor(HSSFColor.GREEN.index);
            font.setColor(HSSFColor.WHITE.index);
            this.mHeaderCellStyle.setFont(font);
            DataFormat dataFormat = wb.createDataFormat();
            this.mHeaderCellStyle.setDataFormat(dataFormat.getFormat("@"));
        }
        return this.mHeaderCellStyle;
    }
}

