/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.util.web;

import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpAddressHelper {
    private static final Logger logger = LoggerFactory.getLogger(IpAddressHelper.class);

    public static String getRemoteHost(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        String[] ips = ip.split(",");
        for (int i = 0; i < ips.length; ++i) {
            ips[i] = ips[i].replace(" ", "");
            if ("127.0.0.1".equals(ips[i]) || "0:0:0:0:0:0:0:1".equals(ips[i])) {
                return ips[i];
            }
            ip = ips[i];
        }
        return ip;
    }
}

