/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.util.language;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinYinUtil {
    public static String getPinYinName(String name) {
        if (null == name || "".equals(name)) {
            return "";
        }
        char[] strs = name.toCharArray();
        String newname = null;
        try {
            newname = strs.length == 2 ? PinYinUtil.toUpCase(PinYinUtil.getEname("" + strs[0])) + " " + PinYinUtil.toUpCase(PinYinUtil.getEname("" + strs[1])) : (strs.length == 3 ? PinYinUtil.toUpCase(PinYinUtil.getEname("" + strs[0])) + " " + PinYinUtil.toUpCase(PinYinUtil.getEname("" + strs[1] + strs[2])) : (strs.length == 4 ? PinYinUtil.toUpCase(PinYinUtil.getEname("" + strs[0] + strs[1])) + " " + PinYinUtil.toUpCase(PinYinUtil.getEname("" + strs[2] + strs[3])) : PinYinUtil.toUpCase(PinYinUtil.getEname(name))));
        }
        catch (BadHanyuPinyinOutputFormatCombination badHanyuPinyinOutputFormatCombination) {
            badHanyuPinyinOutputFormatCombination.printStackTrace();
        }
        return newname;
    }

    private static String toUpCase(String str) {
        StringBuffer newstr = new StringBuffer();
        newstr.append(str.substring(0, 1).toUpperCase()).append(str.substring(1, str.length()));
        return newstr.toString();
    }

    public static String getEname(String name) throws BadHanyuPinyinOutputFormatCombination {
        HanyuPinyinOutputFormat pyFormat = new HanyuPinyinOutputFormat();
        pyFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        pyFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        pyFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
        return PinyinHelper.toHanYuPinyinString((String)name, (HanyuPinyinOutputFormat)pyFormat, (String)"", (boolean)true);
    }

    public static String converterToFirstSpell(String chines) {
        StringBuilder pinyinName = new StringBuilder();
        char[] nameChar = chines.toCharArray();
        HanyuPinyinOutputFormat defaulFormat = new HanyuPinyinOutputFormat();
        defaulFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaulFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        defaulFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
        for (int i = 0; i < nameChar.length; ++i) {
            if (nameChar[i] > '\u0080') {
                try {
                    pinyinName.append(PinyinHelper.toHanyuPinyinStringArray((char)nameChar[i], (HanyuPinyinOutputFormat)defaulFormat)[0].charAt(0));
                }
                catch (BadHanyuPinyinOutputFormatCombination ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            pinyinName.append(nameChar[i]);
        }
        return pinyinName.toString();
    }
}

