/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.util.barcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class QRCodeUtil {
    private static int default_width = 300;
    private static int default_height = 300;
    private static String format = "png";

    public static void getCommoneQRCode(String filePath, String fileName, String contents) {
        QRCodeUtil.creatCode(contents, filePath, fileName, default_width, default_height);
    }

    public static void getQRCode(String contents, String filePath, String fileName, int width, int height) {
        width = width <= 0 ? default_width : width;
        height = height <= 0 ? default_height : height;
        QRCodeUtil.creatCode(contents, filePath, fileName, width, height);
    }

    private static void creatCode(String contents, String filePath, String fileName, int width, int height) {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
        hints.put(EncodeHintType.MARGIN, 2);
        File files = new File(filePath + File.separator + fileName + ".png");
        File fileDir = new File(filePath);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        try (FileOutputStream outputStream = new FileOutputStream(files);){
            BitMatrix encode = new QRCodeWriter().encode(contents, BarcodeFormat.QR_CODE, width, height, hints);
            MatrixToImageWriter.writeToStream((BitMatrix)encode, (String)format, (OutputStream)outputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

