/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.util.barcode;

import com.wmeimob.fastboot.util.barcode.CodeTypeEnum;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.impl.code128.Code128Bean;
import org.krysalis.barcode4j.impl.int2of5.ITF14Bean;
import org.krysalis.barcode4j.impl.upcean.EAN13Bean;
import org.krysalis.barcode4j.impl.upcean.UPCABean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;

public class BarCodeUtil {
    @Deprecated
    public static void getBarCode(CodeTypeEnum type, String filePath, String fileName, String content) {
        BarCodeUtil.getBarCode(type, filePath + File.separator + fileName + ".png", new Property(false), content);
    }

    public static void getBarCode(CodeTypeEnum type, String filePath, Property property, String content) {
        BitmapCanvasProvider getcanvas = null;
        File file = BarCodeUtil.generatePath(filePath);
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            BarcodeGenerator generator = BarCodeUtil.getBarcodeGenerator(type, property);
            getcanvas = BarCodeUtil.getCanvas(outputStream, property.getDpi());
            generator.generateBarcode((CanvasProvider)getcanvas, content);
            getcanvas.finish();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getBarCode(CodeTypeEnum type, String filePath, String content) {
        BarCodeUtil.getBarCode(type, filePath, BarCodeUtil.buildDefaultProps(), content);
    }

    public static Property buildDefaultProps() {
        return BarCodeUtil.buildProps(false);
    }

    public static Property buildProps(boolean custom) {
        return new Property(custom);
    }

    private static BarcodeGenerator getBarcodeGenerator(CodeTypeEnum type, Property property) {
        Code128Bean abstractBarcodeBean;
        switch (type) {
            case CODE128: {
                abstractBarcodeBean = new Code128Bean();
                break;
            }
            case ITF14: {
                abstractBarcodeBean = new ITF14Bean();
                break;
            }
            case UPCA: {
                abstractBarcodeBean = new UPCABean();
                break;
            }
            default: {
                abstractBarcodeBean = new EAN13Bean();
            }
        }
        if (property != null) {
            abstractBarcodeBean.setBarHeight(property.getHeight().doubleValue());
            abstractBarcodeBean.setModuleWidth(property.getWidth().doubleValue());
            abstractBarcodeBean.setFontSize(property.getFontSize().doubleValue());
        }
        return abstractBarcodeBean;
    }

    private static File generatePath(String filePath) {
        File folders = new File(filePath.substring(0, filePath.lastIndexOf("/")));
        if (!folders.exists()) {
            folders.mkdirs();
        }
        File outputFile = new File(filePath);
        return outputFile;
    }

    private static BitmapCanvasProvider getCanvas(OutputStream outputStream, int dpi) {
        BitmapCanvasProvider canvas = new BitmapCanvasProvider(outputStream, "image/x-png", dpi, 12, false, 0);
        return canvas;
    }

    public static void main(String[] args) {
        BarCodeUtil.getBarCode(CodeTypeEnum.CODE128, "/tmp/test111.png", "21312131");
    }

    public static class Property {
        private boolean customProps;
        private Double height = 12.5;
        private Double width = 0.55;
        private Double fontSize = 3.25;
        private int dpi = 255;

        Property(boolean customProps) {
            this.customProps = customProps;
        }

        public int getDpi() {
            return this.dpi;
        }

        public void setDpi(int dpi) {
            this.dpi = dpi;
        }

        public Double getFontSize() {
            return this.fontSize;
        }

        public Property setFontSize(Double fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public Double getWidth() {
            return this.width;
        }

        public Property setWidth(Double width) {
            this.width = width;
            return this;
        }

        public Double getHeight() {
            return this.height;
        }

        public Property setHeight(Double height) {
            this.height = height;
            return this;
        }
    }
}

