/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomCodeUtil {
    private static Logger logger = LoggerFactory.getLogger(RandomCodeUtil.class);
    private static final int UUID_MAX_VALUE = 15;
    private static int reBuildCount = 0;
    private static final String RAND_STR = "23456789ABCDEFGH23456789JKLMNPQR23456789STUVWXYZ";
    private static final String RAND_NUM = "0123456789";

    public static void main(String[] args) {
        System.out.println(RandomCodeUtil.randCode(20));
    }

    public static String randCode(int length) {
        Iterator<String> iterator = RandomCodeUtil.randCode(length, 1).iterator();
        if (iterator.hasNext()) {
            String set = iterator.next();
            return set;
        }
        return null;
    }

    public static String randCodeNum(int length) {
        Iterator<String> iterator = RandomCodeUtil.randCodeNum(length, 1).iterator();
        if (iterator.hasNext()) {
            String set = iterator.next();
            return set;
        }
        return null;
    }

    public static Set<String> randCode(int length, int srcCount) {
        return RandomCodeUtil.randCode(length, srcCount, srcCount, null);
    }

    public static Set<String> randCodeNum(int length, int srcCount) {
        return RandomCodeUtil.randCodeNum(length, srcCount, srcCount, null);
    }

    private static Set<String> randCode(int length, int srcCount, int count, Set<String> srcSet) {
        return RandomCodeUtil.randCode(RAND_STR, length, srcCount, count, srcSet);
    }

    private static Set<String> randCodeNum(int length, int srcCount, int count, Set<String> srcSet) {
        return RandomCodeUtil.randCode(RAND_NUM, length, srcCount, count, srcSet);
    }

    private static Set<String> randCode(String randStr, int length, int srcCount, int count, Set<String> srcSet) {
        String[] randArr = randStr.split("");
        if (length > 32 || length < 1) {
            logger.error("\u5bc6\u6587\u957f\u5ea6\u6700\u5927\u503c\u4e3a32\uff0c\u6700\u5c0f\u503c\u4e3a1");
            System.exit(0);
        }
        if (Math.pow(randArr.length, length) < (double)srcCount) {
            logger.error("\u5f53\u524d\u4f4d\u6570\u6700\u591a\u53ea\u80fd\u751f\u6210" + (int)Math.pow(randArr.length, length) + "\u4e2a,\u8bf7\u4fee\u6539\u3002");
            System.exit(0);
        } else if (srcCount == count) {
            logger.debug("\u51c6\u5907\u751f\u6210...\n\u603b\u4e2a\u6570\uff1a" + srcCount + "\n\u547d\u4e2d\u7387\uff1a" + (double)srcCount / Math.pow(randArr.length, length));
            if ((double)srcCount / Math.pow(randArr.length, length) > 1.0E-4 && srcCount != 1) {
                logger.debug("\u8b66\u544a\uff1a\u5f53\u524d\u547d\u4e2d\u7387\u5927\u4e8e1/10000>>>>");
            }
        }
        logger.debug("\u5f00\u59cb\u751f\u6210...");
        logger.debug("0%>>>");
        if (srcSet == null) {
            srcSet = new HashSet<String>();
        }
        for (int c = 1; c <= count; ++c) {
            int[] indexArray = new int[length];
            for (int uuidCount = 0; uuidCount < randArr.length / 15 + 1; ++uuidCount) {
                String uuid = UUID.randomUUID().toString().replace("-", "");
                String[] uuidArr = uuid.split("");
                int i = 0;
                while (i < indexArray.length) {
                    indexArray[i] = indexArray[i] + Integer.parseUnsignedInt(uuidArr[i], 16);
                    int n = i++;
                    indexArray[n] = indexArray[n] % randArr.length;
                }
            }
            StringBuilder sb = new StringBuilder("");
            for (int j = 0; j < length; ++j) {
                sb.append(randArr[indexArray[j]]);
            }
            logger.debug(c + ">>" + sb.toString());
            srcSet.add(sb.toString());
            double per = (double)c / (double)count;
            if (per * 100.0 % 8.0 != 0.0) continue;
            logger.debug((int)(per * 100.0) + "%>>>");
        }
        logger.debug("100%.");
        if (srcSet.size() < srcCount) {
            logger.debug(">>>\u7b2c" + ++reBuildCount + "\u8f6e\u91cd\u65b0\u751f\u6210\uff1a");
            logger.debug("\u5f00\u59cb" + (srcCount - srcSet.size()) + "\u4e2a\u91cd\u65b0\u751f\u6210");
            RandomCodeUtil.randCode(length, srcCount, srcCount - srcSet.size(), srcSet);
            logger.debug("<<<<");
        } else {
            logger.debug("\u751f\u6210\u5b8c\u6bd5!");
        }
        return srcSet;
    }

    public static String addRegex(String srcStr, String regex, int length) {
        String[] charArr = srcStr.split("");
        StringBuilder sb = new StringBuilder("");
        for (int i = 1; i <= charArr.length; ++i) {
            sb.append(charArr[i - 1]);
            if (i <= 0 || i % length != 0) continue;
            sb.append(regex);
        }
        char lastChar = sb.charAt(sb.length() - 1);
        int lastIndex = sb.length();
        if (regex.length() > 0 && regex.charAt(0) == lastChar) {
            lastIndex = sb.length() - 1;
        }
        return sb.toString().substring(0, lastIndex);
    }
}

