/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.util;

import java.util.regex.Pattern;

public class InputWrapper {
    private static final Pattern SCRIPT_TAG_PATTERN = Pattern.compile("<[\r\n| | ]*script[\r\n| | ]*>(.*?)</[\r\n| | ]*script[\r\n| | ]*>", 2);
    private static final Pattern SRC_PATTERN = Pattern.compile("src[\r\n| | ]*=[\r\n| | ]*[\\\"|\\'](.*?)[\\\"|\\']", 42);
    private static final Pattern SCRIPT_CLOSED_PATTERN = Pattern.compile("</[\r\n| | ]*script[\r\n| | ]*>", 2);
    private static final Pattern SCRIPT_CLOSED_PATTERN2 = Pattern.compile("<[\r\n| | ]*script(.*?)>", 42);
    private static final Pattern SCRIPT_EVAL_PATTERN = Pattern.compile("eval\\((.*?)\\)", 42);
    private static final Pattern E_XPRESSION_PATTERN = Pattern.compile("e-xpression\\((.*?)\\)", 42);
    private static final Pattern JAVASCRIPT_PATTERN = Pattern.compile("javascript[\r\n| | ]*:[\r\n| | ]*", 2);
    private static final Pattern VB_SCRIPT_PATTERN = Pattern.compile("vbscript[\r\n| | ]*:[\r\n| | ]*", 2);
    private static final Pattern ONLOAD_PATTERN = Pattern.compile("onload(.*?)=", 42);

    public static String xssEncode(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        s = InputWrapper.stripXSSAndSql(s);
        StringBuilder sb = new StringBuilder(s.length() + 16);
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '>': {
                    sb.append("\uff1e");
                    continue block8;
                }
                case '<': {
                    sb.append("\uff1c");
                    continue block8;
                }
                case '\'': {
                    sb.append("\uff07");
                    continue block8;
                }
                case '\"': {
                    sb.append("\uff02");
                    continue block8;
                }
                case '&': {
                    sb.append("\uff06");
                    continue block8;
                }
                case '#': {
                    sb.append("\uff03");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static String stripXSSAndSql(String value) {
        if (value != null) {
            value = SCRIPT_TAG_PATTERN.matcher(value).replaceAll("");
            value = SRC_PATTERN.matcher(value).replaceAll("");
            value = SCRIPT_CLOSED_PATTERN.matcher(value).replaceAll("");
            value = SCRIPT_CLOSED_PATTERN2.matcher(value).replaceAll("");
            value = SCRIPT_EVAL_PATTERN.matcher(value).replaceAll("");
            value = E_XPRESSION_PATTERN.matcher(value).replaceAll("");
            value = JAVASCRIPT_PATTERN.matcher(value).replaceAll("");
            value = VB_SCRIPT_PATTERN.matcher(value).replaceAll("");
            value = ONLOAD_PATTERN.matcher(value).replaceAll("");
        }
        return value;
    }
}

