/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.util;

import com.wmeimob.fastboot.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InputValidator {
    public static final String REGEX_USERNAME = "^[a-zA-Z]\\w{3,17}$";
    public static final String REGEX_PASSWORD = "^[a-zA-Z0-9]{6,16}$";
    public static final String REGEX_MOBILE = "^((13[0-9])|(14[0-9])|(15[^4,\\D])|(16[0-9])|(17[0-9])|(18[0-9])|(19[0-9])|(90[0-9])|(91[0-9])|(92[0-9]))\\d{8}$";
    public static final String REGEX_EMAIL = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
    public static final String REGEX_CHINESE = "^[\u4e00-\u9fa5],{0,}$";
    public static final Pattern REGEX_CHINESE_PATTERN = Pattern.compile("[\\u4e00-\\u9fa5]+");
    public static final String REGEX_ID_CARD = "(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}$)";
    public static final String REGEX_URL = "http(s)?://([\\w-]+\\.)+[\\w-]+(/[\\w- ./?%&=]*)?";
    public static final String REGEX_IP_ADDR = "(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)";
    public static final String REGEX_NUMERIC = "[0-9]*";
    public static final String REGEX_DECIMAL = "([0-9]*)|([0-9]*\\.[0-9]*)";
    private static final int MAX_INPUT_LENGTH = 9999;
    private static final int MIN_INPUT_LENGTH = 0;

    public static boolean isUsername(String username) {
        return Pattern.matches(REGEX_USERNAME, username);
    }

    public static boolean isPassword(String password) {
        return Pattern.matches(REGEX_PASSWORD, password);
    }

    public static boolean isNumeric(String str) {
        return str != null && !"".equals(str.trim()) && Pattern.matches(REGEX_NUMERIC, str);
    }

    public static boolean isDecimal(String str) {
        return str != null && !"".equals(str.trim()) && Pattern.matches(REGEX_DECIMAL, str);
    }

    public static boolean isMobile(String mobile) {
        return mobile != null && !"".equals(mobile.trim()) && Pattern.matches(REGEX_MOBILE, mobile);
    }

    public static boolean isEmail(String email) {
        return email != null && !"".equals(email.trim()) && Pattern.matches(REGEX_EMAIL, email);
    }

    public static boolean isChinese(String chinese) {
        return chinese != null && !"".equals(chinese.trim()) && Pattern.matches(REGEX_CHINESE, chinese);
    }

    public static boolean isIDCard(String idCard) {
        return idCard != null && !"".equals(idCard.trim()) && Pattern.matches(REGEX_ID_CARD, idCard);
    }

    public static boolean isUrl(String url) {
        return url != null && !url.trim().equals("") && Pattern.matches(REGEX_URL, url);
    }

    public static boolean isIPAddr(String ipAddr) {
        return ipAddr != null && !"".equals(ipAddr.trim()) && Pattern.matches(REGEX_IP_ADDR, ipAddr);
    }

    public static int countChinese(String content) {
        if (content == null || "".equals(content.trim())) {
            return 0;
        }
        int count = 0;
        Matcher m = REGEX_CHINESE_PATTERN.matcher(content);
        while (m.find()) {
            ++count;
        }
        return count;
    }

    public static boolean isBool(String str) {
        return str != null && !"".equals(str.trim()) && (str.equals("true") || str.equals("false"));
    }

    public static String encodeChinese(String str, String charset) throws UnsupportedEncodingException {
        Matcher m = REGEX_CHINESE_PATTERN.matcher(str);
        StringBuffer b = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(b, URLEncoder.encode(m.group(0), charset));
        }
        m.appendTail(b);
        return b.toString();
    }

    @Deprecated
    public static void checkLength(Object checkObject, int maxLength, int minLength, String tipName) {
        if (maxLength > 9999) {
            maxLength = 9999;
        }
        if (minLength < 0) {
            minLength = 0;
        }
        if (minLength == 0) {
            InputValidator.checkNull(checkObject, tipName);
        } else {
            InputValidator.checkEmpty(checkObject, tipName);
        }
        int length = checkObject.toString().length();
        if (length > maxLength) {
            throw new IllegalArgumentException(tipName + "\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7" + maxLength);
        }
        if (length < minLength && length != 0) {
            throw new IllegalArgumentException(tipName + "\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e" + minLength);
        }
    }

    public static void checkLengthRange(Object checkObject, int min, int max, String tipName) {
        max = max > 9999 ? 9999 : max;
        int n = min = min < 0 ? 0 : min;
        if (min == 0) {
            InputValidator.checkNull(checkObject, tipName);
        } else {
            InputValidator.checkEmpty(checkObject, tipName);
        }
        int length = checkObject.toString().length();
        if (length > max) {
            throw new IllegalArgumentException(tipName + "\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7" + max);
        }
        if (length < min && length != 0) {
            throw new IllegalArgumentException(tipName + "\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e" + min);
        }
    }

    public static void checkEmpty(Object object, String tipName) {
        if (StringUtils.isEmpty((Object)object)) {
            throw new IllegalArgumentException(tipName + "\u4e0d\u53ef\u4e3a\u7a7a");
        }
    }

    public static <E> void checkEmpty(Collection<E> collection, String tipName) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException(tipName + "\u4e3a\u7a7a");
        }
    }

    public static void checkNull(Object object, String tipName) {
        if (object == null) {
            throw new IllegalArgumentException(tipName + "\u4e0d\u53ef\u4e3a\u7a7a");
        }
    }

    public static <T> T defaultValue(T defaultValue, T source) {
        return source == null ? defaultValue : source;
    }

    public static void checkDateTime(Date start, Date end) {
        InputValidator.checkEmpty(start, "\u5f00\u59cb\u65e5\u671f");
        InputValidator.checkEmpty(end, "\u7ed3\u675f\u65e5\u671f");
        if (start.getTime() > end.getTime()) {
            throw new IllegalArgumentException("\u65e5\u671f\u8303\u56f4\u9519\u8bef");
        }
    }

    public static void checkDate(Date min, Date max, Date check, String pattern, String tipName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        InputValidator.checkEmpty(check, tipName);
        if (check.getTime() < min.getTime() || check.getTime() > max.getTime()) {
            throw new IllegalArgumentException(tipName + "\u6709\u6548\u8303\u56f4\u662f" + dateFormat.format(min) + "~" + dateFormat.format(max));
        }
    }

    public static void checkNaturalNumber(Integer num, String tipName) {
        if (num < 0) {
            throw new IllegalArgumentException(tipName + "\u4e0d\u80fd\u5c0f\u4e8e0");
        }
    }

    public static void checkNaturalNumber(BigDecimal num, String tipName) {
        if (num.compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalArgumentException(tipName + "\u4e0d\u80fd\u5c0f\u4e8e0");
        }
    }

    public static void checkNumber(Integer min, Integer max, Integer check, String tipName) {
        InputValidator.checkEmpty(check, tipName);
        if (check < min || check > max) {
            throw new IllegalArgumentException(tipName + "\u6709\u6548\u8303\u56f4\u662f" + min + "~" + max);
        }
    }

    public static void checkNumber(BigDecimal min, BigDecimal max, BigDecimal check, String tipName) {
        InputValidator.checkEmpty(check, tipName);
        if (check.compareTo(min) < 0 || check.compareTo(max) > 0) {
            throw new IllegalArgumentException(tipName + "\u6709\u6548\u8303\u56f4\u662f" + min + "~" + max);
        }
    }
}

