/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.starter.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.github.pagehelper.PageHelper;
import com.wmeimob.fastboot.autoconfigure.mybatis.MyBatisProperties;
import com.wmeimob.fastboot.core.handler.JSONArrayTypeHandler;
import com.wmeimob.fastboot.core.handler.JsonTypeHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.TypeHandler;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;
import org.springframework.util.StringUtils;

@Configuration
@EnableTransactionManagement
public class MybatisConfig
implements TransactionManagementConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(MybatisConfig.class);
    private DruidDataSource dataSource;
    @Resource
    private MyBatisProperties myBatisProperties;
    @Resource
    private DataSourceProperties dataSourceProperties;

    @Bean(destroyMethod="close")
    @ConfigurationProperties(prefix="spring.datasource.druid")
    public synchronized DruidDataSource getDataSource() {
        if (this.dataSource == null) {
            this.dataSource = new DruidDataSource();
            this.dataSource.setUsername(this.dataSourceProperties.getUsername());
            this.dataSource.setPassword(this.dataSourceProperties.getPassword());
            this.dataSource.setUrl(this.dataSourceProperties.getUrl());
            this.dataSource.setDriverClassName(this.dataSourceProperties.getDriverClassName());
        }
        return this.dataSource;
    }

    @Bean(name={"sqlSessionFactory"})
    public SqlSessionFactory sqlSessionFactoryBean() throws Exception {
        logger.info("[ config SqlSessionFactoryBean ]");
        SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
        bean.setDataSource((DataSource)this.getDataSource());
        bean.setTypeAliasesPackage(this.myBatisProperties.getTypeAliasesPackage());
        PageHelper pageHelper = new PageHelper();
        Properties properties = new Properties();
        properties.setProperty("reasonable", "true");
        properties.setProperty("supportMethodsArguments", "true");
        properties.setProperty("returnPageInfo", "check");
        properties.setProperty("params", "count=countSql");
        pageHelper.setProperties(properties);
        bean.setPlugins(new Interceptor[]{pageHelper});
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        ArrayList<org.springframework.core.io.Resource> mapperLocations = new ArrayList<org.springframework.core.io.Resource>();
        String[] locationArr = this.myBatisProperties.getMapperLocations();
        for (int i = 0; i < locationArr.length; ++i) {
            mapperLocations.addAll(new ArrayList<org.springframework.core.io.Resource>(Arrays.asList(resolver.getResources(locationArr[i]))));
        }
        bean.setMapperLocations(mapperLocations.toArray(new org.springframework.core.io.Resource[mapperLocations.size()]));
        if (StringUtils.hasLength((String)this.myBatisProperties.getTypeHandlersPackage())) {
            logger.info("set json type handlers...");
            TypeHandler[] typeHandlers = new TypeHandler[]{new JsonTypeHandler(), new JSONArrayTypeHandler()};
            bean.setTypeHandlers(typeHandlers);
        }
        return bean.getObject();
    }

    @Bean
    public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    @Bean
    public PlatformTransactionManager annotationDrivenTransactionManager() {
        return new DataSourceTransactionManager((DataSource)this.getDataSource());
    }
}

