/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.starter.wechat.service;

import com.alibaba.fastjson.JSONObject;
import com.mzlion.easyokhttp.HttpClient;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.starter.wechat.mapper.WechatAppMapper;
import com.wmeimob.fastboot.starter.wechat.service.WechatSignUtil;
import com.wmeimob.fastboot.starter.wechat.service.impl.WechatServiceImpl;
import com.wmeimob.fastboot.util.RandomCodeUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import me.hao0.wechat.model.base.WechatApp;
import me.hao0.wechat.model.base.WechatMp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

@Service(value="wechatQYService")
@Deprecated
public class WechatQYServiceImpl
extends WechatServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(WechatQYServiceImpl.class);
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private WechatAppMapper wechatAppMapper;
    private static RestTemplate restTemplate = new RestTemplate();

    public Map<String, Object> jssdkInit(Integer mpid, Integer agentId, String currentUrl) {
        String sha12;
        JSONObject sb;
        long timestamp = System.currentTimeMillis();
        String nonceStr = RandomCodeUtil.randCode((int)12);
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("timestamp", timestamp / 1000L);
        map.put("noncestr", nonceStr);
        map.put("url", currentUrl);
        String ticket = (String)this.redisTemplate.opsForValue().get((Object)("mps:" + mpid + ":apps:" + agentId + ":jsapi_ticket"));
        if (ticket == null && (sb = (JSONObject)restTemplate.getForObject("https://qyapi.weixin.qq.com/cgi-bin/get_jsapi_ticket?access_token={token}", JSONObject.class, new Object[]{this.getAgentAccessToken(mpid, agentId)})) != null && sb.getString("ticket") != null) {
            ticket = sb.getString("ticket");
            this.redisTemplate.opsForValue().set((Object)("mps:" + mpid + ":apps:" + agentId + ":jsapi_ticket"), (Object)ticket, (long)(sb.getInteger("expires_in") - 600) * 1000L, TimeUnit.MILLISECONDS);
        }
        map.put("jsapi_ticket", ticket);
        StringBuffer sb1 = new StringBuffer("");
        for (String sha12 : map.keySet()) {
            sb1.append(sha12 + "=" + map.get(sha12) + "&");
        }
        String result1 = sb1.substring(0, sb1.length() - 1);
        sha12 = "";
        try {
            sha12 = WechatSignUtil.SHA1(result1);
        }
        catch (NoSuchAlgorithmException var12) {
            log.error(var12.getMessage(), (Throwable)var12);
        }
        map.put("signature", sha12.toLowerCase());
        WechatMp wechatMps = this.getWechatMp(mpid);
        map.put("appId", wechatMps.getAppid());
        map.remove("jsapi_ticket");
        return map;
    }

    public WechatApp getApp(Integer mpid, Integer agentId) {
        Assert.notNull((Object)agentId, (String)"agentId is null");
        WechatApp wechatApp = (WechatApp)this.redisTemplate.opsForValue().get((Object)("mps:" + mpid + ":apps:" + agentId));
        if (wechatApp == null) {
            wechatApp = new WechatApp();
            wechatApp.setMpid(Integer.valueOf(mpid));
            wechatApp.setAgentId(agentId);
            wechatApp = (WechatApp)this.wechatAppMapper.selectOne((Object)wechatApp);
            Assert.notNull((Object)wechatApp, (String)("\u5e94\u7528 " + agentId + " \u4e0d\u5b58\u5728"));
            this.redisTemplate.opsForValue().set((Object)("mps:" + mpid + ":apps:" + agentId), (Object)wechatApp);
        }
        return wechatApp;
    }

    public String getAgentAccessToken(Integer mpid, Integer agentId) {
        String accessToken = (String)this.redisTemplate.opsForValue().get((Object)("mps:" + mpid + ":apps:" + agentId + ":accessToken"));
        if (accessToken == null) {
            WechatMp wechatMps = this.getWechatMp(mpid);
            WechatApp wechatApp = this.getApp(mpid, agentId);
            JSONObject accessTokenJson = (JSONObject)restTemplate.getForObject("https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid={appid}&corpsecret={secret}", JSONObject.class, new Object[]{wechatMps.getAppid(), wechatApp.getSecret()});
            accessToken = accessTokenJson.getString("access_token");
            Assert.notNull((Object)accessToken, (String)("[" + accessTokenJson.getInteger("errcode") + "]" + accessTokenJson.getString("errmsg")));
        }
        return accessToken;
    }

    public String getMedia(Integer mpid, Integer agentId, String serverId, String path) throws IOException {
        String accessToken = this.getAgentAccessToken(mpid, agentId);
        File file = new File(path);
        if (!file.exists() && !file.mkdirs()) {
            throw new CustomException("\u6ca1\u6709\u8bfb\u53d6\u548c\u521b\u5efa " + path + " \u76ee\u5f55\u7684\u6743\u9650");
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/media/get?access_token=ACCESS_TOKEN&media_id=MEDIA_ID".replace("ACCESS_TOKEN", accessToken).replace("MEDIA_ID", serverId);
        URL u = new URL(url);
        URLConnection uc = u.openConnection();
        String type = uc.getContentType();
        log.info("::type is ::" + type);
        if ("voice".equals(type)) {
            type = "audio/amr";
        }
        type = type.split("/")[1];
        String fileName = UUID.randomUUID().toString().replace("-", "") + "." + type;
        String fileFullName = path + "/" + fileName;
        file = new File(fileFullName);
        HttpClient.get((String)url).asFile(file);
        if ("amr".equals(type)) {
            String newFileName = fileName.split("\\.")[0] + ".mp3";
            try {
                Process exec = Runtime.getRuntime().exec(path + "/ffmpeg -i " + path + "/" + fileName + " " + path + "/" + newFileName);
                InputStream stdin = exec.getErrorStream();
                InputStreamReader isr = new InputStreamReader(stdin);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                System.out.println("<OUTPUT>");
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                }
                System.out.println("</OUTPUT>");
                int exitVal = exec.waitFor();
                System.out.println("Process exitValue: " + exitVal);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            StringBuilder sb = new StringBuilder("");
            System.out.println(sb);
            return newFileName;
        }
        return fileName;
    }

    public JSONObject sendTextMsg(Integer mpid, Integer agentId, List<String> touser, String content) {
        JSONObject contentJson = new JSONObject();
        contentJson.put("content", (Object)content);
        return this.sendMsg(mpid, agentId, touser, null, null, "text", contentJson);
    }

    private JSONObject sendMsg(Integer mpid, Integer agentId, List<String> touser, List<String> toparty, List<String> totag, String msgtype, JSONObject contentJson) {
        String accessToken = this.getAgentAccessToken(mpid, agentId);
        JSONObject jsonObject = new JSONObject();
        StringBuilder touserSb = new StringBuilder("");
        if (touser != null && touser.size() != 0) {
            for (String string : touser) {
                touserSb.append(string).append("|");
            }
        }
        StringBuilder topartSb = new StringBuilder("");
        if (toparty != null && toparty.size() != 0) {
            for (String string : toparty) {
                topartSb.append(string).append("|");
            }
        }
        StringBuilder stringBuilder = new StringBuilder("");
        if (totag != null && totag.size() != 0) {
            for (String tag : totag) {
                stringBuilder.append(tag).append("|");
            }
        }
        if (touserSb.length() > 0) {
            String string = touserSb.substring(0, touserSb.length() - 1);
            jsonObject.put("touser", (Object)string);
        }
        if (topartSb.length() > 0) {
            String string = topartSb.substring(0, topartSb.length() - 1);
            jsonObject.put("toparty", (Object)string);
        }
        if (stringBuilder.length() > 0) {
            String string = stringBuilder.substring(0, stringBuilder.length() - 1);
            jsonObject.put("totag", (Object)string);
        }
        jsonObject.put("msgtype", (Object)msgtype);
        jsonObject.put("agentid", (Object)agentId);
        jsonObject.put(msgtype, (Object)contentJson);
        JSONObject jSONObject = JSONObject.parseObject((String)HttpClient.textBody((String)" https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=ACCESS_TOKEN".replace("ACCESS_TOKEN", accessToken)).json(jsonObject.toJSONString()).execute().asString());
        if (jSONObject.getInteger("errcode") == 0) {
            log.info("push text msg success ,return result \uff1a" + jsonObject.toJSONString());
        } else {
            log.error("push text msg fail , return result \uff1a" + jsonObject.toJSONString());
        }
        return jSONObject;
    }

    public JSONObject sendCardText(Integer mpid, Integer agentId, List<String> touser, String title, String description, String url, String btntxt) {
        JSONObject contentJson = new JSONObject();
        contentJson.put("title", (Object)title);
        contentJson.put("description", (Object)description);
        contentJson.put("url", (Object)url);
        contentJson.put("btntxt", (Object)btntxt);
        return this.sendMsg(mpid, agentId, touser, null, null, "textcard", contentJson);
    }
}

