/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.starter.wechat.controller;

import com.wmeimob.fastboot.autoconfigure.folder.FolderProperties;
import com.wmeimob.fastboot.autoconfigure.wechat.WechatProperties;
import com.wmeimob.fastboot.core.annotation.Logging;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.starter.security.JwtAuthenticationFilter;
import com.wmeimob.fastboot.starter.wechat.entity.SecurityWechatUser;
import com.wmeimob.fastboot.starter.wechat.service.WechatQYServiceImpl;
import com.wmeimob.fastboot.starter.wechat.service.WechatService;
import com.wmeimob.fastboot.util.InputValidator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import me.hao0.wechat.core.Wechat;
import me.hao0.wechat.exception.WechatException;
import me.hao0.wechat.model.base.AuthAccessToken;
import me.hao0.wechat.model.base.AuthType;
import me.hao0.wechat.model.base.WechatMp;
import me.hao0.wechat.model.base.WechatUser;
import me.hao0.wechat.model.user.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"core"})
@Logging
public class WechatController {
    private static final Logger log = LoggerFactory.getLogger(WechatController.class);
    @Resource
    private WechatService wechatService;
    @Resource
    private JwtAuthenticationFilter jwtAuthenticationFilter;
    @Resource
    private WechatProperties wechatProperties;
    @Resource
    private WechatQYServiceImpl wechatQYService;
    @Resource
    private FolderProperties folderProperties;

    @GetMapping(value={"mp/token"})
    public Map<String, Object> getToken(String code, Integer mpid, String appid) {
        AuthAccessToken authAccessToken;
        Assert.notNull((Object)code, (String)"code is null");
        WechatMp wechatMp = mpid == null ? this.wechatService.getWechatMp((Object)appid) : this.wechatService.getWechatMp((Object)mpid);
        Wechat wechat = this.wechatService.getWechat((Object)wechatMp);
        try {
            authAccessToken = wechat.base().authAccessToken(code);
        }
        catch (WechatException e) {
            log.error(e.getMessage());
            throw new CustomException("\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5");
        }
        String openid = authAccessToken.getOpenId();
        SecurityWechatUser securityWechatUser = new SecurityWechatUser();
        securityWechatUser.setOpenid(openid);
        if (AuthType.USER_INFO.scope().equals(wechatMp.getAuthScope())) {
            UserInfo userInfo = wechat.user().getUserInfo(authAccessToken);
            BeanUtils.copyProperties((Object)userInfo, (Object)securityWechatUser);
            securityWechatUser.setHeadimgurl(userInfo.getHeadImgUrl());
            securityWechatUser.setNickname(userInfo.getNickName());
            securityWechatUser.setUnionid(userInfo.getUnionId());
        }
        securityWechatUser.setAppid(wechatMp.getAppid());
        securityWechatUser.setMpid(wechatMp.getId());
        WechatUser wechatUser = new WechatUser();
        BeanUtils.copyProperties((Object)securityWechatUser, (Object)wechatUser);
        this.wechatService.saveWechatUserInfo(wechatUser);
        securityWechatUser.setId(wechatUser.getId());
        String token = this.jwtAuthenticationFilter.getJsonWebTokenHandler().generateToken((UserDetails)securityWechatUser);
        log.info("token\uff1a" + token);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("token", token);
        map.put("wechatUser", securityWechatUser);
        return map;
    }

    @GetMapping(value={"jssdk"})
    public Object getJssdk(String url, Integer mpid, String appid, Integer agentId) {
        if (!InputValidator.isUrl((String)url)) {
            return RestResult.fail((String)"\u5730\u5740\u4e0d\u6b63\u786e");
        }
        if (StringUtils.isEmpty((Object)agentId)) {
            Wechat wechat = mpid == null ? this.wechatService.getWechat((Object)appid) : this.wechatService.getWechat((Object)mpid);
            return wechat.js().getConfig(UUID.randomUUID().toString().replace("-", ""), url);
        }
        return this.wechatQYService.jssdkInit(this.wechatProperties.getActiveMpid(), agentId, url);
    }

    @GetMapping(value={"file-name"})
    public RestResult getFileName(Integer mpid, Integer agentId, String moduleName, String ... serverId) {
        if (serverId == null || serverId.length == 0 || StringUtils.isEmpty((Object)agentId)) {
            return RestResult.fail((String)"serverId o  r agentId array is empty or null");
        }
        if (StringUtils.isEmpty((Object)mpid)) {
            mpid = this.wechatProperties.getActiveMpid();
            Assert.notNull((Object)mpid, (String)"\u672a\u6307\u5b9a\u7684mpid");
        }
        String path = (String)this.folderProperties.getFolders().get("file-path-" + moduleName);
        Assert.notNull((Object)path, (String)("\u672a\u914d\u7f6e\u6a21\u5757\u3010" + moduleName + "\u3011\u7684\u6587\u4ef6\u4e0a\u4f20\u8def\u5f84"));
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String sid : serverId) {
            String fileName = null;
            try {
                fileName = this.wechatQYService.getMedia(mpid, agentId, sid, path);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            fileNames.add(fileName);
            System.out.println("save file :" + fileName);
        }
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        map.put("fileNames", fileNames);
        return RestResult.success(map);
    }
}

