/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.starter.wechat.config;

import com.wmeimob.fastboot.core.startup.WmeimobStartUpRunnable;
import com.wmeimob.fastboot.core.startup.WmeimobStartUpRunnableProvider;
import com.wmeimob.fastboot.starter.security.JsonWebTokenHandler;
import com.wmeimob.fastboot.starter.security.JwtAuthenticationFilter;
import com.wmeimob.fastboot.starter.security.interfaces.JsonWebTokenDecoder;
import com.wmeimob.fastboot.starter.security.interfaces.JsonWebTokenEncoder;
import com.wmeimob.fastboot.starter.wechat.config.WechatJsonWebTokenDecoder;
import com.wmeimob.fastboot.starter.wechat.config.WechatJsonWebTokenEncoder;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class WmeimobWechatStartUpRunner
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(WmeimobWechatStartUpRunner.class);
    @Autowired(required=false)
    private WmeimobStartUpRunnableProvider wmeimobStartUpRunnableProvider;
    @Resource
    protected JwtAuthenticationFilter jwtAuthenticationTokenFilter;

    public void run(ApplicationArguments applicationArguments) {
        if (this.wmeimobStartUpRunnableProvider == null) {
            this.initJwtDecoderAndEncoder();
            return;
        }
        this.wmeimobStartUpRunnableProvider.run((mode, runnable) -> {
            if (WmeimobStartUpRunnable.Mode.APPEND.equals((Object)mode)) {
                this.initJwtDecoderAndEncoder();
            }
            runnable.run();
        });
    }

    private void initJwtDecoderAndEncoder() {
        JsonWebTokenHandler jsonWebTokenHandler = this.jwtAuthenticationTokenFilter.getJsonWebTokenHandler();
        jsonWebTokenHandler.setJsonWebTokenDecoder((JsonWebTokenDecoder)new WechatJsonWebTokenDecoder());
        jsonWebTokenHandler.setJsonWebTokenEncoder((JsonWebTokenEncoder)new WechatJsonWebTokenEncoder());
    }
}

