/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.starter.wechat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.autoconfigure.wechat.WechatProperties;
import com.wmeimob.fastboot.starter.wechat.loader.WechatMpAccessTokenLoader;
import com.wmeimob.fastboot.starter.wechat.loader.WechatTicketLoader;
import com.wmeimob.fastboot.starter.wechat.mapper.WechatAppMapper;
import com.wmeimob.fastboot.starter.wechat.mapper.WechatMchMapper;
import com.wmeimob.fastboot.starter.wechat.mapper.WechatMpMapper;
import com.wmeimob.fastboot.starter.wechat.mapper.WechatUserMapper;
import com.wmeimob.fastboot.starter.wechat.service.WechatService;
import javax.annotation.Resource;
import me.hao0.wechat.core.Wechat;
import me.hao0.wechat.core.WechatBuilder;
import me.hao0.wechat.loader.AccessTokenLoader;
import me.hao0.wechat.loader.TicketLoader;
import me.hao0.wechat.model.base.WechatApp;
import me.hao0.wechat.model.base.WechatMch;
import me.hao0.wechat.model.base.WechatMp;
import me.hao0.wechat.model.base.WechatUser;
import me.hao0.wepay.core.Wepay;
import me.hao0.wepay.core.WepayBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="wechatService")
public class WechatServiceImpl
implements WechatService {
    private static final Logger log = LoggerFactory.getLogger(WechatServiceImpl.class);
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private WechatProperties projectWechatProperties;
    @Resource
    private WechatMpMapper wechatMpMapper;
    @Resource
    private WechatMchMapper wechatMchMapper;
    @Resource
    private WechatUserMapper wechatUserMapper;
    @Resource
    private WechatAppMapper wechatAppMapper;
    private static volatile AccessTokenLoader accessTokenLoader;
    private static volatile TicketLoader ticketLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AccessTokenLoader getAccessTokenLoader(String appid, StringRedisTemplate stringRedisTemplate) {
        if (accessTokenLoader != null) return accessTokenLoader;
        Class<WechatServiceImpl> clazz = WechatServiceImpl.class;
        synchronized (WechatServiceImpl.class) {
            if (accessTokenLoader != null) return accessTokenLoader;
            accessTokenLoader = new WechatMpAccessTokenLoader(appid, stringRedisTemplate);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return accessTokenLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TicketLoader getTicketLoader(String appid, StringRedisTemplate stringRedisTemplate) {
        if (ticketLoader != null) return ticketLoader;
        Class<WechatServiceImpl> clazz = WechatServiceImpl.class;
        synchronized (WechatServiceImpl.class) {
            if (ticketLoader != null) return ticketLoader;
            ticketLoader = new WechatTicketLoader(appid, stringRedisTemplate);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return ticketLoader;
        }
    }

    @Override
    public Wechat getWechat() {
        return this.getWechat(this.getWechatMp());
    }

    @Override
    public <T> Wechat getWechat(T param) {
        if (param instanceof WechatMp) {
            WechatMp wechatMp = (WechatMp)param;
            return WechatBuilder.newBuilder((String)wechatMp.getAppid(), (String)wechatMp.getSecret()).accessTokenLoader(this.getAccessTokenLoader(wechatMp.getAppid(), this.stringRedisTemplate)).ticketLoader(this.getTicketLoader(wechatMp.getAppid(), this.stringRedisTemplate)).build();
        }
        return this.getWechat(this.getWechatMp(param));
    }

    @Override
    public WechatMp getWechatMp() {
        Object param = this.projectWechatProperties.getActiveMpid();
        if (param == null) {
            param = this.projectWechatProperties.getActiveAppid();
            Assert.notNull((Object)param, (String)"you're not configure wechat flag in project ");
        }
        return this.getWechatMp(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> WechatMp getWechatMp(T param) {
        if (param == null) {
            return this.getWechatMp();
        }
        WechatMp wechatMp = (WechatMp)JSONObject.parseObject((String)((String)this.stringRedisTemplate.opsForValue().get((Object)String.format("mps:%s", param))), WechatMp.class);
        if (wechatMp == null) {
            if (param instanceof Integer) {
                Integer mpid = (Integer)param;
                String string = String.format("mps:%s", mpid).intern();
                synchronized (string) {
                    wechatMp = (WechatMp)this.wechatMpMapper.selectByPrimaryKey(mpid);
                }
                Assert.notNull((Object)wechatMp, (String)("\u516c\u4f17\u53f7MPID{" + mpid + "} \u4e0d\u5b58\u5728"));
            } else {
                String appid = (String)param;
                wechatMp = new WechatMp();
                wechatMp.setAppid(appid);
                String string = String.format("mps:%s", appid).intern();
                synchronized (string) {
                    wechatMp = (WechatMp)this.wechatMpMapper.selectOne(wechatMp);
                }
                Assert.notNull((Object)wechatMp, (String)("\u516c\u4f17\u53f7APPID{" + appid + "}\u4e0d\u5b58\u5728"));
            }
            this.stringRedisTemplate.opsForValue().set((Object)String.format("mps:%s", param), (Object)JSONObject.toJSONString((Object)wechatMp));
        }
        return wechatMp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <N> WechatMch getWechatMch(N mchNoMchId) {
        Assert.notNull(mchNoMchId, (String)"\u5546\u6237\u672a\u914d\u7f6e\u5fae\u4fe1\u652f\u4ed8");
        WechatMch wechatMch = (WechatMch)JSONObject.parseObject((String)((String)this.stringRedisTemplate.opsForValue().get((Object)String.format("mch:%s", mchNoMchId))), WechatMch.class);
        if (wechatMch == null) {
            if (mchNoMchId instanceof Integer) {
                Integer mchId = (Integer)mchNoMchId;
                String string = String.format("mch:%s", mchId).intern();
                synchronized (string) {
                    wechatMch = (WechatMch)this.wechatMchMapper.selectByPrimaryKey(mchId);
                }
                Assert.notNull((Object)wechatMch, (String)("\u5546\u6237\u53f7MCH_ID{" + mchId + "} \u4e0d\u5b58\u5728"));
            } else {
                String mchNo = (String)mchNoMchId;
                wechatMch = new WechatMch();
                wechatMch.setMchNo(mchNo);
                String string = String.format("mch:%s", mchNo).intern();
                synchronized (string) {
                    wechatMch = (WechatMch)this.wechatMchMapper.selectOne(wechatMch);
                }
                Assert.notNull((Object)wechatMch, (String)("\u5546\u6237\u53f7MCH_NO{" + mchNo + "}\u4e0d\u5b58\u5728"));
            }
            this.stringRedisTemplate.opsForValue().set((Object)String.format("mch:%s", mchNoMchId), (Object)JSONObject.toJSONString((Object)wechatMch));
        }
        return wechatMch;
    }

    @Override
    public WechatMch getWechatMch() {
        WechatMp wechatMp = this.getWechatMp();
        Assert.notNull((Object)wechatMp.getMchId(), (String)("\u5546\u6237" + wechatMp.getAppid() + "\u672a\u914d\u7f6e\u5fae\u4fe1\u652f\u4ed8"));
        return this.getWechatMch(this.getWechatMp().getMchId());
    }

    @Override
    public <T> String getAccessToken(T param) {
        WechatMp wechatMp = this.getWechatMp(param);
        return this.getAccessTokenLoader(wechatMp.getAppid(), this.stringRedisTemplate).get();
    }

    @Override
    public String getAccessToken() {
        return this.getAccessTokenLoader(this.getWechatMp().getAppid(), this.stringRedisTemplate).get();
    }

    @Override
    public WechatApp getWechatApp(Integer agentId) {
        return this.getWechatApp(null, agentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> WechatApp getWechatApp(T param, Integer agentId) {
        if (agentId == null) {
            throw new IllegalArgumentException(" agentId are not allow null");
        }
        WechatMp wechatMp = this.getWechatMp(param);
        WechatApp wechatApp = (WechatApp)JSONObject.parseObject((String)((String)this.stringRedisTemplate.opsForValue().get((Object)String.format("agent:%s", agentId))), WechatApp.class);
        if (wechatApp == null) {
            String string = String.format("agent:%s", agentId).intern();
            synchronized (string) {
                wechatApp = new WechatApp();
                wechatApp.setAgentId(agentId);
                wechatApp.setMpid(wechatMp.getId());
                wechatApp = (WechatApp)this.wechatAppMapper.selectOne(wechatApp);
            }
            Assert.notNull((Object)wechatApp, (String)("\u4f01\u4e1a\u5e94\u7528\u53f7AGENT_ID{" + agentId + "} \u4e0d\u5b58\u5728\uff0c\ud83d\udc20 PARAMS {" + param + "}"));
            this.stringRedisTemplate.opsForValue().set((Object)String.format("agent:%s", agentId), (Object)JSONObject.toJSONString((Object)wechatApp));
        }
        return wechatApp;
    }

    @Override
    public Wepay getWepay() {
        WechatMp wechatMp = this.getWechatMp();
        WechatMch wechatMch = this.getWechatMch();
        WepayBuilder wepayBuilder = WepayBuilder.newBuilder((String)wechatMp.getAppid(), (String)wechatMch.getMchKey(), (String)wechatMch.getMchNo());
        if (wechatMch.getP12() != null && wechatMch.getP12().length > 0) {
            wepayBuilder.certs(wechatMch.getP12());
            wepayBuilder.certPasswd(wechatMch.getMchNo());
        }
        return wepayBuilder.build();
    }

    @Override
    public Wepay getWepay(WechatMp wechatMp, WechatMch wechatMch) {
        WepayBuilder wepayBuilder = WepayBuilder.newBuilder((String)wechatMp.getAppid(), (String)wechatMch.getMchKey(), (String)wechatMch.getMchNo());
        if (wechatMch.getP12() != null && wechatMch.getP12().length > 0) {
            wepayBuilder.certs(wechatMch.getP12());
            wepayBuilder.certPasswd(wechatMch.getMchNo());
        }
        return wepayBuilder.build();
    }

    @Override
    public <P, C> Wepay getWepay(P param, C mcParam) {
        WechatMp wechatMp = this.getWechatMp(param);
        WechatMch wechatMch = this.getWechatMch(param);
        WepayBuilder wepayBuilder = WepayBuilder.newBuilder((String)wechatMp.getAppid(), (String)wechatMch.getMchKey(), (String)wechatMch.getMchNo());
        if (wechatMch.getP12() != null && wechatMch.getP12().length > 0) {
            wepayBuilder.certs(wechatMch.getP12());
            wepayBuilder.certPasswd(wechatMch.getMchNo());
        }
        return wepayBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public WechatUser saveWechatUserInfo(WechatUser wechatUser) {
        try {
            String openid = wechatUser.getOpenid();
            Assert.notNull((Object)openid, (String)"An error occurred when saving wechat user to db ,cause the openid is null");
            WechatUser queryWechatUser = new WechatUser();
            queryWechatUser.setOpenid(openid);
            String string = openid.intern();
            synchronized (string) {
                queryWechatUser = (WechatUser)this.wechatUserMapper.selectOne(queryWechatUser);
                if (queryWechatUser == null) {
                    this.wechatUserMapper.insertSelective(wechatUser);
                } else {
                    wechatUser.setId(queryWechatUser.getId());
                    this.wechatUserMapper.updateByPrimaryKeySelective(wechatUser);
                }
                return wechatUser;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

