/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.starter.security;

import com.wmeimob.fastboot.starter.security.JsonWebToken;
import com.wmeimob.fastboot.starter.security.JsonWebTokenHandler;
import com.wmeimob.fastboot.starter.security.interfaces.impl.UserJsonWebTokenDecoder;
import com.wmeimob.fastboot.starter.security.interfaces.impl.UserJsonWebTokenEncoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.authentication.preauth.RequestHeaderAuthenticationFilter;
import org.springframework.stereotype.Component;

@Component
public final class JwtAuthenticationFilter
extends RequestHeaderAuthenticationFilter {
    private JsonWebTokenHandler jsonWebTokenHandler;
    public static final String DEFAULT_HEADER = "Authorization";
    private AuthenticationManager authenticationManager;

    public JsonWebTokenHandler getJsonWebTokenHandler() {
        return this.jsonWebTokenHandler;
    }

    @Autowired
    public JwtAuthenticationFilter(JsonWebToken jsonWebToken) {
        JsonWebTokenHandler jsonWebTokenHandler = new JsonWebTokenHandler();
        this.setExceptionIfHeaderMissing(false);
        String queryHeader = DEFAULT_HEADER;
        if (jsonWebToken != null && jsonWebToken.getHeader() != null) {
            queryHeader = jsonWebToken.getHeader();
        }
        this.setPrincipalRequestHeader(queryHeader);
        jsonWebTokenHandler.setJsonWebToken(jsonWebToken);
        jsonWebTokenHandler.setJsonWebTokenDecoder(new UserJsonWebTokenDecoder());
        jsonWebTokenHandler.setJsonWebTokenEncoder(new UserJsonWebTokenEncoder());
        jsonWebTokenHandler.setJsonWebTokenReplayAttacksDetector((a, b) -> {});
        jsonWebTokenHandler.setJsonWebTokenReplayAttacksDefiniens((a, b) -> {});
        this.jsonWebTokenHandler = jsonWebTokenHandler;
    }

    @Autowired
    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
        super.setAuthenticationManager(authenticationManager);
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }
}

