/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.starter.security;

import com.wmeimob.fastboot.starter.security.JsonWebToken;
import com.wmeimob.fastboot.starter.security.JwtAuthenticationFilter;
import com.wmeimob.fastboot.starter.security.JwtAuthenticationProvider;
import javax.annotation.Resource;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    @Resource
    private JwtAuthenticationFilter jwtAuthenticationFilter;
    @Resource
    private JwtAuthenticationProvider jwtAuthenticationProvider;
    @Resource
    private AccessDeniedHandler accessDeniedHandlerImpl;
    @Resource
    private AuthenticationEntryPoint authenticationEntryPointImpl;
    private JsonWebToken jsonWebToken;
    protected static String[] PERMISSION_URLS;

    public static String[] getPermissionUrls() {
        return PERMISSION_URLS;
    }

    @Autowired
    public WebSecurityConfig(JsonWebToken jsonWebToken) {
        this.jsonWebToken = jsonWebToken;
        PERMISSION_URLS = jsonWebToken == null || jsonWebToken.getPermissionUrls() == null || jsonWebToken.getPermissionUrls().length == 0 ? new String[]{"/**"} : jsonWebToken.getPermissionUrls();
    }

    protected void configure(AuthenticationManagerBuilder auth) {
        auth.authenticationProvider((AuthenticationProvider)this.jwtAuthenticationProvider);
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        AuthenticationManager authenticationManager = super.authenticationManagerBean();
        return authenticationManager;
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.csrf().disable()).httpBasic().disable()).formLogin().disable()).addFilterBefore((Filter)this.jwtAuthenticationFilter, UsernamePasswordAuthenticationFilter.class).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).exceptionHandling().authenticationEntryPoint(this.authenticationEntryPointImpl).accessDeniedHandler(this.accessDeniedHandlerImpl).and()).authorizeRequests().antMatchers(PERMISSION_URLS)).permitAll().anyRequest()).authenticated();
        http.headers().cacheControl();
    }
}

