/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.starter.security;

import com.wmeimob.fastboot.autoconfigure.security.RestSecurity;
import com.wmeimob.fastboot.starter.security.JwtAuthentication;
import com.wmeimob.fastboot.starter.security.JwtAuthenticationFilter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;

@Component
public final class JwtAuthenticationProvider
implements AuthenticationProvider {
    @Resource
    private JwtAuthenticationFilter jwtAuthenticationFilter;
    @Resource
    private RestSecurity httpBasicAuthProperties;
    private static final String HTTP_BASIC_AUTH_HEAD = "Basic ";
    private static final List<GrantedAuthority> GRANTED_AUTHORITIES = new ArrayList<GrantedAuthority>();

    protected String encode(String username, String password) {
        String token = Base64Utils.encodeToString((byte[])(username + ":" + password).getBytes(StandardCharsets.UTF_8));
        return HTTP_BASIC_AUTH_HEAD + token;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Object authenticatedUser = null;
        if (authentication.getClass().isAssignableFrom(PreAuthenticatedAuthenticationToken.class) && authentication.getPrincipal() != null) {
            String tokenHeader = (String)authentication.getPrincipal();
            if (tokenHeader != null && tokenHeader.startsWith(HTTP_BASIC_AUTH_HEAD)) {
                if (this.encode(this.httpBasicAuthProperties.getGlobal().getUsername(), this.httpBasicAuthProperties.getGlobal().getPassword()).equals(tokenHeader)) {
                    authenticatedUser = new JwtAuthentication((UserDetails)new User(this.httpBasicAuthProperties.getGlobal().getUsername(), this.httpBasicAuthProperties.getGlobal().getPassword(), true, true, true, true, GRANTED_AUTHORITIES));
                }
            } else {
                UserDetails userDetails = this.jwtAuthenticationFilter.getJsonWebTokenHandler().decodeToken(tokenHeader);
                if (userDetails != null) {
                    authenticatedUser = new JwtAuthentication(userDetails);
                }
            }
        } else {
            authenticatedUser = authentication;
        }
        return authenticatedUser;
    }

    public boolean supports(Class<?> authentication) {
        return authentication.isAssignableFrom(PreAuthenticatedAuthenticationToken.class) || authentication.isAssignableFrom(JwtAuthentication.class);
    }

    static {
        GRANTED_AUTHORITIES.add((GrantedAuthority)new SimpleGrantedAuthority("ACTUATOR"));
    }
}

