/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.starter.security;

import com.wmeimob.fastboot.starter.security.JsonWebToken;
import com.wmeimob.fastboot.starter.security.interfaces.JsonWebTokenDecoder;
import com.wmeimob.fastboot.starter.security.interfaces.JsonWebTokenEncoder;
import com.wmeimob.fastboot.starter.security.interfaces.JsonWebTokenReplayAttacksDefiniens;
import com.wmeimob.fastboot.starter.security.interfaces.JsonWebTokenReplayAttacksDetector;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.springframework.security.core.userdetails.UserDetails;

public class JsonWebTokenHandler
implements Serializable {
    private static final String CLAIM_KEY_CREATED = "createdAt";
    private JsonWebTokenDecoder jsonWebTokenDecoder;
    private JsonWebTokenEncoder jsonWebTokenEncoder;
    private JsonWebTokenReplayAttacksDetector jsonWebTokenReplayAttacksDetector;
    private JsonWebTokenReplayAttacksDefiniens jsonWebTokenReplayAttacksDefiniens;
    private JsonWebToken jsonWebToken;

    public void setJsonWebTokenDecoder(JsonWebTokenDecoder jsonWebTokenDecoder) {
        this.jsonWebTokenDecoder = jsonWebTokenDecoder;
    }

    public void setJsonWebTokenEncoder(JsonWebTokenEncoder jsonWebTokenEncoder) {
        this.jsonWebTokenEncoder = jsonWebTokenEncoder;
    }

    public void setJsonWebTokenReplayAttacksDetector(JsonWebTokenReplayAttacksDetector jsonWebTokenReplayAttacksDetector) {
        this.jsonWebTokenReplayAttacksDetector = jsonWebTokenReplayAttacksDetector;
    }

    public void setJsonWebTokenReplayAttacksDefiniens(JsonWebTokenReplayAttacksDefiniens jsonWebTokenReplayAttacksDefiniens) {
        this.jsonWebTokenReplayAttacksDefiniens = jsonWebTokenReplayAttacksDefiniens;
    }

    protected void setJsonWebToken(JsonWebToken jsonWebToken) {
        this.jsonWebToken = jsonWebToken;
    }

    public String getUsernameFromToken(String token) {
        String username;
        try {
            Claims claims = this.getClaimsFromToken(token);
            username = claims.getSubject();
        }
        catch (Exception e) {
            username = null;
        }
        return username;
    }

    private Date getCreatedDateFromToken(String token) {
        Date created;
        try {
            Claims claims = this.getClaimsFromToken(token);
            created = new Date((Long)claims.get((Object)CLAIM_KEY_CREATED));
        }
        catch (Exception e) {
            created = null;
        }
        return created;
    }

    private Date getExpirationDateFromToken(String token) {
        Date expiration;
        try {
            Claims claims = this.getClaimsFromToken(token);
            expiration = claims.getExpiration();
        }
        catch (Exception e) {
            expiration = null;
        }
        return expiration;
    }

    private Claims getClaimsFromToken(String token) {
        Claims claims;
        String secret = this.jsonWebToken.getSecret();
        if (secret == null) {
            return null;
        }
        try {
            claims = (Claims)Jwts.parser().setSigningKey(secret).parseClaimsJws(token).getBody();
        }
        catch (Exception e) {
            claims = null;
        }
        return claims;
    }

    private Date generateExpirationDate() {
        return new Date(System.currentTimeMillis() + this.jsonWebToken.getExpiration() * 1000L);
    }

    private Boolean isTokenExpired(String token) {
        Date expiration = this.getExpirationDateFromToken(token);
        return expiration.before(new Date());
    }

    public String generateToken(UserDetails userDetails) {
        Map<String, Object> map = this.jsonWebTokenEncoder.encode(userDetails);
        String token = this.generateToken(map);
        this.jsonWebTokenReplayAttacksDefiniens.define(userDetails, token);
        return token;
    }

    private String generateToken(Map<String, Object> claims) {
        String secret = this.jsonWebToken.getSecret();
        if (secret == null) {
            return null;
        }
        String token = Jwts.builder().setClaims(claims).setExpiration(this.generateExpirationDate()).signWith(SignatureAlgorithm.HS512, secret).compact();
        return token;
    }

    public Boolean canTokenBeRefreshed(String token, Date lastPasswordReset) {
        Date created = this.getCreatedDateFromToken(token);
        return this.isTokenExpired(token) == false;
    }

    public String refreshToken(String token) {
        String refreshedToken;
        try {
            Claims claims = this.getClaimsFromToken(token);
            claims.put((Object)CLAIM_KEY_CREATED, (Object)new Date());
            refreshedToken = this.generateToken((Map<String, Object>)claims);
        }
        catch (Exception e) {
            refreshedToken = null;
        }
        return refreshedToken;
    }

    public UserDetails validateToken(String token, UserDetails userDetails) {
        String username = this.getUsernameFromToken(token);
        Boolean result = username.equals(userDetails.getUsername()) && this.isTokenExpired(token) == false;
        if (result.booleanValue()) {
            return userDetails;
        }
        return null;
    }

    public UserDetails decodeToken(String token) {
        Claims claims = this.getClaimsFromToken(token);
        if (claims == null || this.isTokenExpired(token).booleanValue()) {
            return null;
        }
        UserDetails userDetails = this.jsonWebTokenDecoder.decode(claims);
        if (userDetails == null) {
            return null;
        }
        this.jsonWebTokenReplayAttacksDetector.detect(token, userDetails);
        return userDetails;
    }
}

