/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.starter.common.sms;

import com.wmeimob.fastboot.autoconfigure.sms.SmsPreSendHandler;
import com.wmeimob.fastboot.autoconfigure.sms.SmsValidator;
import com.wmeimob.fastboot.autoconfigure.sms.aliyun.AliyunSmsProperties;
import com.wmeimob.fastboot.core.exception.CustomException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class SmsSendHandler
implements SmsPreSendHandler,
SmsValidator {
    private static final Logger log = LoggerFactory.getLogger(SmsSendHandler.class);
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    public void process(String mobile, String code, String scene, AliyunSmsProperties aliyunSmsProperties) {
        AliyunSmsProperties.SignTemplate signTemplate = (AliyunSmsProperties.SignTemplate)aliyunSmsProperties.getConfigs().get(scene);
        boolean check = this.stringRedisTemplate.opsForValue().setIfAbsent((Object)("sms:" + mobile + ":lock"), (Object)"lock");
        if (!check) {
            String errMsg = "\u89e6\u53d1[" + ((AliyunSmsProperties.SignTemplate)aliyunSmsProperties.getConfigs().get(scene)).getTimeout() + "s]\u6d41\u63a7";
            log.error(errMsg);
            throw new CustomException(errMsg);
        }
        this.stringRedisTemplate.expire((Object)("sms:" + mobile + ":lock"), (long)((AliyunSmsProperties.SignTemplate)aliyunSmsProperties.getConfigs().get(scene)).getTimeout().intValue(), TimeUnit.SECONDS);
        this.stringRedisTemplate.opsForValue().set((Object)("sms:" + mobile + ":" + scene + ":code"), (Object)code, (long)signTemplate.getExpire().intValue(), TimeUnit.SECONDS);
    }

    public boolean valid(String mobile, String code, String scene) {
        String cache = (String)this.stringRedisTemplate.opsForValue().get((Object)("sms:" + mobile + ":" + scene + ":code"));
        boolean result = Objects.equals(code, cache);
        if (result && code != null) {
            this.stringRedisTemplate.delete((Object)("sms:" + mobile + ":" + scene + ":code"));
            return result;
        }
        return false;
    }
}

