/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.starter.common.service;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.starter.common.entity.RichText;
import com.wmeimob.fastboot.starter.common.mapper.RichTextMapper;
import com.wmeimob.fastboot.starter.common.service.RichTextAuthChecker;
import com.wmeimob.fastboot.starter.common.service.RichTextService;
import javax.annotation.Resource;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="richTextCommonServiceImpl")
public class RichTextCommonServiceImpl
implements RichTextService {
    @Resource
    private RichTextMapper richTextMapper;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RichText findById(Integer id) {
        String key = String.format("richText:%s", id);
        RichText richText = (RichText)JSONObject.parseObject((String)((String)this.stringRedisTemplate.opsForValue().get((Object)key)), RichText.class);
        if (richText == null) {
            String string = key.intern();
            synchronized (string) {
                richText = (RichText)JSONObject.parseObject((String)((String)this.stringRedisTemplate.opsForValue().get((Object)key)), RichText.class);
                if (richText == null) {
                    richText = (RichText)this.richTextMapper.selectByPrimaryKey(id);
                    this.stringRedisTemplate.opsForValue().set((Object)key, (Object)JSONObject.toJSONString((Object)richText));
                }
            }
        }
        return richText;
    }

    @Override
    public RichText securityGet(Integer id, RichTextAuthChecker richTextAuthChecker) {
        if (0 == id) {
            return new RichText();
        }
        RichText richText = this.findById(id);
        if (richText != null && richText.getDataId() != null) {
            boolean validResult = richTextAuthChecker.assertHasAuth(richText.getDataId());
            return validResult ? richText : null;
        }
        return richText;
    }
}

