/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.starter.common.controller;

import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.wmeimob.fastboot.autoconfigure.oss.AliyunOss;
import com.wmeimob.fastboot.autoconfigure.oss.AliyunOssProperties;
import com.wmeimob.fastboot.autoconfigure.qiniu.QiNiu;
import com.wmeimob.fastboot.autoconfigure.qiniu.QiNiuProperties;
import com.wmeimob.fastboot.autoconfigure.sms.aliyun.AliyunSms;
import com.wmeimob.fastboot.autoconfigure.sms.aliyun.AliyunSmsProperties;
import com.wmeimob.fastboot.autoconfigure.upload.UploadFileProperies;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.starter.common.entity.RichText;
import com.wmeimob.fastboot.starter.common.service.RichTextService;
import com.wmeimob.fastboot.starter.common.sms.SmsSendHandler;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.RandomCodeUtil;
import com.wmeimob.fastboot.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"common"})
public class CommonController {
    private static final Logger log = LoggerFactory.getLogger(CommonController.class);
    @Resource
    private QiNiuProperties qiNiuProperties;
    @Resource
    private AliyunSmsProperties aliyunSmsProperties;
    @Resource
    private AliyunOssProperties aliyunOssProperties;
    @Resource
    private SmsSendHandler smsSendHandler;
    @Resource
    private UploadFileProperies uploadFileProperies;
    @Resource(name="richTextCommonServiceImpl")
    private RichTextService richTextCommonServiceImpl;
    private static final String REG_SCENE = "reg";

    @GetMapping(value={"rich-text/{id}"})
    public RichText getById(@PathVariable(value="id") Integer id) {
        RichText richText = this.richTextCommonServiceImpl.securityGet(id, dataId -> true);
        if (richText == null) {
            return new RichText();
        }
        return richText;
    }

    @GetMapping(value={"qiniu-token"})
    public Map<String, String> getQiniuToken() {
        QiNiu qiNiu = new QiNiu(this.qiNiuProperties);
        String token = qiNiu.getUploadToken();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("uploadToken", token);
        map.put("domain", this.qiNiuProperties.getDomain());
        return map;
    }

    @GetMapping(value={"oss-token"})
    public Map<String, String> ossToken() {
        return AliyunOss.getInstance((AliyunOssProperties)this.aliyunOssProperties).uploadParameters();
    }

    @PostMapping(value={"upload"})
    public String upload(@RequestParam(value="file") MultipartFile multipartFile, String scene) {
        UploadFileProperies.UploadFileConfig config = (UploadFileProperies.UploadFileConfig)this.uploadFileProperies.getConfigs().get(scene);
        if (config == null) {
            throw new CustomException("can not found scene config");
        }
        File file = new File(config.getDir());
        if (!file.exists()) {
            file.mkdirs();
        }
        String fileName = RandomCodeUtil.randCode((int)32);
        byte[] buff = new byte[4096];
        try (FileOutputStream output = new FileOutputStream(config.getDir() + fileName);){
            InputStream input = multipartFile.getInputStream();
            int bytecount = 1;
            while ((bytecount = input.read(buff, 0, 4096)) != -1) {
                output.write(buff, 0, bytecount);
            }
        }
        catch (IOException e) {
            log.error("create file io exception");
        }
        String result = (config.isSecure() ? "https" : "http") + "://" + config.getDomain() + (StringUtils.isEmpty((Object)config.getVisitPrefix()) ? "" : config.getVisitPrefix()) + "/" + fileName;
        return result;
    }

    @GetMapping(value={"reg-sms"})
    public RestResult sendRegSms(String mobile) {
        if (!InputValidator.isMobile((String)mobile)) {
            return RestResult.fail((String)"\u4e0d\u6b63\u786e\u7684\u624b\u673a\u53f7\u7801");
        }
        String code = RandomCodeUtil.randCodeNum((int)((AliyunSmsProperties.SignTemplate)this.aliyunSmsProperties.getConfigs().get(REG_SCENE)).getLength());
        this.smsSendHandler.process(mobile, code, REG_SCENE, this.aliyunSmsProperties);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("code", code);
        try {
            SendSmsResponse resp = AliyunSms.getInstance((AliyunSmsProperties)this.aliyunSmsProperties).sendSms(mobile, paramMap, REG_SCENE);
            log.info(JSONObject.toJSONString((Object)resp));
        }
        catch (ClientException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return RestResult.success();
    }
}

