/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.starter.admin.service;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.starter.common.entity.RichText;
import com.wmeimob.fastboot.starter.common.mapper.RichTextMapper;
import com.wmeimob.fastboot.starter.common.service.RichTextService;
import com.wmeimob.fastboot.util.StringUtils;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="richTextServiceImpl")
public class RichTextServiceImpl
implements RichTextService {
    @Resource
    private RichTextMapper richTextMapper;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    public void add(RichText richText) {
        if (richText.getDataId() == null) {
            throw new CustomException("missing data id reference");
        }
        richText.setContent(this.filter(richText.getContent()));
        richText.setGmtCreate(new Date());
        this.richTextMapper.insertSelective((Object)richText);
        this.stringRedisTemplate.opsForValue().set((Object)String.format("richText:%s", richText.getId()), (Object)JSONObject.toJSONString((Object)richText));
    }

    public int delete(Integer id) {
        int result = this.richTextMapper.deleteByPrimaryKey((Object)id);
        if (result > 0) {
            this.stringRedisTemplate.delete((Object)String.format("richText:%s", id));
        }
        return result;
    }

    private String filter(String content) {
        if (!StringUtils.isEmpty((Object)content)) {
            content = content.replace("<script>", "").replace("javascript", "").replace("$", "").replace("#", "").replace("--", "");
        }
        return content;
    }

    public int update(RichText richText) {
        richText.setDataId(null);
        richText.setContent(this.filter(richText.getContent()));
        richText.setGmtModified(new Date());
        int result = this.richTextMapper.updateByPrimaryKeySelective((Object)richText);
        if (result > 0) {
            this.stringRedisTemplate.delete((Object)String.format("richText:%s", richText.getId()));
        }
        return result;
    }
}

