/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.starter.admin.security;

import com.alibaba.fastjson.JSONArray;
import com.wmeimob.fastboot.starter.admin.entity.SysUser;
import com.wmeimob.fastboot.starter.admin.entity.SysUserDataRole;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;

@Component
public class DataAuthHelper {
    public static final String DATA_AUTH_BY_MP_ID = "BY_MP_ID";
    private final StringRedisTemplate redisTemplate;

    @Autowired
    public DataAuthHelper(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public String getMpId(UserDetails userDetails) {
        return this.getByUserDetails(userDetails, DATA_AUTH_BY_MP_ID);
    }

    public String getMpId() {
        return this.getByUserDetails(DATA_AUTH_BY_MP_ID);
    }

    public String getByUserDetails(String authCode) {
        SysUser userDetails = (SysUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        List sysUserDataRoleList = JSONArray.parseArray((String)((String)this.redisTemplate.opsForValue().get((Object)("userDataRoles:" + userDetails.getUsername()))), SysUserDataRole.class);
        if (sysUserDataRoleList == null) {
            return null;
        }
        for (SysUserDataRole sysUserDataRole : sysUserDataRoleList) {
            if (!authCode.equals(sysUserDataRole.getDataRoleCode())) continue;
            return sysUserDataRole.getColumnValue();
        }
        return null;
    }

    public String getByUserDetails(UserDetails userDetails, String authCode) {
        List sysUserDataRoleList = JSONArray.parseArray((String)((String)this.redisTemplate.opsForValue().get((Object)("userDataRoles:" + userDetails.getUsername()))), SysUserDataRole.class);
        if (sysUserDataRoleList == null) {
            return null;
        }
        for (SysUserDataRole sysUserDataRole : sysUserDataRoleList) {
            if (!authCode.equals(sysUserDataRole.getDataRoleCode())) continue;
            return sysUserDataRole.getColumnValue();
        }
        return null;
    }
}

