/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.starter.admin.controller;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.starter.common.entity.RichText;
import com.wmeimob.fastboot.starter.common.service.RichTextService;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"rich-text"})
public class RichTextController {
    @Resource(name="richTextServiceImpl")
    private RichTextService richTextService;
    @Resource(name="richTextCommonServiceImpl")
    private RichTextService richTextCommonServiceImpl;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @DeleteMapping(value={"{id}"})
    public RestResult deleteById(@PathVariable(value="id") Integer id) {
        RichText richText = this.richTextCommonServiceImpl.securityGet(id, dataId -> true);
        if (richText == null) {
            return RestResult.fail((String)"\u60a8\u65e0\u6743\u8fdb\u884c\u6b64\u64cd\u4f5c");
        }
        return this.richTextService.delete(id) > 0 ? RestResult.success() : RestResult.fail();
    }

    @PostMapping
    public RestResult add(@RequestBody RichText richText) {
        this.checkInput(richText);
        this.richTextService.add(richText);
        HashMap<String, Integer> map = new HashMap<String, Integer>(1);
        map.put("id", richText.getId());
        return RestResult.success(map);
    }

    @PutMapping(value={"{id}"})
    public RestResult update(@PathVariable(value="id") Integer id, @RequestBody RichText richText) {
        this.checkInput(richText);
        RichText query = this.richTextCommonServiceImpl.securityGet(id, dataId -> true);
        if (query == null) {
            return RestResult.fail((String)"\u60a8\u65e0\u6743\u8fdb\u884c\u6b64\u64cd\u4f5c");
        }
        return this.richTextService.update(richText) > 0 ? RestResult.success() : RestResult.fail();
    }

    private void checkInput(RichText richText) {
        if (richText.getDataId() == null) {
            throw new CustomException("\u4e22\u5931\u6570\u636e\u5f15\u7528");
        }
    }

    @GetMapping(value={"preview"})
    public String getPreview(String id) {
        RichText richText = (RichText)JSONObject.parseObject((String)((String)this.stringRedisTemplate.opsForValue().get((Object)String.format("richText:%s", id))), RichText.class);
        if (richText == null) {
            return "";
        }
        return richText.getContent();
    }

    @PostMapping(value={"preview"})
    public String addPreview(RichText richText) {
        String id = UUID.randomUUID().toString();
        this.stringRedisTemplate.opsForValue().set((Object)String.format("richText:%s", id), (Object)JSONObject.toJSONString((Object)richText), 1L, TimeUnit.HOURS);
        return id;
    }
}

