/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.excel;

import com.wmeimob.fastboot.excel.DataConvert;
import com.wmeimob.fastboot.excel.DataTypeConverter;
import com.wmeimob.fastboot.excel.ExcelExport;
import com.wmeimob.fastboot.excel.ExcelImport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class ExcelHelper {
    public static <T> HSSFWorkbook exportFromList(List<T> srcList, Map<String, DataConvert<T>> convertMap, String[] headNames, String[] dataFieldNames, Class<T> tClass) throws IOException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        return ExcelHelper.exportFromList(srcList, convertMap, headNames, (T obj) -> {
            ArrayList<String> objectFieldValues = new ArrayList<String>();
            for (int i = 0; i < dataFieldNames.length; ++i) {
                Field field = ExcelHelper.getField(tClass, dataFieldNames[i]);
                String val = DataTypeConverter.parseString(field.get(obj));
                if (convertMap != null && convertMap.get(dataFieldNames[i]) != null) {
                    val = ((DataConvert)convertMap.get(dataFieldNames[i])).convert(val, obj);
                }
                objectFieldValues.add(val);
            }
            return objectFieldValues;
        });
    }

    public static <T> HSSFWorkbook exportFromList(List<T> srcList, String[] headNames, String[] dataFieldNames, Class<T> tClass) throws IOException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        return ExcelHelper.exportFromList(srcList, null, headNames, dataFieldNames, tClass);
    }

    private static Field getField(Class tClass, String fieldName) {
        Field field;
        block5: {
            field = null;
            try {
                field = tClass.getDeclaredField(fieldName);
                field.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                Class sClass = tClass.getSuperclass();
                if (sClass == Object.class) {
                    try {
                        throw new NoSuchFieldException(e.getMessage());
                    }
                    catch (NoSuchFieldException e1) {
                        e1.printStackTrace();
                        break block5;
                    }
                }
                return ExcelHelper.getField(sClass, fieldName);
            }
        }
        return field;
    }

    public static <T> HSSFWorkbook exportFromList(List<T> srcList, Map<String, DataConvert<T>> convertMap, String[] headNames, ExcelExport<T> excelExport) throws NoSuchFieldException, IllegalAccessException {
        HSSFCell cell;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("sheet1");
        HSSFRow row0 = sheet.createRow(0);
        HSSFCellStyle cellStyle = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setBoldweight((short)700);
        cellStyle.setFont(font);
        cellStyle.setAlignment((short)2);
        for (int i = 0; i < headNames.length; ++i) {
            cell = row0.createCell(i);
            cell.setCellValue(headNames[i]);
            cell.setCellStyle(cellStyle);
        }
        HSSFCellStyle dataCellStyle = wb.createCellStyle();
        for (int i = 0; i < srcList.size(); ++i) {
            HSSFRow row = sheet.createRow(i + 1);
            T obj = srcList.get(i);
            List<String> columns = excelExport.getColumns(obj);
            for (int j = 0; j < columns.size(); ++j) {
                cell = row.createCell(j);
                cell.setCellValue(columns.get(j));
                cell.setCellStyle(dataCellStyle);
                sheet.setDefaultColumnStyle(j, (CellStyle)cellStyle);
            }
        }
        return wb;
    }

    public static <T> void exportFromListToStream(List<T> list, String[] heads, String[] fieldStr, Class<T> tClass, String fileName, HttpServletResponse response) throws NoSuchFieldException, InstantiationException, IllegalAccessException, IOException {
        ExcelHelper.exportFromListToStream(list, null, heads, fieldStr, tClass, fileName, response);
    }

    public static <T> void exportFromListToStream(List<T> list, Map<String, DataConvert<T>> convertMap, String[] heads, String[] fieldStr, Class<T> tClass, String fileName, HttpServletResponse response) throws NoSuchFieldException, InstantiationException, IllegalAccessException, IOException {
        HSSFWorkbook wb = ExcelHelper.exportFromList(list, convertMap, heads, fieldStr, tClass);
        ServletOutputStream out = response.getOutputStream();
        response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(fileName + ".xls", "UTF-8"));
        wb.write((OutputStream)out);
        out.close();
    }

    public static <T> List<T> importFromInputStream(String fileName, InputStream inputStream, Class<T> tClass, String ... fieldsArr) throws Exception {
        return ExcelHelper.importFromInputStream(fileName, inputStream, fieldsArr.length, (List<String> columns) -> {
            Object t = tClass.newInstance();
            ArrayList list = new ArrayList();
            for (int i = 0; i < fieldsArr.length; ++i) {
                Field field = ExcelHelper.getField(tClass, fieldsArr[i]);
                field.setAccessible(true);
                Object value = DataTypeConverter.parse(field.getType(), (String)columns.get(i));
                field.set(t, value);
            }
            list.add(t);
            return list;
        });
    }

    public static <T> List<T> importFromInputStream(InputStream inputStream, Class<T> tClass, String ... fieldsArr) throws Exception {
        return ExcelHelper.importFromInputStream("", inputStream, tClass, fieldsArr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> importFromInputStream(String fileName, InputStream inputStream, int cellSize, ExcelImport<T> excelImport) throws Exception {
        Object wb = null;
        try {
            wb = fileName.contains(".xlsx") ? new XSSFWorkbook(inputStream) : new HSSFWorkbook(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        Sheet sheet = wb.getSheetAt(0);
        ArrayList<T> list = new ArrayList<T>();
        for (int i = sheet.getFirstRowNum() + 1; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            ArrayList<String> columns = new ArrayList<String>();
            boolean allFieldValidFlag = false;
            for (int j = row.getFirstCellNum(); j < cellSize; ++j) {
                Cell cell = row.getCell(j);
                if (cell == null) {
                    columns.add("");
                    continue;
                }
                String val = "";
                if (cell != null) {
                    cell.setCellType(1);
                    val = cell.getStringCellValue();
                }
                if (val != null && !"".equals(val) && !"".equals(val.trim())) {
                    allFieldValidFlag = true;
                }
                columns.add(val);
            }
            if (!allFieldValidFlag) continue;
            List<T> t = excelImport.getObjList(columns);
            list.addAll(t);
        }
        return list;
    }
}

