/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.excel;

import com.wmeimob.fastboot.excel.DateTypeEnum;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DataTypeConverter {
    private static ThreadLocal<DateFormat> fullDateFormat = DataTypeConverter.initDateFormatThreadLocal("yyyy-MM-dd HH:mm:ss");
    private static ThreadLocal<DateFormat> liteDateFormat = DataTypeConverter.initDateFormatThreadLocal("yyyy-MM-dd");
    private static ThreadLocal<DateFormat> minutesDateFormat = DataTypeConverter.initDateFormatThreadLocal("yyyy-MM-dd HH:mm");
    private static ThreadLocal<DateFormat> hoursDateFormat = DataTypeConverter.initDateFormatThreadLocal("yyyy-MM-dd HH");
    private static ThreadLocal<DateFormat> monthDateFormat = DataTypeConverter.initDateFormatThreadLocal("yyyy-MM");

    public static Object parse(Class expectType, String value) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String typeName = expectType.getSimpleName();
        Method method = DataTypeConverter.class.getDeclaredMethod("parse" + typeName, String.class);
        return method.invoke(null, value);
    }

    private static Short parseShort(String val) {
        return Short.parseShort(val);
    }

    private static BigDecimal parseBigDecimal(String val) {
        return new BigDecimal(val);
    }

    private static ThreadLocal<DateFormat> initDateFormatThreadLocal(String pattern) {
        return ThreadLocal.withInitial(() -> new SimpleDateFormat(pattern));
    }

    private static Date parseDate(String val) throws ParseException {
        if ("".equals(val) || null == val) {
            return null;
        }
        String[] dateTimeSpaceArr = val.split(" ");
        if (dateTimeSpaceArr.length == 0) {
            return null;
        }
        if (dateTimeSpaceArr.length == 1) {
            String[] dateSpace = dateTimeSpaceArr[0].split("-");
            if (dateSpace.length == 1) {
                dateSpace = dateTimeSpaceArr[0].split("/");
            }
            assert (dateSpace.length > 1);
            return dateSpace.length == 2 ? monthDateFormat.get().parse(val) : liteDateFormat.get().parse(val);
        }
        if (dateTimeSpaceArr.length == 2) {
            String[] timeSpace = dateTimeSpaceArr[1].split(":");
            if (timeSpace.length == 1) {
                return hoursDateFormat.get().parse(val);
            }
            if (timeSpace.length == 2) {
                return minutesDateFormat.get().parse(val);
            }
            if (timeSpace.length == 3) {
                return fullDateFormat.get().parse(val);
            }
        }
        return null;
    }

    private static Integer parseInteger(String val) {
        return Integer.valueOf(val);
    }

    private static String parseString(String val) {
        return val;
    }

    private static Boolean parseBoolean(String val) {
        if ("".equals(val) || null == val) {
            return null;
        }
        if ("1".equals(val) || "\u662f".equals(val) || "\u7537".equals(val)) {
            return true;
        }
        return Boolean.valueOf(val);
    }

    public static String formatLite(Date date) {
        return DataTypeConverter.format(liteDateFormat, date);
    }

    public static String formatFull(Date date) {
        return DataTypeConverter.format(fullDateFormat, date);
    }

    private static String format(ThreadLocal<DateFormat> threadLocal, Date date) {
        return threadLocal.get().format(date);
    }

    private static Byte parseByte(String val) {
        return Byte.parseByte(val);
    }

    public static <T> String parseString(T t, DateTypeEnum typeEnums) {
        if (t == null) {
            return "";
        }
        if (t instanceof Date) {
            if (DateTypeEnum.ONLY_DATE.equals((Object)typeEnums)) {
                return DataTypeConverter.formatLite((Date)t);
            }
            return DataTypeConverter.formatFull((Date)t);
        }
        if (t instanceof Boolean) {
            return (Boolean)t != false ? "\u662f" : "\u5426";
        }
        return t.toString();
    }

    public static <T> String parseString(T t) {
        return DataTypeConverter.parseString(t, null);
    }
}

