/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.autoconfigure.sms.aliyun;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.wmeimob.fastboot.autoconfigure.sms.aliyun.AliyunSmsProperties;
import java.util.Map;

public class AliyunSms {
    static final String product = "Dysmsapi";
    static final String domain = "dysmsapi.aliyuncs.com";
    static final String regionId = "cn-hangzhou";
    private static volatile AliyunSms aliyunSms;
    private AliyunSmsProperties properties;
    private static volatile IClientProfile profile;
    private static volatile IAcsClient acsClient;

    private AliyunSms() {
    }

    private AliyunSms(AliyunSmsProperties properties) {
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AliyunSms getInstance(AliyunSmsProperties properties) {
        if (aliyunSms != null) return aliyunSms;
        Class<AliyunSms> clazz = AliyunSms.class;
        synchronized (AliyunSms.class) {
            if (aliyunSms != null) return aliyunSms;
            aliyunSms = new AliyunSms(properties);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return aliyunSms;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IClientProfile profile() {
        if (profile != null) return profile;
        Class<AliyunSms> clazz = AliyunSms.class;
        synchronized (AliyunSms.class) {
            if (profile != null) return profile;
            profile = DefaultProfile.getProfile((String)regionId, (String)this.properties.getAccessKey(), (String)this.properties.getAccessSecret());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return profile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IAcsClient acsClient() {
        if (acsClient != null) return acsClient;
        Class<AliyunSms> clazz = AliyunSms.class;
        synchronized (AliyunSms.class) {
            if (acsClient != null) return acsClient;
            acsClient = new DefaultAcsClient(this.profile());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return acsClient;
        }
    }

    public SendSmsResponse sendSms(String tel, Map<String, String> paramMap, String scene) throws ClientException {
        DefaultProfile.addEndpoint((String)regionId, (String)regionId, (String)product, (String)domain);
        SendSmsRequest request = new SendSmsRequest();
        AliyunSmsProperties.SignTemplate signTemplate = this.properties.getConfigs().get(scene);
        request.setPhoneNumbers(tel);
        request.setSignName(signTemplate.getSign());
        request.setTemplateCode(signTemplate.getTemplateCode());
        StringBuilder sb = new StringBuilder("{");
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            sb.append("\"" + entry.getKey() + "\":\"" + entry.getValue() + "\",");
        }
        String sbStr = sb.substring(0, sb.length() - 1);
        sbStr = sbStr + "}";
        request.setTemplateParam(sbStr);
        SendSmsResponse sendSmsResponse = (SendSmsResponse)this.acsClient().getAcsResponse((AcsRequest)request);
        return sendSmsResponse;
    }

    static {
        profile = null;
        acsClient = null;
    }
}

