/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.autoconfigure.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.PolicyConditions;
import com.wmeimob.fastboot.autoconfigure.oss.AliyunOssProperties;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class AliyunOss {
    private AliyunOssProperties aliyunOssProperties;
    private static volatile AliyunOss aliyunOss;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AliyunOss getInstance(AliyunOssProperties aliyunOssProperties) {
        if (aliyunOss != null) return aliyunOss;
        Class<AliyunOss> clazz = AliyunOss.class;
        synchronized (AliyunOss.class) {
            if (aliyunOss != null) return aliyunOss;
            aliyunOss = new AliyunOss();
            AliyunOss.aliyunOss.aliyunOssProperties = aliyunOssProperties;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return aliyunOss;
        }
    }

    public Map<String, String> uploadParameters() {
        OSSClient client = new OSSClient(this.aliyunOssProperties.getEndpoint(), this.aliyunOssProperties.getAccessId(), this.aliyunOssProperties.getAccessKey());
        LinkedHashMap<String, String> respMap = new LinkedHashMap<String, String>();
        try {
            long expireEndTime = System.currentTimeMillis() + (long)(this.aliyunOssProperties.getExpire() * 1000);
            Date expiration = new Date(expireEndTime);
            PolicyConditions policyConds = new PolicyConditions();
            policyConds.addConditionItem("content-length-range", 0L, (long)(this.aliyunOssProperties.getMaxSize() * 1024 * 1024));
            policyConds.addConditionItem(MatchMode.StartWith, "key", this.aliyunOssProperties.getDir());
            String postPolicy = client.generatePostPolicy(expiration, policyConds);
            byte[] binaryData = postPolicy.getBytes("utf-8");
            String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
            String postSignature = client.calculatePostSignature(postPolicy);
            respMap.put("accessid", this.aliyunOssProperties.getAccessId());
            respMap.put("policy", encodedPolicy);
            respMap.put("signature", postSignature);
            respMap.put("dir", this.aliyunOssProperties.getDir());
            String host = (this.aliyunOssProperties.isSecure() ? "https" : "http") + "://" + this.aliyunOssProperties.getBucket() + "." + this.aliyunOssProperties.getEndpoint();
            respMap.put("host", host);
            respMap.put("expire", String.valueOf(expireEndTime / 1000L));
            if (this.aliyunOssProperties.isCdnEnabled()) {
                respMap.put("cdnDomain", this.aliyunOssProperties.getCdnDomain());
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return respMap;
    }
}

