/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.wechat.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Camel2Underline {
    private static final Pattern UNDERLINE_2_CAMEL_PATTERN = Pattern.compile("([A-Za-z\\d]+)(_)?");
    private static final Pattern CAMEL_2_UNDERLINE_PATTERN = Pattern.compile("([A-Za-z\\d]+)(_)?");
    private static final String UNDERLINE = "_";
    private static final String EMPTY_STR = "";

    private Camel2Underline() {
    }

    public static String underline2Camel(String line, boolean smallCamel) {
        if (line == null || line.length() == 0) {
            return EMPTY_STR;
        }
        if (!(line = line.toLowerCase()).contains(UNDERLINE)) {
            if (!smallCamel) {
                char[] cs = line.toCharArray();
                cs[0] = (char)(cs[0] - 32);
                return String.valueOf(cs);
            }
            return line;
        }
        StringBuffer sb = new StringBuffer();
        Matcher matcher = UNDERLINE_2_CAMEL_PATTERN.matcher(line);
        while (matcher.find()) {
            String word = matcher.group();
            sb.append(smallCamel && matcher.start() == 0 ? Character.toLowerCase(word.charAt(0)) : Character.toUpperCase(word.charAt(0)));
            int index = word.lastIndexOf(UNDERLINE);
            if (index > 0) {
                sb.append(word.substring(1, index).toLowerCase());
                continue;
            }
            sb.append(word.substring(1).toLowerCase());
        }
        return sb.toString();
    }

    public static String camel2Underline(String line, boolean smallUnderline) {
        if (line == null || line.length() == 0) {
            return EMPTY_STR;
        }
        line = String.valueOf(line.charAt(0)).toUpperCase().concat(line.substring(1));
        StringBuffer sb = new StringBuffer();
        Matcher matcher = CAMEL_2_UNDERLINE_PATTERN.matcher(line);
        while (matcher.find()) {
            String word = matcher.group();
            sb.append(word.toUpperCase());
            sb.append(matcher.end() == line.length() ? EMPTY_STR : UNDERLINE);
        }
        return smallUnderline ? sb.toString().toLowerCase() : sb.toString();
    }
}

