/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.wechat.open.message;

import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mzlion.core.lang.StringUtils;
import com.mzlion.easyokhttp.HttpClient;
import com.mzlion.easyokhttp.request.TextBodyRequest;
import com.wmeimob.wechat.interfaces.Receiver;
import com.wmeimob.wechat.open.exception.MsgEventHandlerNotFoundException;
import com.wmeimob.wechat.open.message.MsgEventReceiver;
import com.wmeimob.wechat.open.message.handler.AbstractMsgEventHandler;
import com.wmeimob.wechat.open.model.Wechat3rdPlatform;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import me.hao0.wechat.model.message.receive.RecvMessage;
import me.hao0.wechat.model.message.receive.RecvMessageType;
import me.hao0.wechat.model.message.receive.event.RecvEvent;
import me.hao0.wechat.model.message.receive.event.RecvEventType;
import me.hao0.wechat.model.message.receive.msg.RecvMsg;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import okhttp3.Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgEventHandlerProxy
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(MsgEventHandlerProxy.class);
    private static final String INTERCEPTOR_METHOD_NAME = "execute";
    private static final ThreadFactory MSG_EVENT_HANDLER_THREAD = new ThreadFactoryBuilder().setNameFormat("WechatMsgEventHandler-pool-%d").build();
    private static final ScheduledThreadPoolExecutor SCHEDULED_THREAD_POOL_EXECUTOR = new ScheduledThreadPoolExecutor(10, MSG_EVENT_HANDLER_THREAD);

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if (Objects.equals(INTERCEPTOR_METHOD_NAME, method.getName())) {
            AbstractMsgEventHandler msgEventHandler = (AbstractMsgEventHandler)obj;
            Wechat3rdPlatform wechat3rdPlatform = msgEventHandler.getWechat3rdPlatform();
            RecvMessage recvMessage = msgEventHandler.getRecvEntity();
            RecvMessageType type = RecvMessageType.from((String)recvMessage.getMsgType());
            Wechat3rdPlatform.RemoteServices remoteServices = null;
            Map<String, Wechat3rdPlatform.RemoteServices> servicesMap = null;
            if (RecvMessageType.EVENT.equals((Object)type)) {
                RecvEvent recvEvent = (RecvEvent)recvMessage;
                servicesMap = wechat3rdPlatform.getRemote().getEvent();
                if (servicesMap == null) {
                    throw new MsgEventHandlerNotFoundException("can not invoke event " + recvEvent.getEventType() + " cause there is no  event handlers found");
                }
                remoteServices = servicesMap.get(RecvEventType.from((String)recvEvent.getEventType()).name());
                if (remoteServices == null) {
                    throw new MsgEventHandlerNotFoundException("can not invoke event " + recvEvent.getEventType() + " cause configs is null");
                }
            } else {
                RecvMsg recvMsg = (RecvMsg)recvMessage;
                servicesMap = wechat3rdPlatform.getRemote().getMsg();
                if (servicesMap == null) {
                    throw new MsgEventHandlerNotFoundException("can not invoke msg " + recvMsg.getMsgType() + " cause there is no  msg handlers found ");
                }
                remoteServices = servicesMap.get(RecvMessageType.from((String)recvMsg.getMsgType()).name());
                if (remoteServices == null) {
                    throw new MsgEventHandlerNotFoundException("can not invoke msg " + recvMsg.getMsgType() + " cause configs is null");
                }
            }
            return this.invoke(msgEventHandler, remoteServices);
        }
        return proxy.invokeSuper(obj, args);
    }

    private String getSchema(boolean enabled) {
        return enabled ? "https" : "http";
    }

    private String invoke(AbstractMsgEventHandler msgEventHandler, Wechat3rdPlatform.RemoteServices remoteServices) {
        Wechat3rdPlatform wechat3rdPlatform = msgEventHandler.getWechat3rdPlatform();
        log.info("remoteServices is {}", (Object)JSONObject.toJSONString((Object)remoteServices));
        ArrayList<Receiver> receivers = new ArrayList<Receiver>();
        for (Map.Entry<String, Wechat3rdPlatform.RemoteConfig> entry : remoteServices.getConfigs().entrySet()) {
            Wechat3rdPlatform.RemoteConfig config = entry.getValue();
            log.info("config info is => {}", (Object)JSONObject.toJSONString((Object)config));
            boolean balancedMethod = false;
            if (!StringUtils.isEmpty((String)config.getServiceName())) {
                balancedMethod = true;
            }
            if (StringUtils.isEmpty((String)config.getServiceName()) && StringUtils.isEmpty((String)config.getUrl())) {
                balancedMethod = true;
                config.setServiceName(entry.getKey());
            }
            if (!config.isEnabled()) continue;
            String url = balancedMethod ? this.getSchema(config.isEnabledSecure()) + "://" + config.getServiceName() + config.getRoute() : config.getUrl();
            log.info("request url is {} ,param is {}", (Object)url, (Object)JSONObject.toJSONString((Object)msgEventHandler.getRecvEntity()));
            Wechat3rdPlatform.Basic basic = wechat3rdPlatform.getSecurity().getBasic();
            TextBodyRequest textBodyRequest = HttpClient.textBody((String)(url + "?appid=" + msgEventHandler.getAppid()));
            if (basic.isEnabled()) {
                textBodyRequest.header("Authorization", Credentials.basic((String)basic.getUsername(), (String)basic.getPassword()));
            }
            Receiver receiver = () -> textBodyRequest.json(JSONObject.toJSONString((Object)msgEventHandler.getRecvEntity())).asString();
            boolean globalAsync = wechat3rdPlatform.getRemote().isAsync();
            boolean msgEventAsync = remoteServices.isAsync();
            boolean configAsync = config.isAsync();
            if (globalAsync || msgEventAsync || configAsync) {
                receivers.add(() -> {
                    SCHEDULED_THREAD_POOL_EXECUTOR.execute(receiver::call);
                    return "success";
                });
                continue;
            }
            receivers.add(receiver);
        }
        MsgEventReceiver msgEventReceiver = MsgEventReceiver.newInstance(msgEventHandler.getWechat3rdPlatform(), receivers.toArray(new Receiver[0]));
        return msgEventReceiver.process();
    }
}

