/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.wechat.open.loader;

import com.wmeimob.wechat.open.loader.Loader;
import com.wmeimob.wechat.open.model.AuthorizationInfo;
import java.util.HashMap;
import java.util.Map;
import me.hao0.wechat.model.base.AccessToken;

public interface WechatAuthorizerAccessTokenLoader
extends Loader {
    public static final Map<String, AccessToken> ACCESS_TOKEN_MAP = new HashMap<String, AccessToken>();

    default public AccessToken get(String appid) {
        AccessToken accessToken = ACCESS_TOKEN_MAP.get(appid);
        if (accessToken != null && System.currentTimeMillis() < accessToken.getExpiredAt()) {
            return accessToken;
        }
        return null;
    }

    default public void set(AuthorizationInfo authorizationInfo) {
        Long validTime = (long)(authorizationInfo.getExpiresIn() - 600) * 1000L;
        authorizationInfo.setExpiredAt(System.currentTimeMillis() + validTime);
        AccessToken accessToken = new AccessToken();
        accessToken.setAccessToken(authorizationInfo.getAuthorizerAccessToken());
        accessToken.setExpiredAt(authorizationInfo.getExpiredAt());
        accessToken.setExpire(authorizationInfo.getExpiresIn());
        ACCESS_TOKEN_MAP.put(authorizationInfo.getAuthorizerAppid(), accessToken);
    }
}

