/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.wechat.open.core.miniprogram;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.wechat.open.core.Component;
import com.wmeimob.wechat.open.exception.LoaderNotFoundException;
import com.wmeimob.wechat.open.model.AccountBasicInfo;
import com.wmeimob.wechat.open.model.CanSetCategoryResponse;
import com.wmeimob.wechat.open.model.CategoryAddRequest;
import com.wmeimob.wechat.open.model.CategoryGetResponse;
import com.wmeimob.wechat.open.model.CheckWxVerifyNicknameResponse;
import com.wmeimob.wechat.open.model.ModifyHeadImageRequest;
import com.wmeimob.wechat.open.model.QueryNicknameStateResponse;
import com.wmeimob.wechat.open.model.SetNicknameRequest;
import com.wmeimob.wechat.open.model.SetNicknameResponse;

public class Copy
extends Component {
    private static final String GET_ACCOUNT_BASIC_INFO = "https://api.weixin.qq.com/cgi-bin/account/getaccountbasicinfo?access_token=";
    private static final String POST_SET_NICKNAME = "https://api.weixin.qq.com/wxa/setnickname?access_token=";
    private static final String POST_QUERY_NICKNAME_STATE = "https://api.weixin.qq.com/wxa/api_wxa_querynickname?access_token=";
    private static final String POST_CHECK_WX_VERIFY_NICKNAME = "https://api.weixin.qq.com/cgi-bin/wxverify/checkwxverifynickname?access_token=";
    private static final String POST_MODIFY_HEAD_IMAGE = "https://api.weixin.qq.com/cgi-bin/account/modifyheadimage?access_token=";
    private static final String POST_MODIFY_SIGNATURE = "https://api.weixin.qq.com/cgi-bin/account/modifysignature?access_token=";
    private static final String POST_REBIND_ADMIN = "https://api.weixin.qq.com/cgi- bin/account/componentrebindadmin?access_token=";
    private static final String GET_ALL_CAN_SET_CATEGORIES = "https://api.weixin.qq.com/cgi-bin/wxopen/getallcategories?access_token=";
    private static final String POST_ADD_CATEGORY = "https://api.weixin.qq.com/cgi-bin/wxopen/addcategory?access_token=";
    private static final String POST_DELETE_CATEGORY = "https://api.weixin.qq.com/cgi-bin/wxopen/deletecategory?access_token=";
    private static final String GET_CATEGORY = "https://api.weixin.qq.com/cgi-bin/wxopen/getcategory?access_token=";
    private static final String POST_MODIFY_CATEGORY = "https://api.weixin.qq.com/cgi-bin/wxopen/modifycategory?access_token=";

    protected Copy(Component component) {
        super(component);
    }

    public AccountBasicInfo getAccountBasicInfo(String appid) {
        AccountBasicInfo accountBasicInfo = this.doGet(appid, GET_ACCOUNT_BASIC_INFO, AccountBasicInfo.class);
        this.log.info(" getAccountBasicInfo,appid {},result {}", (Object)appid, (Object)JSONObject.toJSONString((Object)accountBasicInfo));
        return accountBasicInfo;
    }

    public SetNicknameResponse setNickname(String appid, SetNicknameRequest request) {
        SetNicknameResponse response = this.doPost(appid, POST_SET_NICKNAME, request, SetNicknameResponse.class);
        this.log.debug("set nickname result =>{}", (Object)JSONObject.toJSONString((Object)response));
        return response;
    }

    public QueryNicknameStateResponse queryNicknameState(String appid, Integer auditId) {
        JSONObject param = new JSONObject();
        param.put("audit_id", (Object)auditId);
        QueryNicknameStateResponse result = this.doPost(appid, POST_QUERY_NICKNAME_STATE, param, QueryNicknameStateResponse.class);
        this.log.debug("query nickname state result =>{}", (Object)JSONObject.toJSONString((Object)result));
        return result;
    }

    public CheckWxVerifyNicknameResponse checkWxVerifyNickname(String appid, String nickname) throws LoaderNotFoundException {
        JSONObject param = new JSONObject();
        param.put("nick_name", (Object)nickname);
        CheckWxVerifyNicknameResponse response = this.doPost(appid, POST_CHECK_WX_VERIFY_NICKNAME, param, CheckWxVerifyNicknameResponse.class);
        this.log.debug("check nickname result =>{}", (Object)JSONObject.toJSONString((Object)response));
        return response;
    }

    public void modifyHeadImage(String appid, ModifyHeadImageRequest req) {
        JSONObject result = this.doPost(appid, POST_MODIFY_HEAD_IMAGE, req);
        this.log.debug("modify head img =>{}", (Object)result);
    }

    public void modifySignature(String appid, String signature) {
        JSONObject params = new JSONObject();
        params.put("signature", (Object)signature);
        JSONObject result = this.doPost(appid, POST_MODIFY_SIGNATURE, params);
        this.log.debug("modify signature ,appid {},response {}", (Object)appid, (Object)result);
    }

    public void rebindAdmin(String appid, String taskId) {
        JSONObject param = new JSONObject();
        param.put("taskid", (Object)taskId);
        JSONObject result = this.doPost(appid, POST_REBIND_ADMIN, param);
        this.log.debug("modify signature ,appid {},response {}", (Object)appid, (Object)result);
    }

    public CanSetCategoryResponse getCanSetCategories(String appid) {
        CanSetCategoryResponse canSetCategoryResponse = this.doGet(appid, GET_ALL_CAN_SET_CATEGORIES, CanSetCategoryResponse.class);
        this.log.debug("getCanSetCategories =>{}", (Object)JSONObject.toJSONString((Object)canSetCategoryResponse));
        return canSetCategoryResponse;
    }

    public void addCategory(String appid, CategoryAddRequest req) {
        JSONObject resp = this.doPost(appid, POST_ADD_CATEGORY, req);
        this.log.debug("addCategory response => {}", (Object)JSONObject.toJSONString((Object)resp));
    }

    public void deleteCategory(String appid, Integer first, Integer second) {
        JSONObject param = new JSONObject();
        param.put("first", (Object)first);
        param.put("Second", (Object)second);
        JSONObject resp = this.doPost(appid, POST_DELETE_CATEGORY, param);
        this.log.debug("delete category response => {}", (Object)JSONObject.toJSONString((Object)resp));
    }

    public CategoryGetResponse getSettedCategory(String appid) {
        CategoryGetResponse response = this.doGet(appid, GET_CATEGORY, CategoryGetResponse.class);
        this.log.debug("get setting category response {}", (Object)response);
        return response;
    }

    public void modifyCategory(String appid, CategoryAddRequest.Categories categories) {
        JSONObject resp = this.doPost(appid, POST_MODIFY_CATEGORY, categories);
        this.log.debug("modifyCategory response {}", (Object)resp);
    }
}

