/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.wechat.open.core.miniprogram;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mzlion.easyokhttp.HttpClient;
import com.wmeimob.wechat.open.core.Component;
import com.wmeimob.wechat.open.core.miniprogram.model.AuditStatusResponse;
import com.wmeimob.wechat.open.core.miniprogram.model.CategoryForVerifyResponse;
import com.wmeimob.wechat.open.core.miniprogram.model.CommitCodeRequest;
import com.wmeimob.wechat.open.core.miniprogram.model.SubmitAuditRequest;
import com.wmeimob.wechat.open.exception.LoaderNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import me.hao0.wechat.model.base.AccessToken;

public class Code
extends Component {
    private static final String POST_COMMIT_CODE = "https://api.weixin.qq.com/wxa/commit?access_token=";
    private static final String GET_TEST_QRCODE = "https://api.weixin.qq.com/wxa/get_qrcode?access_token=";
    private static final String GET_CATEGORY_FOR_VERIFY = "https://api.weixin.qq.com/wxa/get_category?access_token=";
    private static final String GET_PAGE_LIST = "https://api.weixin.qq.com/wxa/get_page?access_token=";
    private static final String POST_SUBMIT_AUDIT = "https://api.weixin.qq.com/wxa/submit_audit?access_token=";
    private static final String POST_GET_AUDIT_STATUS = "https://api.weixin.qq.com/wxa/get_auditstatus?access_token=";
    private static final String GET_LATEST_AUDIT_STATUS = "https://api.weixin.qq.com/wxa/get_latest_auditstatus?access_token=";
    private static final String POST_RELEASE = "https://api.weixin.qq.com/wxa/release?access_token=";
    private static final String POST_CHANGE_VISIT_STATUS = "https://api.weixin.qq.com/wxa/change_visitstatus?access_token=";
    private static final String GET_REVERT_CODER_RELEASE = "https://api.weixin.qq.com/wxa/revertcoderelease?access_token=";
    private static final String GET_UNDO_CODE_AUDIT = "https://api.weixin.qq.com/wxa/undocodeaudit?access_token=";

    protected Code(Component component) {
        super(component);
    }

    public void commitCode(CommitCodeRequest request) {
        JSONObject result = this.doPost(super.getAppid(), POST_COMMIT_CODE, request);
        this.log.debug("commit code result =>{}", (Object)result);
    }

    public byte[] getTestQrcodeImage(String path) {
        AccessToken accessToken = null;
        try {
            accessToken = this.getAuthorizerAccessToken(super.getAppid());
        }
        catch (LoaderNotFoundException e) {
            this.log.error(e.getLocalizedMessage());
            e.printStackTrace();
        }
        String url = GET_TEST_QRCODE + accessToken.getAccessToken();
        if (path != null && !"".equals(path)) {
            try {
                url = url + "&path=" + URLEncoder.encode(path, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        byte[] bytes = HttpClient.get((String)url).asByteData();
        return bytes;
    }

    public CategoryForVerifyResponse getCategoryForVerify() {
        CategoryForVerifyResponse response = this.doGet(super.getAppid(), GET_CATEGORY_FOR_VERIFY, CategoryForVerifyResponse.class);
        this.log.debug("getCategoryForVerify => {}", (Object)JSONObject.toJSONString((Object)response));
        return response;
    }

    public List<String> getPageList() {
        JSONObject response = this.doGet(super.getAppid(), GET_PAGE_LIST);
        ArrayList<String> pageList = new ArrayList<String>();
        JSONArray pageListJSONArr = response.getJSONArray("page_list");
        if (!pageListJSONArr.isEmpty()) {
            pageListJSONArr.forEach(p -> pageList.add((String)p));
        }
        this.log.debug("get page list =>{}", (Object)response);
        return pageList;
    }

    public Integer submitAudit(SubmitAuditRequest req) {
        JSONObject resp = this.doPost(super.getAppid(), POST_SUBMIT_AUDIT, req);
        this.log.debug("submitAudit =>{}", (Object)resp);
        return resp.getInteger("auditid");
    }

    public AuditStatusResponse getAuditStatus(Integer auditId) {
        JSONObject param = new JSONObject();
        param.put("auditid", (Object)auditId);
        AuditStatusResponse resp = this.doPost(super.getAppid(), POST_GET_AUDIT_STATUS, param, AuditStatusResponse.class);
        return resp;
    }

    public AuditStatusResponse getLatestAuditStatus() {
        AuditStatusResponse resp = this.doGet(super.getAppid(), GET_LATEST_AUDIT_STATUS, AuditStatusResponse.class);
        this.log.debug("get latest audit status =>{}", (Object)JSONObject.toJSONString((Object)resp));
        return resp;
    }

    public void undoAudit() {
        JSONObject resp = this.doGet(super.getAppid(), GET_UNDO_CODE_AUDIT);
        this.log.debug("undo audit =>{}", (Object)resp);
    }

    public void release() {
        JSONObject resp = this.doPost(super.getAppid(), POST_RELEASE, new JSONObject());
        this.log.debug("release =>{}", (Object)resp);
    }

    public void changeVisitStatus(boolean isPublic) {
        JSONObject param = new JSONObject();
        param.put("action", (Object)(isPublic ? "open" : "close"));
        JSONObject resp = this.doPost(super.getAppid(), POST_CHANGE_VISIT_STATUS, param);
        this.log.debug("change visit status =>{}", (Object)resp);
    }

    public void revertCoderRelease() {
        JSONObject resp = this.doGet(super.getAppid(), GET_REVERT_CODER_RELEASE);
        this.log.debug("revert release =>{}", (Object)resp);
    }
}

