/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.wechat.open.core;

import com.alibaba.fastjson.JSONObject;
import com.mzlion.core.lang.Assert;
import com.mzlion.core.lang.StringUtils;
import com.mzlion.easyokhttp.HttpClient;
import com.wmeimob.wechat.open.exception.LoaderNotFoundException;
import com.wmeimob.wechat.open.loader.AuthorizerRefreshTokenLoader;
import com.wmeimob.wechat.open.loader.ComponentAccessTokenLoader;
import com.wmeimob.wechat.open.loader.ComponentVerifyTicketLoader;
import com.wmeimob.wechat.open.loader.Loader;
import com.wmeimob.wechat.open.loader.WechatAuthorizerAccessTokenLoader;
import com.wmeimob.wechat.open.model.AuthorizationInfo;
import com.wmeimob.wechat.open.model.ComponentAccessToken;
import com.wmeimob.wechat.open.model.VerifyTicket;
import com.wmeimob.wechat.open.model.Wechat3rdPlatform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.hao0.wechat.exception.WechatException;
import me.hao0.wechat.model.base.AccessToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Component {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String ERR_CODE = "errcode";
    public static final String COMPONENT_APPID = "component_appid";
    public static final String AUTHORIZER_APPID = "authorizer_appid";
    protected ThreadLocal<String> localAppid = new ThreadLocal();
    private static final String POST_COMPONENT_ACCESS_TOKEN = "https://api.weixin.qq.com/cgi-bin/component/api_component_token";
    private static final String POST_AUTHORIZER_ACCESS_TOKEN = "https://api.weixin.qq.com/cgi-bin/component/api_authorizer_token?component_access_token=";
    protected Wechat3rdPlatform wechat3rdPlatform;
    protected List<Loader> loaders = new ArrayList<Loader>();

    protected void setAppid(String appid) {
        this.localAppid.set(appid);
    }

    public String getAppid() {
        return this.localAppid.get();
    }

    public ThreadLocal<String> getLocalAppid() {
        return this.localAppid;
    }

    public Component() {
    }

    public Component(Component component) {
        this.loaders = component.getLoaders();
        this.wechat3rdPlatform = component.getWechat3rdPlatform();
        this.localAppid = component.getLocalAppid();
    }

    public Wechat3rdPlatform getWechat3rdPlatform() {
        return this.wechat3rdPlatform;
    }

    public List<Loader> getLoaders() {
        return this.loaders;
    }

    public void setVerifyTicket(VerifyTicket verifyTicket) throws LoaderNotFoundException {
        ComponentVerifyTicketLoader componentVerifyTicketLoader = this.findLoader(ComponentVerifyTicketLoader.class);
        this.log.debug("set verify ticket => {}", (Object)verifyTicket);
        componentVerifyTicketLoader.set(verifyTicket);
    }

    public String getComponentAccessToken() throws LoaderNotFoundException {
        ComponentAccessTokenLoader componentAccessTokenLoader = this.findLoader(ComponentAccessTokenLoader.class);
        String componentAccessTokenStr = componentAccessTokenLoader.get();
        if (StringUtils.isEmpty((String)componentAccessTokenStr)) {
            JSONObject paramsJson = new JSONObject();
            paramsJson.put(COMPONENT_APPID, (Object)this.wechat3rdPlatform.getComponentAppid());
            paramsJson.put("component_appsecret", (Object)this.wechat3rdPlatform.getComponentSecret());
            ComponentVerifyTicketLoader componentVerifyTicketLoader = this.findLoader(ComponentVerifyTicketLoader.class);
            paramsJson.put("component_verify_ticket", (Object)componentVerifyTicketLoader.get());
            this.log.info("local wechat3rd params appid is {}", (Object)this.wechat3rdPlatform.getComponentAppid());
            String result = HttpClient.textBody((String)POST_COMPONENT_ACCESS_TOKEN).json(paramsJson.toJSONString()).asString();
            ComponentAccessToken componentAccessToken = (ComponentAccessToken)JSONObject.parseObject((String)result, ComponentAccessToken.class);
            Assert.notNull((Object)componentAccessToken, (String)String.format("get componentAccessToken error, return result is %s", result));
            Assert.notNull((Object)componentAccessToken.getComponentAccessToken(), (String)String.format("get componentAccessToken error, return result is %s", result));
            componentAccessToken.setComponentAppid(this.wechat3rdPlatform.getComponentAppid());
            componentAccessTokenLoader.set(componentAccessToken);
            componentAccessTokenStr = componentAccessToken.getComponentAccessToken();
        }
        this.log.debug("component accessToken : {}", (Object)componentAccessTokenStr);
        return componentAccessTokenStr;
    }

    public AccessToken getAuthorizerAccessToken(String appid) throws LoaderNotFoundException {
        WechatAuthorizerAccessTokenLoader wechatAuthorizerAccessTokenLoader = this.findLoader(WechatAuthorizerAccessTokenLoader.class);
        AccessToken accessToken = wechatAuthorizerAccessTokenLoader.get(appid);
        if (accessToken != null) {
            return accessToken;
        }
        String componentAccessToken = this.getComponentAccessToken();
        JSONObject paramsJson = new JSONObject();
        paramsJson.put(COMPONENT_APPID, (Object)this.wechat3rdPlatform.getComponentAppid());
        paramsJson.put(AUTHORIZER_APPID, (Object)appid);
        AuthorizerRefreshTokenLoader authorizerRefreshTokenLoader = this.findLoader(AuthorizerRefreshTokenLoader.class);
        paramsJson.put("authorizer_refresh_token", (Object)authorizerRefreshTokenLoader.get(appid));
        String result = HttpClient.textBody((String)(POST_AUTHORIZER_ACCESS_TOKEN + componentAccessToken)).json(paramsJson.toJSONString()).asString();
        AuthorizationInfo authorizationInfo = (AuthorizationInfo)JSONObject.parseObject((String)result, AuthorizationInfo.class);
        authorizationInfo.setComponentAppid(this.wechat3rdPlatform.getComponentAppid());
        authorizationInfo.setAuthorizerAppid(appid);
        Assert.notNull((Object)authorizationInfo.getAuthorizerRefreshToken(), (String)("AuthorizerRefreshToken is null by appid " + appid + ",maybe not authorized ?"));
        authorizerRefreshTokenLoader.set(authorizationInfo);
        Assert.notNull((Object)authorizationInfo.getAuthorizerAccessToken(), (String)("AuthorizerAccessToken is null by appid " + appid));
        wechatAuthorizerAccessTokenLoader.set(authorizationInfo);
        return wechatAuthorizerAccessTokenLoader.get(appid);
    }

    void addLoader(Loader ... newLoaders) {
        this.loaders.addAll(Arrays.asList(newLoaders));
    }

    protected <T> T findLoader(Class<T> loaderClazz) throws LoaderNotFoundException {
        for (Loader loader : this.loaders) {
            if (!loaderClazz.isAssignableFrom(loader.getClass())) continue;
            return (T)loader;
        }
        throw new LoaderNotFoundException(String.format("can't found loader named %s , loaders size is %s", loaderClazz.getName(), this.loaders.size()));
    }

    protected void checkError(JSONObject resp) {
        if (resp.getInteger(ERR_CODE) != null && 0 != resp.getInteger(ERR_CODE)) {
            throw WechatException.getInstance((Map)resp);
        }
    }

    protected <T> T doGet(String appid, String url, Class<T> clazz) {
        return (T)JSONObject.parseObject((String)this.doGet(appid, url).toJSONString(), clazz);
    }

    protected JSONObject doGet(String appid, String url) throws WechatException {
        JSONObject resp = null;
        try {
            resp = (JSONObject)HttpClient.get((String)(url + this.getAuthorizerAccessToken(appid).getAccessToken())).asBean(JSONObject.class);
        }
        catch (LoaderNotFoundException e) {
            this.log.error(e.getLocalizedMessage());
        }
        this.checkError(resp);
        return resp;
    }

    protected <T> T doGet(String url, Class<T> clazz) {
        return (T)JSONObject.parseObject((String)this.doGet(url).toJSONString(), clazz);
    }

    protected JSONObject doGet(String url) throws WechatException {
        JSONObject resp = null;
        try {
            resp = (JSONObject)HttpClient.get((String)(url + this.getComponentAccessToken())).asBean(JSONObject.class);
        }
        catch (LoaderNotFoundException e) {
            this.log.error(e.getLocalizedMessage());
        }
        this.checkError(resp);
        return resp;
    }

    protected JSONObject doPost(String appid, String url, JSONObject params) throws WechatException {
        JSONObject resp = null;
        try {
            resp = (JSONObject)HttpClient.textBody((String)(url + this.getAuthorizerAccessToken(appid).getAccessToken())).json(params.toJSONString()).asBean(JSONObject.class);
        }
        catch (LoaderNotFoundException e) {
            this.log.error(e.getLocalizedMessage());
        }
        this.checkError(resp);
        return resp;
    }

    protected JSONObject doPost(String appid, String url, Object params) throws WechatException {
        return this.doPost(appid, url, this.fromObject(params));
    }

    protected <T> T doPost(String appid, String url, Object params, Class<T> clazz) {
        if (params instanceof JSONObject) {
            return (T)JSONObject.parseObject((String)this.doPost(appid, url, (JSONObject)params).toJSONString(), clazz);
        }
        return (T)JSONObject.parseObject((String)this.doPost(appid, url, this.fromObject(params)).toJSONString(), clazz);
    }

    protected JSONObject doPost(String url, JSONObject params) throws WechatException {
        JSONObject resp = null;
        try {
            resp = (JSONObject)HttpClient.textBody((String)(url + this.getComponentAccessToken())).json(params.toJSONString()).asBean(JSONObject.class);
        }
        catch (LoaderNotFoundException e) {
            this.log.error(e.getLocalizedMessage());
        }
        this.checkError(resp);
        return resp;
    }

    protected JSONObject doPost(String url, Object params) throws WechatException {
        return this.doPost(url, this.fromObject(params));
    }

    protected <T> T doPost(String url, Object params, Class<T> clazz) {
        if (params instanceof JSONObject) {
            return (T)JSONObject.parseObject((String)this.doPost(url, (JSONObject)params).toJSONString(), clazz);
        }
        return (T)JSONObject.parseObject((String)this.doPost(url, this.fromObject(params)).toJSONString(), clazz);
    }

    protected JSONObject fromObject(Object object) {
        return JSONObject.parseObject((String)JSONObject.toJSONString((Object)object));
    }
}

