/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.wechat.open.authorization.handler.event;

import com.mzlion.core.lang.Assert;
import com.wmeimob.wechat.open.authorization.handler.event.AuthorizationEventType;
import com.wmeimob.wechat.open.core.Wechat3rdPlatformHandler;
import com.wmeimob.wechat.open.exception.LoaderNotFoundException;
import com.wmeimob.wechat.open.model.AuthorizationInfo;
import com.wmeimob.wechat.open.model.AuthorizerAccountBasicInfo;
import com.wmeimob.wechat.open.model.VerifyTicket;
import com.wmeimob.wechat.service.WechatMpService;
import com.wmeimob.wechat.util.XmlUtil;
import java.util.Map;
import me.hao0.wechat.model.base.WechatMp;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationEventHandler {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationEventHandler.class);
    private Wechat3rdPlatformHandler wechat3rdPlatformHandler;
    private static volatile AuthorizationEventHandler authorizationEventHandler;
    private WechatMpService wechatMpService;

    private AuthorizationEventHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuthorizationEventHandler getInstance(Wechat3rdPlatformHandler wechat3rdPlatformHandler, WechatMpService wechatMpService) {
        if (authorizationEventHandler != null) return authorizationEventHandler;
        Class<AuthorizationEventHandler> clazz = AuthorizationEventHandler.class;
        synchronized (AuthorizationEventHandler.class) {
            if (authorizationEventHandler != null) return authorizationEventHandler;
            AuthorizationEventHandler authorizationEventHandlerTmp = new AuthorizationEventHandler();
            authorizationEventHandlerTmp.wechatMpService = wechatMpService;
            authorizationEventHandlerTmp.wechat3rdPlatformHandler = wechat3rdPlatformHandler;
            authorizationEventHandler = authorizationEventHandlerTmp;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return authorizationEventHandler;
        }
    }

    public void invoke(String decryptResult) throws DocumentException, LoaderNotFoundException {
        Map<String, String> decodeMap = XmlUtil.readStringXmlOut(decryptResult);
        String infoType = decodeMap.get("InfoType");
        AuthorizationEventType eventType = AuthorizationEventType.from(infoType);
        switch (eventType) {
            case COMPONENT_VERIFY_TICKET: {
                VerifyTicket verifyTicket = XmlUtil.fromXMLAlias(decryptResult, VerifyTicket.class);
                this.wechat3rdPlatformHandler.setVerifyTicket(verifyTicket);
                break;
            }
            case AUTHORIZED: 
            case UPDATE_AUTHORIZED: {
                AuthorizationInfo authorizationInfo = null;
                String authCode = decodeMap.get("AuthorizationCode");
                authorizationInfo = this.wechat3rdPlatformHandler.getAuthorizationInfo(authCode);
                AuthorizerAccountBasicInfo authorizerAccountBasicInfo = this.wechat3rdPlatformHandler.getAuthorizerInfo(authorizationInfo.getAppid());
                Assert.notNull((Object)authorizationInfo, (String)"get authorization info error ");
                this.wechatMpService.save(authorizationInfo);
                this.wechatMpService.save(authorizerAccountBasicInfo);
                break;
            }
            case UN_AUTHORIZED: {
                WechatMp wechat = new WechatMp();
                wechat.setComponentAppid(decodeMap.get("AppId"));
                wechat.setAppid(decodeMap.get("AuthorizerAppid"));
                wechat.setIsAuthorized(Boolean.valueOf(false));
                this.wechatMpService.save(wechat);
                break;
            }
            case UNKNOW: {
                log.error("this is unknow auth event ,info => {}", (Object)decryptResult);
                break;
            }
        }
    }
}

