/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.wechat.demo;

import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mzlion.easyokhttp.HttpClient;
import com.qq.weixin.mp.aes.AesException;
import com.qq.weixin.mp.aes.WechatCryptor;
import com.wmeimob.wechat.open.core.Wechat3rdPlatformBuilder;
import com.wmeimob.wechat.open.core.Wechat3rdPlatformHandler;
import com.wmeimob.wechat.open.exception.LoaderNotFoundException;
import com.wmeimob.wechat.open.loader.Loader;
import com.wmeimob.wechat.open.model.Wechat3rdPlatform;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import me.hao0.wechat.core.Wechat;
import me.hao0.wechat.core.WechatBuilder;
import me.hao0.wechat.model.message.receive.RecvMessage;
import me.hao0.wechat.model.message.receive.event.RecvEvent;
import me.hao0.wechat.model.message.receive.msg.RecvTextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoTestCheck {
    private static final Logger log = LoggerFactory.getLogger(AutoTestCheck.class);
    private static ThreadFactory autoCheckThread = new ThreadFactoryBuilder().setNameFormat("AutoCheck-pool-%d").build();

    public static String invokeAutoTestAppidMsgEvent(Wechat3rdPlatform wechat3rdPlatform, InputStream inputStream, String appid, String msgSign, String timestamp, String nonce, Loader ... loaders) throws AesException, IOException {
        WechatCryptor wechatCryptor = WechatCryptor.buildIfNotExists((String)wechat3rdPlatform.getComponentAppid(), (String)wechat3rdPlatform.getToken(), (String)wechat3rdPlatform.getEncodingAesKey());
        String decryptResult = wechatCryptor.decode(inputStream, msgSign, timestamp, nonce);
        Wechat wechat = WechatBuilder.newBuilder((String)appid).build();
        RecvMessage recvEntity = wechat.msg().receive(decryptResult);
        log.info("begin to auto getTest ====>>>>>");
        if (recvEntity instanceof RecvEvent) {
            log.info("auto getTest for event  ...");
            RecvEvent recvEvent = (RecvEvent)recvEntity;
            log.info(" event entity is {}", (Object)JSONObject.toJSONString((Object)recvEvent));
            String content = recvEvent.getEventType() + "from_callback";
            String result = wechat.msg().respText(recvEntity, content);
            log.info("auto getTest for event result is {}", (Object)result);
            return wechatCryptor.encode(result);
        }
        if (recvEntity instanceof RecvTextMessage) {
            log.info("auto getTest for message  ...");
            RecvTextMessage textMessage = (RecvTextMessage)recvEntity;
            log.info(" textMessage entity is {}", (Object)JSONObject.toJSONString((Object)textMessage));
            String testContent = "TESTCOMPONENT_MSG_TYPE_TEXT";
            if (testContent.equals(textMessage.getContent())) {
                String content = "TESTCOMPONENT_MSG_TYPE_TEXT_callback";
                String result = wechat.msg().respText(recvEntity, content);
                log.info("auto getTest for message result is {}", (Object)result);
                return wechatCryptor.encode(result);
            }
            log.info("auto getTest for async message  ...");
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, autoCheckThread);
            scheduledThreadPoolExecutor.execute(() -> {
                String content = textMessage.getContent();
                String queryAuthCode = content.replace("QUERY_AUTH_CODE:", "");
                Wechat3rdPlatformHandler wechat3rdPlatformHandler = Wechat3rdPlatformBuilder.newBuilder(wechat3rdPlatform, loaders).build();
                try {
                    String accessToken = wechat3rdPlatformHandler.getAuthorizerAccessToken(appid).getAccessToken();
                    JSONObject paramsJson = new JSONObject();
                    paramsJson.put("touser", (Object)textMessage.getFromUserName());
                    paramsJson.put("msgtype", (Object)"text");
                    JSONObject contentJson = new JSONObject();
                    contentJson.put("content", (Object)(queryAuthCode + "_from_api"));
                    paramsJson.put("text", (Object)contentJson);
                    String result = HttpClient.textBody((String)("https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=" + accessToken)).json((Object)paramsJson).asString();
                    log.info("auto getTest for async msg  result {}", (Object)result);
                }
                catch (LoaderNotFoundException e) {
                    e.printStackTrace();
                }
            });
            log.info("auto getTest for async msg  return empty");
            return "";
        }
        return null;
    }
}

