/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.wechat.open.message.factory;

import com.wmeimob.wechat.open.exception.MsgEventHandlerNotFoundException;
import com.wmeimob.wechat.open.message.factory.MsgEventHandlerFactory;
import com.wmeimob.wechat.open.message.handler.AbstractMsgEventHandler;
import com.wmeimob.wechat.open.model.Wechat3rdPlatform;
import com.wmeimob.wechat.util.Camel2Underline;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import me.hao0.wechat.model.message.receive.RecvMessage;
import me.hao0.wechat.model.message.receive.RecvMessageType;
import me.hao0.wechat.model.message.receive.event.RecvEvent;
import me.hao0.wechat.model.message.receive.event.RecvEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMsgEventHandlerFactory
implements MsgEventHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultMsgEventHandlerFactory.class);
    private static final String[] BASE_MODEL_PACKAGE_NAME = new String[]{"me.hao0.wechat.model.message.receive.*", "me.hao0.wechat.model.message.receive.*.card", "me.hao0.wechat.model.message.receive.*.menu", "me.hao0.wechat.model.message.receive.*.scan"};
    private static final String MODEL_PREFIX = "Recv";
    private static final String EVENT_MODEL_SUFFIX = "Event";
    private static final String MSG_MODEL_SUFFIX = "Message";
    private static final String HANDLER_SUFFIX = "Handler";
    private static final String MSG = "msg";
    private static final String EVENT = "event";
    private static volatile DefaultMsgEventHandlerFactory defaultWechatMsgCommandFactory;

    private DefaultMsgEventHandlerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultMsgEventHandlerFactory getInstance() {
        if (defaultWechatMsgCommandFactory != null) return defaultWechatMsgCommandFactory;
        Class<DefaultMsgEventHandlerFactory> clazz = DefaultMsgEventHandlerFactory.class;
        synchronized (DefaultMsgEventHandlerFactory.class) {
            if (defaultWechatMsgCommandFactory != null) return defaultWechatMsgCommandFactory;
            defaultWechatMsgCommandFactory = new DefaultMsgEventHandlerFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultWechatMsgCommandFactory;
        }
    }

    @Override
    public AbstractMsgEventHandler build(Wechat3rdPlatform wechat3rdPlatform, String appid, RecvMessage recvMessage) throws MsgEventHandlerNotFoundException {
        String reflectedClues = RecvMessageType.from((String)recvMessage.getMsgType()).name();
        String modelSuffix = MSG_MODEL_SUFFIX;
        String packageType = MSG;
        if (RecvMessageType.EVENT == RecvMessageType.from((String)recvMessage.getMsgType())) {
            RecvEvent recvEvent = (RecvEvent)recvMessage;
            reflectedClues = RecvEventType.from((String)recvEvent.getEventType()).name();
            modelSuffix = EVENT_MODEL_SUFFIX;
            packageType = EVENT;
        }
        try {
            String modelBasicName = Camel2Underline.underline2Camel(reflectedClues, false);
            Class<?> handlerClazz = this.getBean(modelBasicName + HANDLER_SUFFIX, wechat3rdPlatform.getLocal().getBasePackageHandlerName(), 0, packageType);
            Class<?> beanClazz = this.getBean(MODEL_PREFIX + modelBasicName + modelSuffix, BASE_MODEL_PACKAGE_NAME, 0, packageType);
            Constructor<?> constructor2ndParam = handlerClazz.getDeclaredConstructor(Wechat3rdPlatform.class, String.class, beanClazz);
            constructor2ndParam.setAccessible(true);
            Object obj = constructor2ndParam.newInstance(wechat3rdPlatform, appid, recvMessage);
            return (AbstractMsgEventHandler)obj;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new MsgEventHandlerNotFoundException(e.getLocalizedMessage(), e);
        }
        return null;
    }

    private Class<?> getBean(String clazzName, String[] packageName, int index, String replace) throws ClassNotFoundException {
        if (index > packageName.length - 1) {
            throw new ClassNotFoundException("cannot found class " + clazzName);
        }
        try {
            return Class.forName(packageName[index].replace("*", replace) + "." + clazzName);
        }
        catch (ClassNotFoundException e) {
            return this.getBean(clazzName, packageName, ++index, replace);
        }
    }
}

