/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.wechat.open.message;

import com.mzlion.core.lang.Assert;
import com.qq.weixin.mp.aes.WechatCryptor;
import com.wmeimob.wechat.interfaces.Receiver;
import com.wmeimob.wechat.open.model.Wechat3rdPlatform;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgEventReceiver {
    private static final Logger log = LoggerFactory.getLogger(MsgEventReceiver.class);
    private static final String SUCCESS = "success";
    private static final String NULL = "null";
    private Receiver[] receivers;
    private Wechat3rdPlatform wechat3rdPlatform;

    private MsgEventReceiver() {
    }

    public static MsgEventReceiver newInstance(Wechat3rdPlatform wechat3rdPlatform, Receiver ... receivers) {
        MsgEventReceiver msgEventReceiver = new MsgEventReceiver();
        msgEventReceiver.receivers = receivers;
        msgEventReceiver.wechat3rdPlatform = wechat3rdPlatform;
        return msgEventReceiver;
    }

    public String process() {
        String replyMsg = SUCCESS;
        try {
            for (Receiver r : this.receivers) {
                String result = r.call();
                if (SUCCESS.equals(result)) continue;
                log.info("replyMsg is {}", (Object)result);
                replyMsg = result;
            }
        }
        catch (RuntimeException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        log.info("process finish by {} service", (Object)this.receivers.length);
        if (SUCCESS.equals(replyMsg)) {
            log.info("reply {}", (Object)SUCCESS);
            return SUCCESS;
        }
        if (replyMsg == null || Objects.equals(replyMsg, NULL)) {
            log.info("reply empty");
            return null;
        }
        WechatCryptor wechatCryptor = WechatCryptor.get((String)this.wechat3rdPlatform.getComponentAppid());
        Assert.notNull((Object)wechatCryptor, (String)("can not find wechat cryptor by appid " + this.wechat3rdPlatform.getComponentAppid()));
        String cryptoReplyMsg = wechatCryptor.encode(replyMsg);
        return cryptoReplyMsg;
    }
}

