/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.wechat.open.loader;

import com.wmeimob.wechat.open.loader.Loader;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import me.hao0.wechat.model.js.Ticket;
import me.hao0.wechat.model.js.TicketType;

public interface WechatJsApiTicketLoader
extends Loader {
    public static final Map<String, EnumMap<TicketType, Ticket>> JS_API_TICKET_MAP = new HashMap<String, EnumMap<TicketType, Ticket>>();

    default public String get(String appid, TicketType ticketType) {
        Ticket ticket;
        EnumMap<TicketType, Ticket> currentAppidTicketMaps = JS_API_TICKET_MAP.get(appid);
        if (currentAppidTicketMaps != null && (ticket = currentAppidTicketMaps.get(ticketType)) != null && System.currentTimeMillis() < ticket.getExpireAt()) {
            return ticket.getTicket();
        }
        return null;
    }

    default public void set(String appid, Ticket ticket) {
        Long validTime = (long)(ticket.getExpire() - 600) * 1000L;
        ticket.setExpireAt(Long.valueOf(System.currentTimeMillis() + validTime));
        EnumMap<TicketType, Object> currentAppidTicketMaps = JS_API_TICKET_MAP.get(appid);
        if (currentAppidTicketMaps == null) {
            currentAppidTicketMaps = new EnumMap(TicketType.class);
        }
        currentAppidTicketMaps.put(ticket.getType(), (Object)ticket);
    }
}

