/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.wechat.open.core;

import com.alibaba.fastjson.JSONObject;
import com.mzlion.core.lang.Assert;
import com.mzlion.core.lang.StringUtils;
import com.mzlion.easyokhttp.HttpClient;
import com.wmeimob.wechat.open.core.Component;
import com.wmeimob.wechat.open.core.miniprogram.Miniprogram;
import com.wmeimob.wechat.open.exception.LoaderNotFoundException;
import com.wmeimob.wechat.open.loader.AuthorizerRefreshTokenLoader;
import com.wmeimob.wechat.open.loader.Loader;
import com.wmeimob.wechat.open.loader.WechatAuthorizerAccessTokenLoader;
import com.wmeimob.wechat.open.loader.WechatJsApiTicketLoader;
import com.wmeimob.wechat.open.model.AuthorizationInfo;
import com.wmeimob.wechat.open.model.AuthorizerAccountBasicInfo;
import com.wmeimob.wechat.open.model.AuthorizerOptionSettingInfo;
import com.wmeimob.wechat.open.model.PreAuthCode;
import com.wmeimob.wechat.open.model.Wechat3rdPlatform;
import me.hao0.wechat.model.base.AccessToken;
import me.hao0.wechat.model.base.AuthAccessToken;
import me.hao0.wechat.model.js.Ticket;
import me.hao0.wechat.model.js.TicketType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wechat3rdPlatformHandler
extends Component {
    private static final Logger log = LoggerFactory.getLogger(Wechat3rdPlatformHandler.class);
    private static final String POST_PRE_AUTH_CODE = "https://api.weixin.qq.com/cgi-bin/component/api_create_preauthcode?component_access_token=";
    private static final String POST_QUERY_AUTH = "https://api.weixin.qq.com/cgi-bin/component/api_query_auth?component_access_token=";
    private static final String POST_AUTHORIZER_INFO = "https://api.weixin.qq.com/cgi-bin/component/api_get_authorizer_info?component_access_token=";
    private static final String POST_AUTHORIZER_OPTION = "https://api.weixin.qq.com/cgi-bin/component/api_get_authorizer_option?component_access_token=";
    private static final String POST_SET_AUTHORIZER_OPTION = "https://api.weixin.qq.com/cgi-bin/component/api_set_authorizer_option?component_access_token=";
    private static final String GET_USER_ACCESS_TOKEN = "https://api.weixin.qq.com/sns/oauth2/component/access_token?appid=%s&code=%s&grant_type=authorization_code&component_appid=%s&component_access_token=%s";
    private static final String GET_JS_API_TICKET = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=%s&type=%s";
    private static volatile Miniprogram miniprogram;

    protected Wechat3rdPlatformHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Miniprogram miniprogram(String appid) {
        if (miniprogram == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (miniprogram == null) {
                    miniprogram = new Miniprogram(this);
                }
            }
        }
        miniprogram.setAppid(appid);
        return miniprogram;
    }

    public static Wechat3rdPlatformHandler newInstance(Wechat3rdPlatform wechat3rdPlatform, Loader ... loaders) {
        Wechat3rdPlatformHandler wechat3rdPlatformHandler = new Wechat3rdPlatformHandler();
        log.debug("initialize default loader to wechat 3rd platform handler ...");
        wechat3rdPlatformHandler.addLoader(loaders);
        wechat3rdPlatformHandler.wechat3rdPlatform = wechat3rdPlatform;
        return wechat3rdPlatformHandler;
    }

    public String getPreAuthCode() throws LoaderNotFoundException {
        String componentAccessToken = this.getComponentAccessToken();
        JSONObject paramsJson = new JSONObject();
        paramsJson.put("component_appid", (Object)this.wechat3rdPlatform.getComponentAppid());
        String result = HttpClient.textBody((String)(POST_PRE_AUTH_CODE + componentAccessToken)).json(paramsJson.toJSONString()).asString();
        PreAuthCode preAuthCode = (PreAuthCode)JSONObject.parseObject((String)result, PreAuthCode.class);
        Assert.notNull((Object)preAuthCode, (String)String.format("get preAuthCode error ,reason is %s", result));
        Assert.notNull((Object)preAuthCode.getPreAuthCode(), (String)String.format("get preAuthCode error ,reason is %s", result));
        log.debug("pre auth code : {}", (Object)preAuthCode.getPreAuthCode());
        return preAuthCode.getPreAuthCode();
    }

    public AuthorizationInfo getAuthorizationInfo(String code) throws LoaderNotFoundException {
        String componentAccessToken = this.getComponentAccessToken();
        JSONObject paramsJson = new JSONObject();
        paramsJson.put("component_appid", (Object)this.wechat3rdPlatform.getComponentAppid());
        paramsJson.put("authorization_code", (Object)code);
        JSONObject jsonResult = (JSONObject)HttpClient.textBody((String)(POST_QUERY_AUTH + componentAccessToken)).json(paramsJson.toJSONString()).asBean(JSONObject.class);
        AuthorizationInfo authorizationInfo = (AuthorizationInfo)JSONObject.parseObject((String)jsonResult.getJSONObject("authorization_info").toJSONString(), AuthorizationInfo.class);
        Assert.notNull((Object)authorizationInfo, (String)"get authorizationInfo error");
        authorizationInfo.setComponentAppid(this.wechat3rdPlatform.getComponentAppid());
        AuthorizerRefreshTokenLoader authorizerRefreshTokenLoader = this.findLoader(AuthorizerRefreshTokenLoader.class);
        Assert.notNull((Object)authorizationInfo.getAuthorizerRefreshToken(), (String)"AuthorizerRefreshToken is null");
        authorizerRefreshTokenLoader.set(authorizationInfo);
        WechatAuthorizerAccessTokenLoader wechatAuthorizerAccessTokenLoader = this.findLoader(WechatAuthorizerAccessTokenLoader.class);
        Assert.notNull((Object)authorizationInfo.getAuthorizerAccessToken(), (String)"AuthorizerAccessToken is null");
        wechatAuthorizerAccessTokenLoader.set(authorizationInfo);
        return authorizationInfo;
    }

    public AuthorizerAccountBasicInfo getAuthorizerInfo(String appid) throws LoaderNotFoundException {
        String componentAccessToken = this.getComponentAccessToken();
        JSONObject paramsJson = new JSONObject();
        paramsJson.put("component_appid", (Object)this.wechat3rdPlatform.getComponentAppid());
        paramsJson.put("authorizer_appid", (Object)appid);
        String result = HttpClient.textBody((String)(POST_AUTHORIZER_INFO + componentAccessToken)).json(paramsJson.toJSONString()).asString();
        log.info("authorizer basic info => {}", (Object)result);
        AuthorizerAccountBasicInfo authorizerAccountBasicInfo = (AuthorizerAccountBasicInfo)JSONObject.parseObject((String)result, AuthorizerAccountBasicInfo.class);
        authorizerAccountBasicInfo.setComponentAppid(this.wechat3rdPlatform.getComponentAppid());
        return authorizerAccountBasicInfo;
    }

    public AuthorizerOptionSettingInfo getAuthorizerOptionSetting(String appid, String optionName) throws LoaderNotFoundException {
        String componentAccessToken = this.getComponentAccessToken();
        JSONObject paramsJson = new JSONObject();
        paramsJson.put("component_appid", (Object)this.wechat3rdPlatform.getComponentAppid());
        paramsJson.put("authorizer_appid", (Object)appid);
        paramsJson.put("option_name", (Object)optionName);
        String result = HttpClient.textBody((String)(POST_AUTHORIZER_OPTION + componentAccessToken)).json(paramsJson.toJSONString()).asString();
        return (AuthorizerOptionSettingInfo)JSONObject.parseObject((String)result, AuthorizerOptionSettingInfo.class);
    }

    public boolean setAuthorizerOptionSetting(AuthorizerOptionSettingInfo authorizerOptionSettingInfo) throws LoaderNotFoundException {
        String componentAccessToken = this.getComponentAccessToken();
        JSONObject paramsJson = new JSONObject();
        paramsJson.put("component_appid", (Object)this.wechat3rdPlatform.getComponentAppid());
        paramsJson.put("authorizer_appid", (Object)authorizerOptionSettingInfo.getAuthorizerAppid());
        paramsJson.put("option_name", (Object)authorizerOptionSettingInfo.getOptionName());
        paramsJson.put("option_value", (Object)authorizerOptionSettingInfo.getOptionValue());
        String result = HttpClient.textBody((String)(POST_SET_AUTHORIZER_OPTION + componentAccessToken)).json(paramsJson.toJSONString()).asString();
        JSONObject resultJson = JSONObject.parseObject((String)result);
        if (resultJson.getInteger("errcode") == 0) {
            log.debug("success set authorizer option setting => {}", (Object)JSONObject.toJSONString((Object)authorizerOptionSettingInfo));
            return true;
        }
        log.error("can't set set authorizer option setting,param info =>  {}", (Object)JSONObject.toJSONString((Object)authorizerOptionSettingInfo));
        return false;
    }

    public AuthAccessToken getUserAccessToken(String appid, String code) throws LoaderNotFoundException {
        String componentAccessToken = this.getComponentAccessToken();
        String result = HttpClient.get((String)String.format(GET_USER_ACCESS_TOKEN, appid, code, this.wechat3rdPlatform.getComponentAppid(), componentAccessToken)).asString();
        AuthAccessToken authAccessToken = (AuthAccessToken)JSONObject.parseObject((String)result, AuthAccessToken.class);
        log.info("auth access_token result {}", (Object)result);
        if (authAccessToken == null || authAccessToken.getAccessToken() == null) {
            log.error(result);
        }
        return authAccessToken;
    }

    public String getJssdkTicket(String appid, String type) throws LoaderNotFoundException {
        TicketType ticketType = TicketType.CARD.type().equals(type) ? TicketType.CARD : TicketType.JSAPI;
        WechatJsApiTicketLoader wechatJsApiTicketLoader = this.findLoader(WechatJsApiTicketLoader.class);
        String ticket = wechatJsApiTicketLoader.get(appid, ticketType);
        if (!StringUtils.isEmpty((String)ticket)) {
            return ticket;
        }
        AccessToken authorizerAccessToken = this.getAuthorizerAccessToken(appid);
        String result = HttpClient.get((String)String.format(GET_JS_API_TICKET, authorizerAccessToken.getAccessToken(), ticketType.type())).asString();
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (jsonObject.getInteger("errcode") == 0) {
            Ticket jsApiTicket = new Ticket();
            jsApiTicket.setType(ticketType);
            jsApiTicket.setExpire(jsonObject.getInteger("expires_in"));
            jsApiTicket.setTicket(jsonObject.getString("ticket"));
            wechatJsApiTicketLoader.set(appid, jsApiTicket);
            return jsApiTicket.getTicket();
        }
        log.error("can not get jsapi ticket, the appid is {} ,type is {} ,result is {}.", new Object[]{appid, ticketType.type(), result});
        return null;
    }
}

