/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.entity.OrderGift;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.mapper.OrderGiftMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrderItemsMapper;
import com.wmeimob.fastboot.bizvane.mapper.RefundOrderMapper;
import com.wmeimob.fastboot.bizvane.service.RefundOrderService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class RefundOrderServiceImpl
implements RefundOrderService {
    @Autowired
    private RefundOrderMapper refundOrderMapper;
    @Autowired
    private OrderItemsMapper orderItemsMapper;
    @Autowired
    private OrderGiftMapper orderGiftMapper;

    public List<RefundOrder> findByCondition(RefundOrder condition) {
        return this.refundOrderMapper.selectRefundOrderList(condition);
    }

    public RefundOrder findById(Integer id) {
        RefundOrder refundOrder = this.refundOrderMapper.selectRefundOrderById(id);
        List items = refundOrder.getItems();
        items.forEach(orderItems -> {
            Example example = new Example(OrderGift.class);
            example.createCriteria().andEqualTo("orderItemId", (Object)orderItems.getId());
            orderItems.setGifts(this.orderGiftMapper.selectByExample((Object)example));
        });
        return refundOrder;
    }

    public RefundOrder findRefundOrderById(Integer itemId) {
        return this.refundOrderMapper.findRefundOrderById(itemId);
    }

    public RefundOrder findById(String refundNo) {
        Example example = new Example(RefundOrder.class);
        example.createCriteria().andEqualTo("refundNo", (Object)refundNo);
        RefundOrder refundOrder = (RefundOrder)this.refundOrderMapper.selectOneByExample((Object)example);
        if (refundOrder != null) {
            OrderItems items = (OrderItems)this.orderItemsMapper.selectByPrimaryKey((Object)refundOrder.getItemId());
            refundOrder.setItem(items);
        }
        return refundOrder;
    }
}

