/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mzlion.easyokhttp.HttpClient;
import com.wmeimob.fastboot.bizvane.dto.CreateRechargeDTO;
import com.wmeimob.fastboot.bizvane.service.ShengFuTongPayService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ShengFuTongPayServiceImpl
implements ShengFuTongPayService {
    private static final Logger log = LoggerFactory.getLogger(ShengFuTongPayServiceImpl.class);
    public static final String URL = "https://mposprotest.shengpay.com/mpos-runtime/command/pay/wxMiniPay";
    @Value(value="${shengfutongpay.subMerchantNo}")
    private String subMerchantNo;
    @Value(value="${shengfutongpay.channelID}")
    private String channelID;
    @Value(value="${shengfutongpay.terminalId}")
    private String terminalId;
    @Value(value="${shengfutongpay.key}")
    private String key;

    public JSONObject createRecharge(CreateRechargeDTO createRechargeDTO) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("subMerchantNo", this.subMerchantNo);
        paramMap.put("channelID", this.channelID);
        paramMap.put("terminalId", this.terminalId);
        paramMap.put("totalAmount", createRechargeDTO.getMoney().toString());
        String date = sdf.format(new Date());
        paramMap.put("txnTime", date);
        paramMap.put("appId", createRechargeDTO.getAppId());
        paramMap.put("openId", createRechargeDTO.getOpenId());
        paramMap.put("charSet", "utf8");
        paramMap.put("outOrderNo", UUID.randomUUID().toString().replaceAll("[-]", ""));
        paramMap.put("signType", "MD5");
        paramMap.put("sign", this.sign(paramMap));
        JSONObject res = (JSONObject)HttpClient.post((String)URL).param(paramMap).asBean(JSONObject.class);
        return res;
    }

    public String sign(Map<String, String> paramMap) {
        log.info("paramMap={}", (Object)JSON.toJSONString(paramMap));
        StringBuffer stringA = new StringBuffer();
        Set<Map.Entry<String, String>> set = paramMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (null == value || "".equals(value)) continue;
            stringA.append(name).append("=").append((Object)value).append("&");
        }
        stringA.deleteCharAt(stringA.lastIndexOf("&"));
        String stringSignTemp = stringA.toString() + this.key;
        return DigestUtils.md5Hex((String)stringSignTemp).toUpperCase();
    }
}

