/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.wmeimob.fastboot.bizvane.dto.ReduceProductDto;
import com.wmeimob.fastboot.bizvane.entity.BargainPlayers;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.GoodsSpecRelation;
import com.wmeimob.fastboot.bizvane.entity.MarketActivity;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityGoods;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityOrders;
import com.wmeimob.fastboot.bizvane.mapper.BargainPlayersMapper;
import com.wmeimob.fastboot.bizvane.mapper.ConfigMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityOrdersMapper;
import com.wmeimob.fastboot.bizvane.service.GoodsService;
import com.wmeimob.fastboot.bizvane.service.MarketActivityGoodsService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.starter.common.entity.RichText;
import com.wmeimob.fastboot.starter.common.service.RichTextService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="marketActivityGoodsService")
public class MarketActivityGoodsServiceImpl
implements MarketActivityGoodsService {
    private static final Logger log = LoggerFactory.getLogger(MarketActivityGoodsServiceImpl.class);
    @Autowired
    private MarketActivityGoodsMapper marketActivityGoodsMapper;
    @Autowired
    private BargainPlayersMapper bargainPlayersMapper;
    public static String REDIS_FREEZE_STOCK_KEY = "wx_reducePrice_freeze_stock_";
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private MarketActivityOrdersMapper marketActivityOrdersMapper;
    @Autowired
    private RichTextService richTextService;
    @Autowired
    private GoodsService goodsService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private MarketActivityMapper marketActivityMapper;
    @Autowired
    private ConfigMapper configMapper;
    @Autowired
    private GoodsSkuDetailMapper goodsSkuDetailMapper;

    public ReduceProductDto queryActivityGoodsInfo(MarketActivityGoods mag, String activitySign, String showSkuNo, String userNo) {
        if ("1".equals(activitySign) || "3".equals(activitySign)) {
            if (StringUtils.isEmpty((String)mag.getActivityOrderNo())) {
                throw new CustomException("\u67e5\u8be2\u8fdb\u884c\u4e2d\u7684\u780d\u4ef7\u8ba2\u5355\uff0c\u672a\u7ed9\u5230\u8425\u9500\u8ba2\u5355\u53f7:" + mag.getActivityOrderNo());
            }
            showSkuNo = null;
        } else {
            if (StringUtils.isEmpty((String)showSkuNo)) {
                throw new CustomException("\u53d1\u8d77\u6216\u91cd\u65b0\u53d1\u8d77\u9700\u8981\u63d0\u4f9bshowSkuNo");
            }
            mag.setSkuNo(null);
        }
        List goodsDetail = this.marketActivityGoodsMapper.getGoodsDetail(mag.getMarketActivityNo(), mag.getSkuNo(), mag.getGoodsNo(), null, null);
        return this.getShowOrRealResult(goodsDetail, mag, activitySign, showSkuNo, mag.getActivityOrderNo(), userNo);
    }

    public Object getSkuSpcInfo(Goods goods, List<String> selectedSkuNos) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        RichText byId = this.richTextService.findById(goods.getIntroId());
        map.put("richText", byId);
        List goodsSkus = this.goodsService.getGoodsSkus(goods.getId());
        ArrayList<GoodsSkuDetail> findSkus = new ArrayList<GoodsSkuDetail>();
        ArrayList<String> specIds = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(selectedSkuNos)) {
            block0: for (GoodsSkuDetail skus : goodsSkus) {
                for (String string : selectedSkuNos) {
                    if (!skus.getSkuNo().equals(string)) continue;
                    findSkus.add(skus);
                    specIds.add(skus.getSpecIds());
                    continue block0;
                }
            }
        }
        StringBuffer sb = new StringBuffer();
        if (!CollectionUtils.isEmpty(specIds)) {
            specIds.stream().forEach(e -> {
                if (!StringUtils.isEmpty((String)e)) {
                    sb.append((String)e).append(",");
                }
            });
        }
        String[] split = sb.toString().split(",");
        HashSet<Integer> specList = null;
        if (split.length > 0) {
            specList = new HashSet<Integer>();
            for (String s : split) {
                specList.add(Integer.parseInt(s));
            }
        }
        findSkus.forEach(g -> g.setStock(Integer.valueOf(g.getIsEnabled() != false ? g.getStock() : 0)));
        findSkus.forEach(e -> {
            e.setStock(Integer.valueOf(e.getIsEnabled() != false ? e.getStock() : 0));
            Integer freezeStockInRedis = this.getFreezeStockInRedis(goods.getId() + "", e.getSkuNo());
            e.setStock(Integer.valueOf(e.getStock() - freezeStockInRedis));
        });
        map.put("goodsSkus", findSkus);
        if (!goods.getIsUniform().booleanValue()) {
            List list = this.goodsService.getGoodsSpecs(goods.getId());
            ArrayList<GoodsSpecRelation> newGoodsSpecRelations = new ArrayList<GoodsSpecRelation>();
            if (!CollectionUtils.isEmpty(specList)) {
                block3: for (GoodsSpecRelation gs : list) {
                    for (Integer it : specList) {
                        if (!gs.getSpecId().equals(it) && !gs.getPid().equals(0)) continue;
                        newGoodsSpecRelations.add(gs);
                        continue block3;
                    }
                }
                map.put("goodsSpecs", newGoodsSpecRelations);
            }
        }
        return map;
    }

    private ReduceProductDto getShowOrRealResult(List<MarketActivityGoods> goodsDetail, MarketActivityGoods mag, String activitySign, String showSkuNo, String marketActivityOrdersNo, String userNo) {
        List selectedSkuNos = goodsDetail.stream().map(e -> e.getSkuNo()).collect(Collectors.toList());
        ReduceProductDto rpd = new ReduceProductDto();
        MarketActivityGoods show = null;
        if (!StringUtils.isEmpty((String)showSkuNo)) {
            show = goodsDetail.stream().filter(e -> e.getSkuNo().equals(showSkuNo)).findFirst().get();
            rpd.setSalePrice(show.getPrice());
            rpd.setMinPrice(show.getAmount());
            rpd.setShowSkuStock(Integer.valueOf(show.getStock() - this.getFreezeStockInRedis(show.getGoodsId(), showSkuNo)));
            BeanUtils.copyProperties((Object)show, (Object)rpd);
            rpd.setStrillCanReducePrice(show.getPrice().subtract(show.getAmount()));
            rpd.setBarginNum(show.getBargainNum());
            rpd.setShowSkuNo(show.getSkuNo());
        }
        MarketActivity ma = new MarketActivity();
        ma.setActivityNo(mag.getMarketActivityNo());
        ma = (MarketActivity)this.marketActivityMapper.selectOne((Object)ma);
        BargainPlayers bp = new BargainPlayers();
        bp.setActivityOrdersNo(marketActivityOrdersNo);
        List select = this.bargainPlayersMapper.select((Object)bp);
        if ("1".equals(activitySign) || "3".equals(activitySign)) {
            MarketActivityGoods real = goodsDetail.stream().filter(e -> e.getSkuNo().equals(mag.getSkuNo())).findFirst().get();
            BeanUtils.copyProperties((Object)real, (Object)rpd);
            if (!CollectionUtils.isEmpty((Collection)select)) {
                BigDecimal reduce = select.stream().map(e -> e.getAmount()).reduce(BigDecimal.ZERO, (x, y) -> y.add((BigDecimal)x));
                BigDecimal subtract = real.getPrice().subtract(real.getAmount());
                rpd.setStrillCanReducePrice(subtract.subtract(reduce));
            } else {
                rpd.setStrillCanReducePrice(real.getPrice().subtract(real.getAmount()));
            }
            MarketActivityGoods marketActivityGoods = this.marketActivityOrdersMapper.selectActivityOrdersInfo(marketActivityOrdersNo);
            real.setGmtCreate(marketActivityGoods.getGmtCreate());
            real.setActivityTermValidity(marketActivityGoods.getActivityTermValidity());
            long time = DateUtils.addHours((Date)real.getGmtCreate(), (int)real.getActivityTermValidity()).getTime();
            long time1 = new Date().getTime();
            rpd.setRemainingTime(time - time1 + "");
            rpd.setSalePrice(real.getPrice());
            rpd.setMinPrice(real.getAmount());
            rpd.setBarginNum(real.getBargainNum());
            rpd.setShowSkuNo(real.getSkuNo());
            rpd.setStock(real.getStock());
            rpd.setGoodsSkuName(real.getGoodSkuName());
            rpd.setGoodsSku(real.getSkuNo());
            rpd.setGoodsName(real.getGoodsName());
            rpd.setMerchantId(real.getMerchantId());
        } else {
            MarketActivityOrders mao = new MarketActivityOrders();
            mao.setLaunchUserNo(userNo);
            mao.setOrdersStatus("0");
            mao.setActivityOrdersType("0");
            mao.setActivityNo(mag.getMarketActivityNo());
            mao = (MarketActivityOrders)this.marketActivityOrdersMapper.selectOne((Object)mao);
            if (mao != null) {
                mag.setActivityOrderNo(mao.getActivityOrdersNo());
                mag.setSkuNo(mao.getGoodsSkuNo());
                activitySign = !CollectionUtils.isEmpty((Collection)select) ? (ma.getActivityPersonNum().equals(select.size()) ? "3" : "1") : "1";
                this.queryActivityGoodsInfo(mag, activitySign, showSkuNo, userNo);
            }
        }
        Goods goods = this.goodsMapper.selectById(Integer.valueOf(Integer.parseInt(mag.getGoodsId())));
        rpd.setReduceRule(ma.getActivityDetail());
        rpd.setVideoImg(goods.getVideoImg());
        rpd.setVideoPaths(goods.getVideoPaths());
        rpd.setBannerImgPaths(goods.getBannerImgPaths());
        rpd.setGoodsPicUrl(goods.getCoverImg());
        rpd.setMap((Map)this.getSkuSpcInfo(goods, selectedSkuNos));
        return rpd;
    }

    private Integer getFreezeStockInRedis(String goodsId, String showSkuNo) {
        String key = REDIS_FREEZE_STOCK_KEY + goodsId + "-" + showSkuNo;
        try {
            ValueOperations ops = this.stringRedisTemplate.opsForValue();
            if (ops.getOperations().hasKey((Object)key).booleanValue()) {
                String s = (String)ops.get((Object)key);
                return Integer.parseInt(s);
            }
            return 0;
        }
        catch (Exception e) {
            log.error("reids\u5f02\u5e38:[{}]", (Object)e.getMessage());
            throw new CustomException("redis\u5f02\u5e38", (Throwable)e);
        }
    }
}

