/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.dto.WxqyLoginResponseVO;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.UserService;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.core.context.RequestAttributeContext;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.open.service.MiniprogramUserService;
import com.wmeimob.fastboot.starter.security.JwtAuthenticationFilter;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import com.wmeimob.wechat.open.core.Wechat3rdPlatformHandler;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import me.hao0.wechat.core.Wechat;
import me.hao0.wechat.core.WechatBuilder;
import me.hao0.wechat.model.base.EncryptWatermark;
import me.hao0.wechat.model.base.JSCode2SessionResponse;
import me.hao0.wechat.model.user.MiniprogramUserInfo;
import me.hao0.wechat.model.user.MiniprogramUserPhoneInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"user"})
public class UserController {
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    @Resource
    private Wechat3rdPlatformHandler wechat3rdPlatformHandler;
    @Resource
    private JwtAuthenticationFilter jwtAuthenticationFilter;
    @Resource
    private UserService userService;
    @Resource
    private MiniprogramUserService miniprogramUserService;
    @Resource
    private ConfigService configService;
    @Resource
    private BizvaneInterface bizvaneInterface;

    @PostMapping(value={"forward"})
    public String decodeEncryptoData(@RequestHeader(value="appid") String appid, @RequestHeader(value="merchantId") Integer merchantId, @RequestBody EncryptWatermark encryptWatermark) {
        User user = (User)SecurityContext.getUser();
        Wechat wechat = WechatBuilder.newBuilder((String)appid).build();
        encryptWatermark.setSessionKey(this.miniprogramUserService.get(appid, user.getOpenid()).getSession_key());
        MiniprogramUserInfo userInfo = wechat.user().decodeEncryptUserInfo(encryptWatermark);
        log.info("decrypt user info => {}", (Object)userInfo);
        if (userInfo.getUnionId() == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u4fe1\u606f");
        }
        User queryParams = User.builder().openid(userInfo.getOpenId()).unionid(userInfo.getUnionId()).appid(appid).merchantId(merchantId).build();
        User remoteUser = (User)this.userService.findOneByCondition((Serializable)queryParams);
        remoteUser.setAppid(appid);
        return this.jwtAuthenticationFilter.getJsonWebTokenHandler().generateToken((UserDetails)remoteUser);
    }

    @PostMapping(value={"decodePhone"})
    public MiniprogramUserPhoneInfo decodePhone(@RequestHeader(value="appid") String appid, @RequestBody EncryptWatermark encryptWatermark) {
        Wechat wechat = WechatBuilder.newBuilder((String)appid).build();
        User user = (User)SecurityContext.getUser();
        encryptWatermark.setSessionKey(this.miniprogramUserService.get(appid, user.getOpenid()).getSession_key());
        return wechat.user().decodeEncryptUserPhoneInfo(encryptWatermark);
    }

    @GetMapping(value={"info"})
    public User getUserInfo() {
        User user = (User)SecurityContext.getUser();
        return this.bizvaneInterface.getMemberInfo(user);
    }

    @GetMapping(value={"login"})
    public Map<String, Object> getOpenid(@RequestHeader(value="appid") String appid, @RequestHeader(value="merchantId") Integer merchantId, @RequestParam(value="code") String code) {
        JSONObject config;
        log.info("appid:{},merchantId:{}", (Object)appid, (Object)merchantId);
        JSCode2SessionResponse openidAndSessionKey = this.bizvaneInterface.getSession(appid, code);
        log.info("miniprogram user info:" + JSONObject.toJSONString((Object)openidAndSessionKey));
        this.miniprogramUserService.save(appid, openidAndSessionKey);
        User queryParams = User.builder().openid(openidAndSessionKey.getOpenid()).unionid(openidAndSessionKey.getUnionid()).appid(appid).merchantId(merchantId).build();
        HashMap<String, Object> map = new HashMap<String, Object>();
        User user = (User)this.userService.findOneByCondition((Serializable)queryParams);
        user.setAppid(appid);
        map.put("user", user);
        log.info("\u767b\u5f55user:[{}]", (Object)JSONObject.toJSONString((Object)user));
        try {
            config = this.bizvaneInterface.getMiniprogramRedirectConfiguration(appid);
            map.put("miniprogramConfig", config);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            JSONObject config2 = new JSONObject();
            config2.put("appId", (Object)"wxe9f923caf2a6024e");
            config2.put("url", (Object)"/pages/index/index");
            map.put("miniprogramConfig", config2);
        }
        config = new Config();
        config.setMerchantId(merchantId);
        Config oneByCondition = (Config)this.configService.findOneByCondition((Serializable)config);
        if (oneByCondition == null) {
            throw new CustomException("\u5546\u6237\u672a\u914d\u7f6e\uff0c\u6682\u65f6\u65e0\u6cd5\u67e5\u770b");
        }
        map.put("miniprogramTitle", oneByCondition.getTitle());
        String token = this.jwtAuthenticationFilter.getJsonWebTokenHandler().generateToken((UserDetails)user);
        map.put("access_token", token);
        if (StringUtils.isEmpty((Object)openidAndSessionKey.getUnionid())) {
            RequestAttributeContext.getResponse().setStatus(HttpStatus.ACCEPTED.value());
        }
        return map;
    }

    @PostMapping(value={"wxqyLogin"})
    public ResponseData<WxqyLoginResponseVO> wxqyLogin(@RequestParam(value="appid") String appid, @RequestParam(value="code") String code) {
        ResponseData wxqyLoginResponse = this.bizvaneInterface.wxqyLogin(appid, code);
        return wxqyLoginResponse;
    }
}

