/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.vo.CreateMiniprgmQRCodeRequestVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"guide"})
@RestController
public class ShopperGuiderController {
    private static final Logger log = LoggerFactory.getLogger(ShopperGuiderController.class);
    @Autowired
    private BizvaneInterface bizvaneInterface;

    @GetMapping(value={"wxGuideQrPic"})
    public JSONObject wxaCode(@RequestHeader(value="merchantId") Long merchantId, @RequestParam(value="path") String path, @RequestParam(value="guiderShare") String guiderShare) {
        log.info("\u751f\u6210\u4e8c\u7ef4\u7801\u5165\u53c2:merchant[{}]\uff0cpath:[{}],guiderShare:[{}]", new Object[]{merchantId, path, guiderShare});
        CreateMiniprgmQRCodeRequestVO vo = new CreateMiniprgmQRCodeRequestVO();
        vo.setScene(guiderShare);
        vo.setPath(path);
        vo.setSysBrandId(merchantId);
        JSONObject jsonObject = this.bizvaneInterface.generateQrCode(vo);
        if (jsonObject != null) {
            log.info("\u751f\u6210\u4e8c\u7ef4\u7801\u8fd4\u53c2:[{}]", (Object)jsonObject.toString());
        } else {
            log.info("\u751f\u6210\u4e8c\u7ef4\u7801\u8fd4\u53c2\u4e3a\u7a7a");
        }
        return jsonObject;
    }
}

