/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.dto.ShopCartDTO;
import com.wmeimob.fastboot.bizvane.dto.UserDiscountDTO;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.ShopCart;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.ShopCartService;
import com.wmeimob.fastboot.bizvane.service.UserService;
import com.wmeimob.fastboot.core.context.PageContext;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"shop-carts"})
public class ShopCartController {
    private static final Logger log = LoggerFactory.getLogger(ShopCartController.class);
    @Resource
    private ShopCartService shopCartService;
    @Resource
    private ConfigService configService;
    @Resource
    private UserService userService;

    @PostMapping
    public void add(@RequestBody ShopCart shopCart) {
        log.info("\u6dfb\u52a0\u8d2d\u7269\u8f66:{}", (Object)shopCart);
        this.shopCartService.add((Serializable)this.getCondition(shopCart));
    }

    @DeleteMapping(value={"{id}"})
    public void delete(@PathVariable(value="id") Integer id) {
        ShopCart shopCart = new ShopCart();
        shopCart.setId(id);
        this.shopCartService.delete(id, (Serializable)this.getCondition(shopCart));
    }

    @GetMapping(value={"count"})
    public Integer getShopCart() {
        return this.shopCartService.queryCount(this.getCondition());
    }

    @DeleteMapping
    public void deleteAll(@RequestBody Integer[] idArr) {
        this.shopCartService.delete(idArr);
    }

    @GetMapping
    public PageInfo<ShopCartDTO> getShopCarts() {
        UserDiscountDTO userDiscountDTO;
        Config config;
        log.info("\u83b7\u53d6\u8d2d\u7269\u8f66\u4e2d\u5546\u54c1\u5217\u8868....START....");
        User user = (User)SecurityContext.getUser();
        ShopCart shopCart = new ShopCart();
        shopCart.setWechatOpenid(user.getOpenid());
        shopCart.setMerchantId(user.getMerchantId());
        PageContext.startPage();
        List list = this.shopCartService.queryShopCartGoods(shopCart);
        if (!CollectionUtils.isEmpty((Collection)list) && (config = this.configService.findSysConfig(user.getMerchantId())) != null && user != null && config.getPriceDisplay().equals(1) && (userDiscountDTO = this.userService.getUserDiscountInfo(user)) != null && userDiscountDTO.getDiscount() != null) {
            list.forEach(shopCartDTO -> shopCartDTO.setVipPrice(shopCartDTO.getSalesPrice().multiply(userDiscountDTO.getDiscount()).setScale(2, 4)));
        }
        PageInfo pageInfo = new PageInfo(list);
        log.info("\u83b7\u53d6\u8d2d\u7269\u8f66\u4e2d\u5546\u54c1\u5217\u8868....END....  \u7ed3\u679c\u96c6\u4e3a:{}", (Object)pageInfo);
        return pageInfo;
    }

    private ShopCart getCondition() {
        User user = (User)SecurityContext.getUser();
        ShopCart shopCart = new ShopCart();
        shopCart.setWechatOpenid(user.getOpenid());
        shopCart.setMerchantId(user.getMerchantId());
        log.info("\u8d2d\u7269\u8f66\u767b\u5f55\u4fe1\u606f:user:[{}]\uff0cshopUser:", JSONObject.toJSON((Object)user), JSONObject.toJSON((Object)shopCart));
        return shopCart;
    }

    private ShopCart getCondition(ShopCart shopCart) {
        User user = (User)SecurityContext.getUser();
        shopCart.setMerchantId(user.getMerchantId());
        shopCart.setWechatOpenid(user.getOpenid());
        log.info("\u8d2d\u7269\u8f66\u767b\u5f55\u4fe1\u606f:user:[{}]", JSONObject.toJSON((Object)shopCart));
        return shopCart;
    }
}

