/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.dto.FriendsReduceDto;
import com.wmeimob.fastboot.bizvane.dto.ReduceHelpResponse;
import com.wmeimob.fastboot.bizvane.dto.ReduceProductDto;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityGoods;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityOrders;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.mapper.ConfigMapper;
import com.wmeimob.fastboot.bizvane.service.BargainPlayersService;
import com.wmeimob.fastboot.bizvane.service.MarketActivityGoodsService;
import com.wmeimob.fastboot.bizvane.service.MarketActivityOrdersService;
import com.wmeimob.fastboot.bizvane.service.MarketActivityService;
import com.wmeimob.fastboot.bizvane.service.UserCommissionService;
import com.wmeimob.fastboot.bizvane.service.UserService;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.starter.security.context.SecurityContext;
import com.wmeimob.fastboot.util.StringUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/reducePrice"})
public class ReducePriceController {
    private static final Logger log = LoggerFactory.getLogger(ReducePriceController.class);
    @Autowired
    private MarketActivityService marketActivityService;
    @Autowired
    private MarketActivityGoodsService marketActivityGoodsService;
    @Autowired
    private MarketActivityOrdersService marketActivityOrdersService;
    @Autowired
    private UserService userService;
    @Autowired
    private BargainPlayersService bargainPlayersService;
    @Autowired
    private UserCommissionService userCommissionService;
    @Autowired
    private ConfigMapper configMapper;

    @GetMapping(value={"/getProductInfo"})
    @ResponseBody
    public RestResult getProductInfo(@RequestParam(value="goodsId") String goodsId, @RequestParam(value="marketActivityNo") String marketActivityNo, @RequestParam(value="skuNo", required=false) String skuNo, @RequestParam(value="activitySign") String activitySign, @RequestParam(value="showSkuNo") String showSkuNo, @RequestParam(value="marketActivityOrdersNo", required=false) String marketActivityOrdersNo) {
        User user = (User)SecurityContext.getUser();
        log.info("\u767b\u5f55\u7528\u6237\u662fuserNo:[{}]", (Object)user.getUserNo());
        MarketActivityGoods mag = new MarketActivityGoods();
        mag.setMarketActivityNo(marketActivityNo);
        mag.setGoodsId(goodsId);
        mag.setSkuNo(skuNo);
        mag.setActivityOrderNo(marketActivityOrdersNo);
        mag.setMarketActivityNo(marketActivityNo);
        log.info("\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u5165\u53c2:[{}],activitySign:[{}],showSkuNo:[{}]", new Object[]{JSON.toJSON((Object)mag), activitySign, showSkuNo});
        HashMap<String, ReduceProductDto> map = new HashMap<String, ReduceProductDto>();
        ReduceProductDto reduceProductDto = null;
        try {
            reduceProductDto = this.marketActivityGoodsService.queryActivityGoodsInfo(mag, activitySign, showSkuNo, user.getUserNo());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            RestResult.fail((String)e.getMessage());
        }
        if (reduceProductDto == null) {
            return RestResult.fail((String)"\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u8bb0\u5f55");
        }
        map.put("result", reduceProductDto);
        return RestResult.success(map);
    }

    @GetMapping(value={"/queryReduce"})
    @ResponseBody
    public RestResult queryReduce(@RequestHeader(value="merchantId") String merchantId, @RequestParam(value="pageNum") int pageNum, @RequestParam(value="pageSize") int pageSize) {
        HashMap<String, PageInfo> map = new HashMap<String, PageInfo>();
        PageInfo reducePriceDtoPageInfo = null;
        try {
            reducePriceDtoPageInfo = this.marketActivityService.queryReducePage(merchantId, pageNum, pageSize);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            RestResult.fail((String)e.getMessage());
        }
        if (reducePriceDtoPageInfo == null || CollectionUtils.isEmpty((Collection)reducePriceDtoPageInfo.getList())) {
            return RestResult.fail((String)"\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u8bb0\u5f55");
        }
        map.put("result", reducePriceDtoPageInfo);
        return RestResult.success(map);
    }

    @GetMapping(value={"/queryMyReduce"})
    @ResponseBody
    public RestResult queryMyReduce(@RequestParam(value="pageNum") int pageNum, @RequestParam(value="pageSize") int pageSize, @RequestHeader(value="merchantId") Integer merchantId) {
        User user = (User)SecurityContext.getUser();
        Date currentTime = new Date();
        MarketActivityOrders mao = new MarketActivityOrders();
        mao.setLaunchUserNo(user.getUserNo());
        mao.setUserNo(user.getUserNo());
        log.info("\u767b\u5f55\u7528\u6237\u662fuserNo:[{}]", (Object)user.getUserNo());
        HashMap<String, PageInfo> map = new HashMap<String, PageInfo>();
        PageInfo reducePriceDtoPageInfo = null;
        try {
            reducePriceDtoPageInfo = this.marketActivityOrdersService.queryMyReduce(currentTime, mao, merchantId, pageNum, pageSize);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            RestResult.fail((String)e.getMessage());
        }
        if (reducePriceDtoPageInfo == null || CollectionUtils.isEmpty((Collection)reducePriceDtoPageInfo.getList())) {
            return RestResult.fail((String)"\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u8bb0\u5f55");
        }
        map.put("result", reducePriceDtoPageInfo);
        return RestResult.success(map);
    }

    @GetMapping(value={"/initActivity"})
    @ResponseBody
    public Map<String, String> addActivity(@RequestParam(value="marketActivityNo") String marketActivityNo, @RequestParam(value="skuNo") String skuNo, @RequestParam(value="goodsId") Integer goodsId) {
        log.info("\u5165\u53c2:marketActivityNo:[{}],skuNO:[{}]", (Object)marketActivityNo, (Object)skuNo);
        User user = (User)SecurityContext.getUser();
        HashMap<String, String> map = new HashMap<String, String>();
        String result = "";
        try {
            map.put("code", "0");
            log.info("\u53d1\u8d77\u4eba\u662fuserNo:[{}]", (Object)user.getUserNo());
            result = this.marketActivityOrdersService.addMarketActivityOrders(user.getUserNo(), skuNo, marketActivityNo, goodsId);
            if (StringUtils.isEmpty((Object)result)) {
                map.put("code", "-1");
                map.put("msg", "\u672a\u67e5\u8be2\u5230\u7ed3\u679c");
            } else if ("0".equals(result)) {
                map.put("code", "-1");
            } else {
                map.put("data", result);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put("code", "-1");
            map.put("msg", e.getMessage());
        }
        return map;
    }

    @GetMapping(value={"getWithFriendsInfo"})
    @ResponseBody
    public RestResult withFriends(@RequestParam(value="activityOrdersNo") String activityOrdersNo, @RequestParam(value="showGoodsId") String showGoodsId, @RequestParam(value="showSkuNo") String showSkuNo, @RequestHeader(value="merchantId") Integer merchantId, @RequestParam(value="openId") String openId) {
        log.info("\u70b9\u51fb\u5206\u4eab\u94fe\u63a5\u5165\u53c2:activityOrdersNo:[{}],showGoodsId:[{}],showSkuNo:[{}],merchantId:[{}]", new Object[]{activityOrdersNo, showGoodsId, showSkuNo, merchantId});
        User user = (User)SecurityContext.getUser();
        HashMap<String, FriendsReduceDto> map = new HashMap<String, FriendsReduceDto>();
        FriendsReduceDto reducePriceDtoPageInfo = null;
        log.info("\u767b\u5f55\u7528\u6237\u662fuserNo:[{}]", (Object)user.getUserNo());
        try {
            reducePriceDtoPageInfo = this.marketActivityOrdersService.queryWithFriendsInfo(user.getUserNo(), activityOrdersNo, showGoodsId, showSkuNo, merchantId, openId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            RestResult.fail((String)e.getMessage());
        }
        if (reducePriceDtoPageInfo == null) {
            return RestResult.fail((String)"\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u8bb0\u5f55");
        }
        map.put("result", reducePriceDtoPageInfo);
        return RestResult.success(map);
    }

    @GetMapping(value={"getHelpFriendsInfo"})
    @ResponseBody
    public RestResult helpFriends(@RequestParam(value="activityOrdersNo") String activityOrdersNo, @RequestParam(value="goodsId") String goodsId, @RequestParam(value="showSkuNo") String showSkuNo, @RequestParam(value="openId") String openId) {
        log.info("\u597d\u53cb\u70b9\u51fb\u5206\u4eab\u94fe\u63a5\u5165\u53c2:activityOrdersNo:[{}],goodsId:[{}],showSkuNo:[{}]", new Object[]{activityOrdersNo, goodsId, showSkuNo, showSkuNo});
        User user = (User)SecurityContext.getUser();
        HashMap<String, FriendsReduceDto> map = new HashMap<String, FriendsReduceDto>();
        FriendsReduceDto reducePriceDtoPageInfo = null;
        log.info("\u767b\u5f55\u7528\u6237\u662fuserNo:[{}]", (Object)user.getUserNo());
        try {
            reducePriceDtoPageInfo = this.marketActivityOrdersService.queryHelpFriends(user.getUserNo(), activityOrdersNo, goodsId, showSkuNo, openId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            RestResult.fail((String)e.getMessage());
        }
        if (reducePriceDtoPageInfo == null) {
            return RestResult.fail((String)"\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u8bb0\u5f55");
        }
        map.put("result", reducePriceDtoPageInfo);
        return RestResult.success(map);
    }

    @GetMapping(value={"helpReducePrice"})
    @ResponseBody
    public Map<String, Object> helpReducePrice(@RequestParam(value="goodsId") String goodsId, @RequestParam(value="goodsNo") String goodsNo, @RequestParam(value="activityOrdersNo") String activityOrdersNo, @RequestParam(value="openId") String openId, @RequestParam(value="nickName") String nickName, @RequestParam(value="avatarUrl") String avatarUrl) {
        log.info("\u597d\u53cb\u780d\u4ef7\u5165\u53c2:goodsId:[{}],goodsNo:[{}],activityOrdersNo:[{}]", new Object[]{goodsId, goodsNo, activityOrdersNo});
        User user = (User)SecurityContext.getUser();
        user.setUserNo(user.getUserNo());
        user.setWechatUserId(user.getWechatUserId());
        user.setHeadImgUrl(avatarUrl);
        user.setFullName(nickName);
        user.setOpenid(openId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        ReduceHelpResponse reducePriceDtoPageInfo = null;
        log.info("\u767b\u5f55\u7528\u6237\u662fuserNo:[{}]", (Object)user.getUserNo());
        try {
            reducePriceDtoPageInfo = this.marketActivityService.handleHelpFriends(goodsId, goodsNo, user, activityOrdersNo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put("code", -1);
            map.put("msg", e.getMessage());
            return map;
        }
        if (reducePriceDtoPageInfo == null) {
            map.put("code", -1);
            map.put("msg", "\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u8bb0\u5f55");
            return map;
        }
        map.put("code", 0);
        map.put("data", reducePriceDtoPageInfo);
        return map;
    }

    @GetMapping(value={"/flushBarginPlays"})
    @ResponseBody
    public RestResult flushBarginPlays(@RequestParam(value="activityOrdersNo") String activityOrdersNo) {
        return this.bargainPlayersService.queryBarginPlays(activityOrdersNo);
    }

    @PostMapping(value={"confirmOk"})
    public Integer confirmOk(@RequestHeader(value="merchantId") Integer merchantId, @RequestHeader(value="appid") String appid, @RequestBody Orders orders) {
        User user = (User)SecurityContext.getUser();
        log.info("\u767b\u5f55\u7528\u6237\u662fuserNo:[{}],\u521b\u5efa\u8ba2\u5355\u5165\u53c2:[{}],appid:[{}]", new Object[]{user.getUserNo(), JSON.toJSON((Object)orders), appid});
        User queryUser = (User)this.userService.findOneByCondition((Serializable)user);
        orders.setWechatOpenid(user.getOpenid());
        orders.setUserNo(user.getUserNo());
        orders.setMerchantId(merchantId);
        orders.setUserId(user.getUserId());
        orders.setUserName(queryUser.getFullName());
        orders.setAppid(appid);
        orders.setWechatUnionId(queryUser.getUnionid());
        Boolean parentState = this.userCommissionService.findParentState(queryUser.getUserNo());
        orders.setEnabledCommission(parentState);
        orders.setWechatUnionId(queryUser.getUnionid());
        return this.marketActivityOrdersService.addOrder(orders);
    }

    @PostMapping(value={"confirm"})
    public Orders confirm(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody Orders orders) {
        log.info("POST...method:\u780d\u4ef7 confirm....params===>{}", (Object)JSONObject.toJSONString((Object)orders));
        User user = (User)SecurityContext.getUser();
        orders.setUserId(user.getUserId());
        orders.setUserNo(user.getUserNo());
        orders.setWechatUnionId(user.getUnionid());
        orders.setMerchantId(merchantId);
        return this.marketActivityOrdersService.confirm(orders);
    }

    @GetMapping(value={"getConfig"})
    @ResponseBody
    public Config getConfig(@RequestHeader(value="merchantId") Integer merchantId) {
        Config condition = new Config();
        condition.setMerchantId(merchantId);
        Config config = (Config)this.configMapper.selectOne((Object)condition);
        return config;
    }
}

