/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.github.pagehelper.PageInfo;
import com.mzlion.core.json.fastjson.JsonUtil;
import com.wmeimob.fastboot.bizvane.dto.FriendsReduceDto;
import com.wmeimob.fastboot.bizvane.dto.ReduceHelpResponse;
import com.wmeimob.fastboot.bizvane.dto.ReduceProductDto;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.KafkaTrack;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityGoods;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityOrders;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.mapper.ConfigMapper;
import com.wmeimob.fastboot.bizvane.service.ActivityService;
import com.wmeimob.fastboot.bizvane.service.AssembleService;
import com.wmeimob.fastboot.bizvane.service.BargainPlayersService;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.MarketActivityGoodsService;
import com.wmeimob.fastboot.bizvane.service.MarketActivityOrdersService;
import com.wmeimob.fastboot.bizvane.service.MarketActivityService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.service.OrdersServiceImpl;
import com.wmeimob.fastboot.bizvane.service.UserCommissionService;
import com.wmeimob.fastboot.bizvane.service.UserService;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"test"})
public class TestController {
    private static final Logger log = LoggerFactory.getLogger(TestController.class);
    @Autowired
    private ActivityService activityService;
    @Autowired
    private OrdersServiceImpl ordersService;
    @Autowired
    private BizvaneInterface bizvaneInterface;
    @Resource(name="commonOrdersServiceImpl")
    private OrdersService commonOrdersServiceImpl;
    @Autowired
    private AssembleService assembleService;
    @Autowired
    private MarketActivityService marketActivityService;
    @Autowired
    private MarketActivityGoodsService marketActivityGoodsService;
    @Autowired
    private MarketActivityOrdersService marketActivityOrdersService;
    @Autowired
    private BargainPlayersService bargainPlayersService;
    @Autowired
    private UserCommissionService userCommissionService;
    @Autowired
    private UserService userService;
    @Autowired
    private ConfigMapper configMapper;

    @PostMapping(value={"/get"})
    public List<Goods> getGoodsPros(@RequestBody List<Goods> queryDiscountGoods) {
        List list = this.activityService.queryDiscountByShopCartGoods(Integer.valueOf(96), queryDiscountGoods);
        return list;
    }

    @PostMapping(value={"/haha"})
    public Orders payConfirm(@RequestBody Orders payOrders) {
        return this.ordersService.payConfirm(payOrders);
    }

    @PostMapping(value={"/haha1"})
    public List<Goods> goods(@RequestParam(value="merchantId") Integer merchantId, @RequestParam(value="amount") BigDecimal amount) {
        return this.activityService.queryCurrentGiftGoodsByAmount(merchantId, amount);
    }

    @GetMapping(value={"/testGetUserBalance"})
    public BigDecimal getUserBalance(@RequestParam(value="memberCode") String memberCode) {
        return this.bizvaneInterface.getUserBalance(memberCode);
    }

    @GetMapping(value={"/testGetIntegralProportion"})
    public BigDecimal getIntegralProportion(@RequestParam(value="memberCode") String memberCode) {
        return this.bizvaneInterface.getIntegralProportion(memberCode);
    }

    @GetMapping(value={"/testGetUserIntegral"})
    public Integer getUserIntegral(@RequestParam(value="memberCode") String memberCode) {
        return this.bizvaneInterface.getUserIntegral(memberCode);
    }

    @PostMapping(value={"getKafka"})
    public RestResult getKafka(@RequestBody KafkaTrack kafkaTrack) {
        kafkaTrack.setAppType("0");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        kafkaTrack.setCreateTime(sdf.format(new Date()));
        return this.bizvaneInterface.kafkaTrack(kafkaTrack);
    }

    @GetMapping(value={"/testBalance"})
    public RestResult balance(@RequestParam(value="memberCode") String memberCode, @RequestParam(value="balance") BigDecimal balance, @RequestParam(value="code") int code) {
        return this.bizvaneInterface.operationBalance(memberCode, balance, code, "www");
    }

    @GetMapping(value={"/testIntegral"})
    public RestResult integral(@RequestParam(value="memberCode") String memberCode, @RequestParam(value="integral") Integer integral, @RequestParam(value="code") int code) {
        return this.bizvaneInterface.operationIntegral(memberCode, integral, code, "222");
    }

    @PostMapping(value={"/haha2"})
    public Orders haha2(@RequestBody Orders orders) {
        return this.ordersService.add(orders);
    }

    @GetMapping(value={"/haha3"})
    public Orders haha3(@RequestParam(value="id") Integer id) {
        return (Orders)this.commonOrdersServiceImpl.findById(id);
    }

    @GetMapping(value={"/testGetActivityGoodList"})
    public List<MarketActivityGoods> getActivityGoodList(@RequestHeader(value="merchantId") Integer merchantId) {
        return this.assembleService.getActivityGoodList(merchantId);
    }

    @GetMapping(value={"/getProductInfo"})
    @ResponseBody
    public RestResult getProductInfo(@RequestParam(value="goodsId") String goodsId, @RequestParam(value="marketActivityNo") String marketActivityNo, @RequestParam(value="skuNo", required=false) String skuNo, @RequestParam(value="activitySign", required=true) String activitySign, @RequestParam(value="showSkuNo", required=true) String showSkuNo, @RequestParam(value="marketActivityOrdersNo", required=true) String marketActivityOrdersNo) {
        MarketActivityGoods mag = new MarketActivityGoods();
        mag.setMarketActivityNo(marketActivityNo);
        mag.setGoodsId(goodsId);
        mag.setSkuNo(skuNo);
        mag.setActivityOrderNo(marketActivityOrdersNo);
        mag.setMarketActivityNo(marketActivityNo);
        log.info("\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u5165\u53c2:[{}],activitySign:[{}],showSkuNo:[{}]", new Object[]{JSON.toJSON((Object)mag), activitySign, showSkuNo});
        HashMap<String, ReduceProductDto> map = new HashMap<String, ReduceProductDto>();
        ReduceProductDto reduceProductDto = null;
        try {
            reduceProductDto = this.marketActivityGoodsService.queryActivityGoodsInfo(mag, activitySign, showSkuNo, "4e575edb92164033");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            RestResult.fail((String)e.getMessage());
        }
        if (reduceProductDto == null) {
            return RestResult.fail((String)"\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u8bb0\u5f55");
        }
        map.put("result", reduceProductDto);
        return RestResult.success(map);
    }

    @GetMapping(value={"/queryReduce"})
    @ResponseBody
    public RestResult queryReduce(@RequestParam(value="pageNum") int pageNum, @RequestParam(value="pageSize") int pageSize) {
        HashMap<String, PageInfo> map = new HashMap<String, PageInfo>();
        PageInfo reducePriceDtoPageInfo = null;
        try {
            reducePriceDtoPageInfo = this.marketActivityService.queryReducePage(pageNum, pageSize);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            RestResult.fail((String)e.getMessage());
        }
        if (reducePriceDtoPageInfo == null || CollectionUtils.isEmpty((Collection)reducePriceDtoPageInfo.getList())) {
            return RestResult.fail((String)"\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u8bb0\u5f55");
        }
        map.put("result", reducePriceDtoPageInfo);
        return RestResult.success(map);
    }

    @GetMapping(value={"/queryMyReduce"})
    @ResponseBody
    public RestResult queryMyReduce(@RequestParam(value="pageNum") int pageNum, @RequestParam(value="pageSize") int pageSize, @RequestHeader(value="merchantId") Integer merchantId) {
        Date currentTime = new Date();
        MarketActivityOrders mao = new MarketActivityOrders();
        mao.setLaunchUserNo("4e575edb92164033");
        mao.setUserNo("4e575edb92164033");
        log.info("\u767b\u5f55\u7528\u6237\u662fuserNo:[{}]", (Object)"4e575edb92164033");
        HashMap<String, PageInfo> map = new HashMap<String, PageInfo>();
        PageInfo reducePriceDtoPageInfo = null;
        try {
            reducePriceDtoPageInfo = this.marketActivityOrdersService.queryMyReduce(currentTime, mao, merchantId, pageNum, pageSize);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (reducePriceDtoPageInfo == null || CollectionUtils.isEmpty((Collection)reducePriceDtoPageInfo.getList())) {
            return RestResult.fail((String)"\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u8bb0\u5f55");
        }
        map.put("result", reducePriceDtoPageInfo);
        return RestResult.success(map);
    }

    @GetMapping(value={"getWithFriendsInfo"})
    @ResponseBody
    public RestResult withFriends(@RequestParam(value="activityOrdersNo") String activityOrdersNo, @RequestParam(value="showGoodsId") String showGoodsId, @RequestParam(value="showSkuNo") String showSkuNo, @RequestHeader(value="merchantId") Integer merchantId, @RequestParam(value="openId") String openId) {
        HashMap<String, FriendsReduceDto> map = new HashMap<String, FriendsReduceDto>();
        FriendsReduceDto reducePriceDtoPageInfo = null;
        try {
            reducePriceDtoPageInfo = this.marketActivityOrdersService.queryWithFriendsInfo("4e575edb92164033", activityOrdersNo, showGoodsId, showSkuNo, merchantId, openId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            RestResult.fail((String)e.getMessage());
        }
        if (reducePriceDtoPageInfo == null) {
            return RestResult.fail((String)"\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u8bb0\u5f55");
        }
        map.put("result", reducePriceDtoPageInfo);
        return RestResult.success(map);
    }

    @GetMapping(value={"getHelpFriendsInfo"})
    @ResponseBody
    public RestResult helpFriends(@RequestParam(value="activityOrdersNo") String activityOrdersNo, @RequestParam(value="goodsId") String goodsId, @RequestParam(value="showSkuNo") String showSkuNo, @RequestParam(value="openId") String openId) {
        MarketActivityOrders mao = new MarketActivityOrders();
        mao.setActivityOrdersNo(activityOrdersNo);
        HashMap<String, FriendsReduceDto> map = new HashMap<String, FriendsReduceDto>();
        FriendsReduceDto reducePriceDtoPageInfo = null;
        try {
            reducePriceDtoPageInfo = this.marketActivityOrdersService.queryHelpFriends("4e575edb92164033", activityOrdersNo, goodsId, showSkuNo, openId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (reducePriceDtoPageInfo == null) {
            return RestResult.fail((String)"\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u8bb0\u5f55");
        }
        map.put("result", reducePriceDtoPageInfo);
        return RestResult.success(map);
    }

    @GetMapping(value={"helpReducePrice"})
    @ResponseBody
    public Map helpReducePrice(@RequestParam(value="goodsId") String goodsId, @RequestParam(value="goodsNo") String goodsNo, @RequestParam(value="activityOrdersNo") String activityOrdersNo) {
        User user = new User();
        user.setUserNo("4e575edb92164033");
        user.setWechatUserId(Integer.valueOf(32432));
        user.setHeadImgUrl("http://sfdafdass.jpg");
        user.setFullName("wrewqrew");
        HashMap<String, Object> map = new HashMap<String, Object>();
        ReduceHelpResponse reducePriceDtoPageInfo = null;
        try {
            reducePriceDtoPageInfo = this.marketActivityService.handleHelpFriends(goodsId, goodsNo, user, activityOrdersNo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put("code", -1);
            map.put("msg", e.getMessage());
            return map;
        }
        if (reducePriceDtoPageInfo == null) {
            map.put("code", -1);
            map.put("msg", "\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u8bb0\u5f55");
            return map;
        }
        map.put("code", 0);
        map.put("data", reducePriceDtoPageInfo);
        return map;
    }

    @GetMapping(value={"/flushBarginPlays"})
    @ResponseBody
    public RestResult flushBarginPlays(@RequestParam(value="activityOrdersNo") String activityOrdersNo) {
        return this.bargainPlayersService.queryBarginPlays(activityOrdersNo);
    }

    @GetMapping(value={"confirmOk"})
    public Integer confirmOk() {
        String str = "{\"wechatUnionId\":\"or4ga0vFPUn9JT8CR_xiQofcQWfw\",\"items\":[{\"merchantId\":96,\"goodsId\":282,\"goodsName\":\"0.6 2DAZZLE\u5730\u7d20 2019\u6625\u88c5\u65b0\u6b3e\u5f88\u4ed9\u7684\u7cfb\u5e26\u7f51\u7eb1\u857e\u4e1d\u8fde\u8863\u88d9\u5973\",\"goodsImg\":\"https://qi.test.bizvane.cn/mall/96/file/2019-4-15/dab2587b-4956-53b4-64b1-de520eeec650\",\"goodsSkuNo\":\"2G1O6327J1\",\"goodsSkuName\":\"M\",\"marketPrice\":1000,\"salePrice\":600,\"saleQuantity\":1,\"itemsAmount\":32,\"itemsActiveDeduction\":0,\"itemsPointDeduction\":0,\"itemsPayAmount\":32,\"wepayAmount\":32,\"goodsNo\":\"2G1O6327J\",\"goodsSkuNames\":[\"M\"]}],\"merchantId\":96,\"userId\":1181194,\"userNo\":\"e1669432a9f447e0\",\"orderAmount\":32,\"payAmount\":32,\"activityNo\":\"KJHD201906052044485388\",\"launchUserNo\":\"e1669432a9f447e0\",\"activityOrdersNo\":\"81591d1f-3275-4b05-911e-69f8eec289da\",\"shippingName\":\"\u97e6\u7b80\u76f4\",\"shippingMobile\":\"18200394589\",\"shippingProvince\":\"\u5317\u4eac\u5e02\",\"shippingCity\":\"\u5317\u4eac\u5e02\",\"shippingDistrict\":\"\u4e1c\u57ce\u533a\",\"shippingAddress\":\"asdfafasdf\",\"freight\":0,\"freightFee\":0.01}";
        Orders orders = (Orders)JsonUtil.fromJson((String)str, Orders.class);
        orders.setWechatOpenid("oGI6P4l0eLG33Lv4jXVRFfTjRokk");
        orders.setUserNo("e1669432a9f447e0");
        orders.setMerchantId(Integer.valueOf(96));
        orders.setUserId(Integer.valueOf(1181194));
        orders.setUserName("e1669432a9f447e0");
        orders.setAppid("wxdbcca5299c27edff");
        orders.setWechatUnionId("4312431");
        return this.marketActivityOrdersService.addOrder(orders);
    }

    @PostMapping(value={"confirm"})
    public Orders confirm(@RequestHeader(value="merchantId") Integer merchantId, @RequestBody Orders orders) {
        orders.setUserId(Integer.valueOf(87));
        orders.setUserNo("4e575edb92164033");
        orders.setWechatUnionId("");
        orders.setMerchantId(Integer.valueOf(96));
        orders.setMerchantId(merchantId);
        return this.marketActivityOrdersService.confirm(orders);
    }

    @GetMapping(value={"hahatest"})
    public void hahatest(@RequestParam(value="orderNo") String orderNo) {
        this.assembleService.cancel(orderNo);
    }

    @GetMapping(value={"/initActivity"})
    @ResponseBody
    public Map<String, String> addActivity(@RequestParam(value="marketActivityNo") String marketActivityNo, @RequestParam(value="skuNo") String skuNo, @RequestParam(value="goodsId") Integer goodsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        String result = "";
        try {
            map.put("code", "0");
            result = this.marketActivityOrdersService.addMarketActivityOrders("31716f9e85424d0e", skuNo, marketActivityNo, goodsId);
            if (StringUtils.isEmpty((Object)result)) {
                map.put("code", "-1");
                map.put("msg", "\u672a\u67e5\u8be2\u5230\u7ed3\u679c");
            } else if ("0".equals(result)) {
                map.put("code", "-1");
            } else {
                map.put("data", result);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put("code", "-1");
            map.put("msg", e.getMessage());
        }
        return map;
    }

    @GetMapping(value={"getGoodsDetail"})
    public Map getGoodsDetail(@RequestHeader(value="merchantId") Integer merchantId, @RequestParam(value="goodsNo") String goodsNo, @RequestParam(value="marketActivityNo") String marketActivityNo) {
        return this.assembleService.getGoodsDetail(goodsNo, merchantId, marketActivityNo, "3023c41c760f4342");
    }

    @PostMapping(value={"close"})
    public void close(String appid, Integer id) {
        this.ordersService.cancel(appid, 123, id);
    }

    @GetMapping(value={"getConfig"})
    public Config getConfig(@RequestHeader(value="merchantId") Integer merchantId) {
        Config condition = new Config();
        condition.setMerchantId(merchantId);
        Config select = (Config)this.configMapper.selectOne((Object)condition);
        return select;
    }

    @GetMapping(value={"/queryMyReduce2"})
    @ResponseBody
    public RestResult queryMyReduce2(@RequestParam(value="pageNum") int pageNum, @RequestParam(value="pageSize") int pageSize, @RequestHeader(value="merchantId") Integer merchantId) {
        Date currentTime = new Date();
        MarketActivityOrders mao = new MarketActivityOrders();
        mao.setLaunchUserNo("4e575edb92164033");
        mao.setUserNo("4e575edb92164033");
        log.info("\u767b\u5f55\u7528\u6237\u662fuserNo:[{}]", (Object)"4e575edb92164033");
        HashMap<String, PageInfo> map = new HashMap<String, PageInfo>();
        PageInfo reducePriceDtoPageInfo = null;
        try {
            reducePriceDtoPageInfo = this.marketActivityOrdersService.queryMyReduce(currentTime, mao, merchantId, pageNum, pageSize);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            RestResult.fail((String)e.getMessage());
        }
        if (reducePriceDtoPageInfo == null || CollectionUtils.isEmpty((Collection)reducePriceDtoPageInfo.getList())) {
            return RestResult.fail((String)"\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u8bb0\u5f55");
        }
        map.put("result", reducePriceDtoPageInfo);
        return RestResult.success(map);
    }

    @GetMapping(value={"storeList"})
    public Map<String, Object> getStoreList(@RequestHeader(value="merchantId") String merchantId, @RequestParam(value="lat") String lat, @RequestParam(value="lng") String lng, @RequestParam(value="userNo") String userNo) {
        log.info("\u81ea\u63d0\u83b7\u53d6\u95e8\u5e97\u5217\u8868");
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONArray storeList = null;
        try {
            storeList = this.bizvaneInterface.getStoreList(lat, lng, merchantId, userNo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put("code", -1);
            map.put("msg", e.getMessage());
            return map;
        }
        if (storeList == null) {
            map.put("code", -1);
            map.put("msg", "\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u8bb0\u5f55");
            return map;
        }
        map.put("code", 0);
        map.put("data", storeList.toJSONString());
        return map;
    }

    @PostMapping(value={"/order/refund/{itemId}"})
    public void refundOrder(@RequestHeader(value="merchantId") Integer merchantId, @PathVariable(value="itemId") Integer itemId, RefundOrder refundOrder) {
        refundOrder.setMerchantId(merchantId);
        this.ordersService.refundOrder(itemId, refundOrder);
    }
}

