/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.controller;

import com.alibaba.fastjson.JSONObject;
import com.mzlion.core.lang.Assert;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.entity.WechatMchNew;
import com.wmeimob.fastboot.bizvane.enums.RefundStatus;
import com.wmeimob.fastboot.bizvane.mapper.WechatMchNewMapper;
import com.wmeimob.fastboot.bizvane.service.AssembleService;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.service.RefundOrderService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.starter.wechat.service.WechatService;
import com.wmeimob.wechat.util.XmlUtil;
import java.io.InputStream;
import java.util.Base64;
import java.util.Map;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import me.hao0.wechat.model.base.WechatMch;
import me.hao0.wechat.model.base.WechatMp;
import me.hao0.wepay.core.Wepay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.DigestUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@RestController
@RequestMapping(value={"/notify"})
public class NotifyController {
    private static final Logger log = LoggerFactory.getLogger(NotifyController.class);
    public static final String SUCCESS = "SUCCESS";
    private static final String ALGORITHM = "AES";
    private static final String ALGORITHM_MODE_PADDING = "AES/ECB/PKCS5Padding";
    @Resource
    private OrdersService orderService;
    @Resource
    private WechatService wechatService;
    @Resource
    private RefundOrderService refundOrderService;
    @Resource
    private BizvaneInterface bizvaneInterface;
    @Resource
    private WechatMchNewMapper wechatMchNewMapper;
    @Resource
    private AssembleService assembleService;

    @PostMapping(value={"/wechat/refund"})
    public String refundcallback(HttpServletRequest request) {
        try {
            Map paymentMap = XmlUtil.readStringXmlOut((InputStream)request.getInputStream());
            String return_code = (String)paymentMap.get("return_code");
            String appid = (String)paymentMap.get("appid");
            log.info("refundcallback paymentMap==>" + JSONObject.toJSONString((Object)paymentMap));
            Example example = new Example(WechatMchNew.class);
            example.createCriteria().andEqualTo("appId", (Object)appid);
            WechatMchNew mchNew = (WechatMchNew)this.wechatMchNewMapper.selectOneByExample((Object)example);
            if (mchNew == null) {
                throw new CustomException("appid=" + appid + ",\u672a\u5b8c\u6210\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e");
            }
            if (return_code.equals(SUCCESS)) {
                String req_info = (String)paymentMap.get("req_info");
                String s = NotifyController.decryptData(req_info, mchNew.getMchKey());
                Map stringStringMap = XmlUtil.readStringXmlOut((String)s);
                log.info("refundcallback req_info==>" + JSONObject.toJSONString((Object)stringStringMap));
                String out_refund_no = (String)stringStringMap.get("out_refund_no");
                String refund_status = (String)stringStringMap.get("refund_status");
                if (refund_status.equals(SUCCESS)) {
                    log.info("\u6210\u529f\u8fdb\u884c\u9000\u6b3e\u56de\u8c03");
                    RefundOrder refundOrder = (RefundOrder)this.refundOrderService.findById(out_refund_no);
                    OrderItems orderItems = new OrderItems();
                    orderItems.setId(refundOrder.getItemId());
                    orderItems.setRefundStatus(RefundStatus.SUCCESS);
                    this.orderService.updateRefundItems(orderItems);
                    this.bizvaneInterface.notifyRefundApplied(refundOrder);
                    return "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>";
                }
            }
            return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[\u53c2\u6570\u683c\u5f0f\u6821\u9a8c\u5931\u8d25]]></return_msg></xml>";
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[\u53c2\u6570\u683c\u5f0f\u6821\u9a8c\u5931\u8d25]]></return_msg></xml>";
        }
    }

    public static String decryptData(String base64Data, String mchKey) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHM_MODE_PADDING);
        SecretKeySpec key = new SecretKeySpec(DigestUtils.md5DigestAsHex((byte[])mchKey.getBytes()).toLowerCase().getBytes(), ALGORITHM);
        cipher.init(2, key);
        byte[] bytes = cipher.doFinal(Base64.getDecoder().decode(base64Data));
        return new String(bytes);
    }

    @PostMapping(value={"/wechat/pay"})
    public String paycallback(HttpServletRequest request) {
        try {
            Map paymentMap = XmlUtil.readStringXmlOut((InputStream)request.getInputStream());
            log.info("\u652f\u4ed8\u56de\u8c03=>{}", (Object)JSONObject.toJSONString((Object)paymentMap));
            String result_code = (String)paymentMap.get("result_code");
            if (result_code.equals(SUCCESS)) {
                Example example = new Example(WechatMchNew.class);
                example.createCriteria().andEqualTo("appId", paymentMap.get("appid"));
                WechatMchNew mchNew = (WechatMchNew)this.wechatMchNewMapper.selectOneByExample((Object)example);
                WechatMp wechatMp = new WechatMp();
                wechatMp.setAppid(mchNew.getAppId());
                WechatMch wechatMch = new WechatMch();
                wechatMch.setMchKey(mchNew.getMchKey());
                wechatMch.setMchNo(mchNew.getMchNo());
                wechatMch.setP12(mchNew.getP12());
                Wepay wepay = this.wechatService.getWepay(wechatMp, wechatMch);
                Boolean aBoolean = wepay.notifies().verifySign(paymentMap);
                if (aBoolean.booleanValue()) {
                    String transaction_id = (String)paymentMap.get("transaction_id");
                    String out_trade_no = (String)paymentMap.get("out_trade_no");
                    Assert.notNull((Object)out_trade_no, (String)"out_trade_no null");
                    Orders orders = new Orders();
                    orders.setTransactionId(transaction_id);
                    orders.setOrderNo(out_trade_no);
                    this.orderService.updateForPaySuccess(orders);
                    log.info("\u8ba2\u5355{}\u4ed8\u6b3e\u901a\u77e5\u5904\u7406\u5b8c\u6bd5.", (Object)out_trade_no);
                    return "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>";
                }
            }
            return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[\u53c2\u6570\u683c\u5f0f\u6821\u9a8c\u5931\u8d25]]></return_msg></xml>";
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[\u53c2\u6570\u683c\u5f0f\u6821\u9a8c\u5931\u8d25]]></return_msg></xml>";
        }
    }

    @PostMapping(value={"/wechat/activityRefund"})
    public String activityRefundcallback(HttpServletRequest request) {
        try {
            Map paymentMap = XmlUtil.readStringXmlOut((InputStream)request.getInputStream());
            String return_code = (String)paymentMap.get("return_code");
            String appid = (String)paymentMap.get("appid");
            log.info("refundcallback paymentMap==>" + JSONObject.toJSONString((Object)paymentMap));
            Example example = new Example(WechatMchNew.class);
            example.createCriteria().andEqualTo("appId", (Object)appid);
            WechatMchNew mchNew = (WechatMchNew)this.wechatMchNewMapper.selectOneByExample((Object)example);
            if (mchNew == null) {
                throw new CustomException("appid=" + appid + ",\u672a\u5b8c\u6210\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e");
            }
            if (return_code.equals(SUCCESS)) {
                String req_info = (String)paymentMap.get("req_info");
                String s = NotifyController.decryptData(req_info, mchNew.getMchKey());
                Map stringStringMap = XmlUtil.readStringXmlOut((String)s);
                log.info("refundcallback req_info==>" + JSONObject.toJSONString((Object)stringStringMap));
                String out_refund_no = (String)stringStringMap.get("out_refund_no");
                String out_trade_no = (String)stringStringMap.get("out_trade_no");
                String refund_status = (String)stringStringMap.get("refund_status");
                if (refund_status.equals(SUCCESS)) {
                    log.info("\u6210\u529f\u8fdb\u884c\u9000\u6b3e\u56de\u8c03");
                    this.assembleService.updateActivityRefund(new Integer(out_refund_no), out_trade_no);
                    return "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>";
                }
            }
            return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[\u53c2\u6570\u683c\u5f0f\u6821\u9a8c\u5931\u8d25]]></return_msg></xml>";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[\u53c2\u6570\u683c\u5f0f\u6821\u9a8c\u5931\u8d25]]></return_msg></xml>";
        }
    }
}

