/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.autoconfigure.wechat.WechatProperties;
import com.wmeimob.fastboot.bizvane.builder.OrdersBuilder;
import com.wmeimob.fastboot.bizvane.dto.AddressInfoDTO;
import com.wmeimob.fastboot.bizvane.dto.CouponDTO;
import com.wmeimob.fastboot.bizvane.dto.FreightCalcDTO;
import com.wmeimob.fastboot.bizvane.dto.FreightCalcResponse;
import com.wmeimob.fastboot.bizvane.dto.GoodsStockChangeResponseDTO;
import com.wmeimob.fastboot.bizvane.dto.OrdersCountInfo;
import com.wmeimob.fastboot.bizvane.dto.OrdersQueryInfo;
import com.wmeimob.fastboot.bizvane.dto.UserDiscountDTO;
import com.wmeimob.fastboot.bizvane.entity.Activity;
import com.wmeimob.fastboot.bizvane.entity.ActivityRule;
import com.wmeimob.fastboot.bizvane.entity.ActivityRuleCombination;
import com.wmeimob.fastboot.bizvane.entity.Config;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.MarketActivity;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityGoods;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityOrders;
import com.wmeimob.fastboot.bizvane.entity.OrderGift;
import com.wmeimob.fastboot.bizvane.entity.OrderItems;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.OrdersFullGift;
import com.wmeimob.fastboot.bizvane.entity.RefundOrder;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.entity.UserCommissionAccounts;
import com.wmeimob.fastboot.bizvane.entity.WechatMchNew;
import com.wmeimob.fastboot.bizvane.enums.ActivitySanEnum;
import com.wmeimob.fastboot.bizvane.enums.LogisticsStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.OperationTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.OrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.PayStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.RefundStatus;
import com.wmeimob.fastboot.bizvane.event.OrderEvent;
import com.wmeimob.fastboot.bizvane.mapper.ActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityRuleCombinationMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityRuleGiftMapper;
import com.wmeimob.fastboot.bizvane.mapper.ActivityRuleMapper;
import com.wmeimob.fastboot.bizvane.mapper.ConfigMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityOrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrderItemsMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersFullGiftMapper;
import com.wmeimob.fastboot.bizvane.mapper.OrdersMapper;
import com.wmeimob.fastboot.bizvane.mapper.RefundOrderMapper;
import com.wmeimob.fastboot.bizvane.mapper.ShopCartMapper;
import com.wmeimob.fastboot.bizvane.mapper.WechatMchNewMapper;
import com.wmeimob.fastboot.bizvane.service.ActivityService;
import com.wmeimob.fastboot.bizvane.service.AssembleService;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.ConfigService;
import com.wmeimob.fastboot.bizvane.service.CouponService;
import com.wmeimob.fastboot.bizvane.service.ExpressService;
import com.wmeimob.fastboot.bizvane.service.GoodsGiftRelationService;
import com.wmeimob.fastboot.bizvane.service.GoodsService;
import com.wmeimob.fastboot.bizvane.service.GoodsSkuDetailService;
import com.wmeimob.fastboot.bizvane.service.OrdersGiftService;
import com.wmeimob.fastboot.bizvane.service.OrdersService;
import com.wmeimob.fastboot.bizvane.service.UserCommissionService;
import com.wmeimob.fastboot.bizvane.service.UserService;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.rest.RestResult;
import com.wmeimob.fastboot.starter.wechat.dto.WechatJsPayDTO;
import com.wmeimob.fastboot.starter.wechat.service.WechatService;
import com.wmeimob.fastboot.starter.wechat.service.WepayService;
import com.wmeimob.fastboot.util.DateUtil;
import com.wmeimob.fastboot.util.InputValidator;
import com.wmeimob.fastboot.util.RandomCodeUtil;
import com.wmeimob.fastboot.util.web.IpAddressHelper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import me.hao0.wechat.model.base.WechatMch;
import me.hao0.wechat.model.base.WechatMp;
import me.hao0.wepay.core.Wepay;
import me.hao0.wepay.model.pay.JsPayRequest;
import me.hao0.wepay.model.pay.JsPayResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import tk.mybatis.mapper.entity.Example;

@Service
@Primary
public class OrdersServiceImpl
implements OrdersService {
    private static final Logger log = LoggerFactory.getLogger(OrdersServiceImpl.class);
    @Resource
    private OrdersMapper ordersMapper;
    @Resource
    private GoodsSkuDetailService goodsSkuDetailService;
    @Resource
    private ActivityService activityService;
    @Resource
    private OrderItemsMapper orderItemsMapper;
    @Resource
    private RefundOrderMapper refundOrderMapper;
    @Resource
    private GoodsService goodsService;
    @Resource
    private UserService userService;
    @Resource
    private CouponService couponService;
    @Resource
    private WepayService wepayService;
    @Resource
    private ExpressService expressService;
    @Resource(name="commonConfigService")
    private ConfigService configService;
    @Resource
    private OrdersGiftService ordersGiftService;
    @Resource
    private GoodsGiftRelationService goodsGiftRelationService;
    @Resource
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Resource
    private WechatProperties wechatProperties;
    @Resource(name="commonOrdersServiceImpl")
    private OrdersService commonOrdersServiceImpl;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private BizvaneInterface bizvaneInterface;
    @Resource(name="commonConfigService")
    private ConfigService CommonConfigServiceImpl;
    @Resource
    private UserCommissionService userCommissionService;
    @Resource
    private ActivityGoodsMapper activityGoodsMapper;
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private ActivityMapper activityMapper;
    @Resource
    private ActivityRuleMapper activityRuleMapper;
    @Resource
    private ActivityRuleCombinationMapper activityRuleCombinationMapper;
    @Resource
    private ActivityRuleGiftMapper activityRuleGiftMapper;
    @Resource
    private GoodsMapper goodsMapper;
    @Resource
    private ConfigMapper configMapper;
    @Resource
    private ShopCartMapper shopCartMapper;
    @Resource
    private WechatMchNewMapper wechatMchNewMapper;
    @Resource
    private WechatService wechatService;
    @Resource
    private OrdersFullGiftMapper ordersFullGiftMapper;
    @Resource
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Resource
    private MarketActivityOrdersMapper marketActivityOrdersMapper;
    @Resource
    private MarketActivityMapper marketActivityMapper;
    @Autowired
    private AssembleService assembleService;
    @Autowired
    private MarketActivityGoodsMapper marketActivityGoodsMapper;
    private static final String REDIS_FREEZE_STOCK_KEY = "wx_reducePrice_freeze_stock_";
    @Autowired
    private ApplicationContext applicationContext;
    private static final String USER_ADD_ORDER_KEY = "user:%s:add_order";
    private static final String ORDER_CLOSE_KEY = "orders:%s:close_handler";
    private static final String ORDERS_PAY_SUCCESS_KEY = "orders:%s:pay_notify_processed";

    public Orders payConfirm(Orders payOrders) {
        BigDecimal sanPayAmount;
        BigDecimal payAmount;
        payOrders.setPriceSystem(Integer.valueOf(0));
        this.checkUserInfo(payOrders);
        this.checkGoodsItem(payOrders.getItems());
        payOrders.getItems().forEach(od -> {
            od.setMerchantId(payOrders.getMerchantId());
            od.setSanSaleQuantity(od.getSaleQuantity());
            od.setSanSing(Boolean.FALSE);
            od.setPriceSystem(payOrders.getPriceSystem());
        });
        List customGoods = this.convertOrderItemsToGoods(payOrders.getItems());
        List customSkuInfo = this.convertOrderItemsToSkuInfo(payOrders.getItems());
        List dbGoods = this.checkAndGetGoodsInfo(customGoods);
        List dbSkuInfo = this.checkAndGetSkuInfo(customSkuInfo);
        dbSkuInfo.forEach(sku -> {
            Goods singleDbGoods = this.getGoodsById(sku.getGoodsId(), dbGoods);
            log.info("singleDbGoods:{}", (Object)JSONObject.toJSONString((Object)singleDbGoods));
            sku.setGoodsName(singleDbGoods.getGoodsName());
            sku.setGoodsNo(singleDbGoods.getGoodsNo());
            Goods singleCustomGoods = this.getGoodsById(sku.getGoodsId(), customGoods);
            log.info("singleCustomGoods:{}", (Object)JSONObject.toJSONString((Object)singleCustomGoods));
            sku.setCommission(singleDbGoods.getCommissionRate().multiply(new BigDecimal("0.01")).multiply(sku.getSalesPrice()).multiply(new BigDecimal(singleCustomGoods.getCount())));
            sku.setShippingMode(singleDbGoods.getShippingMode());
            sku.setPriceSystem(singleDbGoods.getPriceSystem());
        });
        Orders combinationOrders = OrdersBuilder.getBuilder((Orders)payOrders).fromSku(dbSkuInfo, null, null, null).getOrders();
        if (this.isIntergralPriceSystem(dbGoods)) {
            GoodsSkuDetail goodsSkuDetail = (GoodsSkuDetail)dbSkuInfo.get(0);
            log.info("\u8fdb\u5165\u7279\u6b8a\u4ef7\u683c\u4f53\u7cfb\u5165\u53c2:[{}]", JSONObject.toJSON((Object)goodsSkuDetail));
            return this.integralPriceHandler(combinationOrders, goodsSkuDetail);
        }
        log.info("\u8fdb\u5165\u666e\u901a\u4ef7\u683c\u4f53\u7cfb");
        this.getCombinationList(payOrders.getMerchantId(), combinationOrders);
        List discountInfo = this.activityService.queryDiscountByShopCartGoods(payOrders.getMerchantId(), this.convertOrderItemsToGoods(payOrders.getItems()));
        log.info("\u8ba1\u7b97\u51fa\u7684\u6d3b\u52a8\u6298\u6263\u4e3a:[{}]", (Object)JSONObject.toJSONString((Object)discountInfo));
        User user = new User();
        log.info("wechat union id => {}", (Object)payOrders.getWechatUnionId());
        user.setUnionid(payOrders.getWechatUnionId());
        user.setUserNo(payOrders.getUserNo());
        user.setMerchantId(payOrders.getMerchantId());
        UserDiscountDTO userDiscountDTO = this.userService.getUserDiscountInfo(user);
        List ruleList = this.getRulesForMan(payOrders.getMerchantId());
        Orders newOrder = OrdersBuilder.getBuilder((Orders)combinationOrders).fromDiscount(discountInfo, userDiscountDTO, this.redisTemplate).getOrders();
        log.info("pay confirm orders => {}", (Object)JSONObject.toJSONString((Object)newOrder));
        UserCommissionAccounts condition = new UserCommissionAccounts();
        condition.setUserNo(payOrders.getUserNo());
        UserCommissionAccounts queryAccount = (UserCommissionAccounts)this.userCommissionService.findOneByCondition((Serializable)condition);
        if (queryAccount.getPid() == null || queryAccount.getPid().equals(0)) {
            newOrder.setCommission(BigDecimal.ZERO);
            newOrder.getItems().forEach(i -> i.setCommission(BigDecimal.ZERO));
        }
        if ((payAmount = newOrder.getPayAmount()).compareTo(sanPayAmount = newOrder.getSanPayAmount()) == 1) {
            block0: for (Object rule : ruleList) {
                if (payAmount.compareTo(new BigDecimal(rule.getAmount())) <= -1) continue;
                int i2 = newOrder.getItems().size();
                int ii = 0;
                int iii = 0;
                for (OrderItems items2 : newOrder.getItems()) {
                    BigDecimal limitDis;
                    if (items2.getSanSaleQuantity() == 0) continue;
                    BigDecimal goodsDiscountForMarket = items2.getMarketPrice().compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : items2.getSalePrice().divide(items2.getMarketPrice(), 2, 6);
                    if (goodsDiscountForMarket.compareTo(limitDis = rule.getLimitDiscount().divide(BigDecimal.TEN, 2, 4)) > -1) {
                        BigDecimal itemUser;
                        ++iii;
                        if (!rule.getMemberDiscount().equals(Boolean.FALSE) || (itemUser = items2.getItemsUserDeduction()).compareTo(BigDecimal.ZERO) <= 0) continue;
                        newOrder.setUserDeduction(newOrder.getUserDeduction().subtract(itemUser));
                        newOrder.setPayAmount(newOrder.getPayAmount().add(itemUser));
                        continue;
                    }
                    if (i2 <= 1) continue block0;
                    ++ii;
                }
                if (ii == i2 || iii == 0) continue;
                newOrder.setPayAmount(newOrder.getPayAmount().subtract(new BigDecimal(rule.getEnjoyDiscount())));
                newOrder.setActiveDeduction(newOrder.getActiveDeduction().add(new BigDecimal(rule.getEnjoyDiscount())));
                break;
            }
        }
        List goodsByGoodsIdList = this.goodsGiftRelationService.findGoodsByGoodsIdList(newOrder.getItems().stream().map(OrderItems::getGoodsId).collect(Collectors.toList()));
        for (OrderItems items3 : newOrder.getItems()) {
            Goods gift;
            ArrayList<OrderGift> gifts = items3.getGifts();
            if (gifts == null) {
                gifts = new ArrayList<OrderGift>();
            }
            if ((gift = this.getGiftGoodsByGoodsId(goodsByGoodsIdList, items3.getGoodsSkuNo())) != null) {
                gift.setCount(Integer.valueOf(gift.getCount() * items3.getSaleQuantity()));
                OrderGift orderGift = new OrderGift();
                orderGift.setGiftCount(gift.getCount());
                orderGift.setGoodsName(gift.getGoodsName());
                orderGift.setGoodsImg(gift.getCoverImg());
                orderGift.setGoodsId(gift.getId());
                gifts.add(orderGift);
            }
            items3.setGifts(gifts);
        }
        Example example = new Example(Config.class);
        example.createCriteria().andEqualTo("merchantId", (Object)newOrder.getMerchantId());
        Config config = (Config)this.configMapper.selectOneByExample((Object)example);
        if (config == null) {
            newOrder.setIntegralDeduction(Boolean.FALSE);
            newOrder.setBalanceDeduction(Boolean.FALSE);
        } else {
            newOrder.setIntegralDeduction(config.getIntegralDeduction());
            newOrder.setBalanceDeduction(config.getBalanceDeduction());
        }
        if (config.getPriceDisplay().equals(1)) {
            newOrder.getItems().forEach(items -> items.setVipPrice(items.getSalePrice().multiply(userDiscountDTO.getDiscount()).setScale(2, 4)));
        }
        log.info("\u6700\u7ec8\u8fd4\u56de\u7684\u8ba2\u5355\u8be6\u60c5\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)newOrder));
        return newOrder;
    }

    private Orders integralPriceHandler(Orders payOrders, GoodsSkuDetail goodsSkuDetail) {
        Goods goods = this.goodsMapper.selectById(goodsSkuDetail.getGoodsId());
        if (goods.getIsDel().booleanValue()) {
            throw new CustomException("\u5546\u54c1\u5df2\u7ecf\u5220\u9664");
        }
        GoodsSkuDetail gsd = new GoodsSkuDetail();
        gsd.setGoodsId(goods.getId());
        gsd.setSkuNo(goodsSkuDetail.getSkuNo());
        gsd.setIsDel(Boolean.valueOf(false));
        gsd = (GoodsSkuDetail)this.goodsSkuDetailMapper.selectOne((Object)goodsSkuDetail);
        Orders newOrder = OrdersBuilder.getBuilder((Orders)payOrders).build();
        newOrder.setPriceSystem(goods.getPriceSystem());
        BigDecimal sanIntegralPrice = gsd.getSalesPrice().multiply(BigDecimal.valueOf(Double.parseDouble(((OrderItems)payOrders.getItems().get(0)).getSaleQuantity() + "")));
        Long sanIntegralPoints = gsd.getIntegralPoints() * (long)((OrderItems)payOrders.getItems().get(0)).getSaleQuantity().intValue();
        newOrder.setPayAmount(sanIntegralPrice.add(newOrder.getShippingFee() == null ? BigDecimal.ZERO : newOrder.getShippingFee()));
        newOrder.setWxAmount(newOrder.getPayAmount());
        newOrder.setPoints(sanIntegralPoints);
        newOrder.setOrderAmount(sanIntegralPrice);
        newOrder.getItems().forEach(orderItems -> {
            orderItems.setWepayAmount(sanIntegralPrice);
            orderItems.setItemsPayAmount(sanIntegralPrice);
            orderItems.setItemsAmount(sanIntegralPrice);
            orderItems.setPoints(sanIntegralPoints);
            orderItems.setPriceSystem(goods.getPriceSystem());
            if (newOrder.getPriceSystem().equals(2)) {
                orderItems.setWepayAmount(BigDecimal.ZERO);
                orderItems.setItemsPayAmount(BigDecimal.ZERO);
                orderItems.setItemsAmount(BigDecimal.ZERO);
            }
        });
        UserCommissionAccounts condition = new UserCommissionAccounts();
        condition.setUserNo(payOrders.getUserNo());
        UserCommissionAccounts queryAccount = (UserCommissionAccounts)this.userCommissionService.findOneByCondition((Serializable)condition);
        if (queryAccount.getPid() == null || queryAccount.getPid().equals(0)) {
            newOrder.setCommission(BigDecimal.ZERO);
            newOrder.getItems().forEach(i -> i.setCommission(BigDecimal.ZERO));
        }
        if (newOrder.getPriceSystem().equals(2)) {
            newOrder.setOrderAmount(BigDecimal.ZERO);
            newOrder.setWxAmount(BigDecimal.ZERO);
            newOrder.setPayAmount(BigDecimal.ZERO);
            newOrder.setShippingFee(BigDecimal.ZERO);
            newOrder.setShippingDeduction(BigDecimal.ZERO);
        }
        List goodsByGoodsIdList = this.goodsGiftRelationService.findGoodsByGoodsIdList(newOrder.getItems().stream().map(OrderItems::getGoodsId).collect(Collectors.toList()));
        for (OrderItems items : newOrder.getItems()) {
            Goods gift;
            ArrayList<OrderGift> gifts = items.getGifts();
            if (gifts == null) {
                gifts = new ArrayList<OrderGift>();
            }
            if ((gift = this.getGiftGoodsByGoodsId(goodsByGoodsIdList, items.getGoodsSkuNo())) != null) {
                gift.setCount(Integer.valueOf(gift.getCount() * items.getSaleQuantity()));
                OrderGift orderGift = new OrderGift();
                orderGift.setGiftCount(gift.getCount());
                orderGift.setGoodsName(gift.getGoodsName());
                orderGift.setGoodsImg(gift.getCoverImg());
                orderGift.setGoodsId(gift.getId());
                gifts.add(orderGift);
            }
            items.setGifts(gifts);
        }
        log.info("\u7279\u6b8a\u4ef7\u683c\u4f53\u7cfb\u8fd4\u53c2:[{}]", JSONObject.toJSON((Object)newOrder));
        return newOrder;
    }

    private boolean isIntergralPriceSystem(List<Goods> dbGoods) {
        if (!CollectionUtils.isEmpty(dbGoods)) {
            if (dbGoods.size() > 1) {
                return false;
            }
            return !dbGoods.get(0).getPriceSystem().equals(0);
        }
        return false;
    }

    public Integer getUserIntegral(String userNo) {
        return this.bizvaneInterface.getUserIntegral(userNo);
    }

    public BigDecimal getUserBalance(String memberCode) {
        return this.bizvaneInterface.getUserBalance(memberCode);
    }

    private void getCombinationList(Integer merchantId, Orders combinationOrders) {
        log.info("\u5224\u65ad\u7ec4\u5408\u6d3b\u52a8\u7684\u5165\u53c2===>{}", (Object)JSONObject.toJSONString((Object)combinationOrders));
        List itemsList = combinationOrders.getItems();
        HashMap<String, Integer> orderMap = new HashMap<String, Integer>();
        for (OrderItems orderItems : itemsList) {
            Integer num = orderItems.getSanSaleQuantity();
            if (orderMap.get(orderItems.getGoodsId().toString()) != null) {
                num = num + (Integer)orderMap.get(orderItems.getGoodsId().toString());
            }
            orderMap.put(orderItems.getGoodsId().toString(), num);
        }
        int totalAmout = 0;
        Map promotion = this.getActivityCombinationGoods(merchantId);
        Set combinedKey = promotion.keySet();
        block1: for (String promotionKey : combinedKey) {
            String[] combinedArray = promotionKey.split("-");
            boolean hasCombinedCoodes = true;
            while (hasCombinedCoodes) {
                int i;
                boolean containAllCombinedGoods = true;
                for (i = 0; i < combinedArray.length; ++i) {
                    if (orderMap.get(combinedArray[i]) == null) continue block1;
                    if ((Integer)orderMap.get(combinedArray[i]) != 0) continue;
                    hasCombinedCoodes = false;
                    containAllCombinedGoods = false;
                    break;
                }
                if (!containAllCombinedGoods) continue block1;
                for (i = 0; i < combinedArray.length; ++i) {
                    if (orderMap.get(combinedArray[i]) == null) continue;
                    orderMap.put(combinedArray[i], (Integer)orderMap.get(combinedArray[i]) - 1);
                }
                totalAmout += ((Integer)promotion.get(promotionKey)).intValue();
            }
        }
        log.info("\u8ba1\u7b97\u7684\u603b\u4ef7\u662f\u8fd9\u6837\u7684\uff01\uff01\uff01{}", (Object)totalAmout);
        BigDecimal payAmount = new BigDecimal(totalAmout);
        combinationOrders.setPayAmount(payAmount);
        combinationOrders.setSanPayAmount(payAmount);
        if (totalAmout != 0) {
            for (OrderItems items : itemsList) {
                Integer num = (Integer)orderMap.get(String.valueOf(items.getGoodsId()));
                orderMap.put(items.getGoodsId().toString(), 0);
                items.setSanSaleQuantity(num);
                BigDecimal itemsAmount = items.getSalePrice().multiply(new BigDecimal(num));
                items.setItemsAmount(itemsAmount);
                items.setItemsPayAmount(itemsAmount);
            }
        }
        log.info("\u7ec4\u5408\u6d3b\u52a8\u8ba1\u7b97\u540e\u7684\u8ba2\u5355{}", (Object)JSONObject.toJSONString((Object)combinationOrders));
    }

    private Map getActivityCombinationGoods(Integer merchantId) {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        Example example = new Example(Activity.class);
        example.orderBy("gmtCreate").desc();
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("status", (Object)Boolean.TRUE).andEqualTo("type", (Object)ActivitySanEnum.COMBINATION.getCode()).andCondition("DATE_FORMAT(NOW(),'%Y-%m-%d %H:%i:%S') BETWEEN DATE_FORMAT(begin_date,'%Y-%m-%d %H:%i:%S') AND DATE_FORMAT(end_date,'%Y-%m-%d %H:%i:%S')");
        List activities = this.activityMapper.selectByExample((Object)example);
        for (Activity activity : activities) {
            Example ruleExample = new Example(ActivityRule.class);
            ruleExample.orderBy("combinationNum").desc();
            ruleExample.orderBy("amount").asc();
            ruleExample.orderBy("sort").asc();
            ruleExample.createCriteria().andEqualTo("activityId", (Object)activity.getId());
            List rules = this.activityRuleMapper.selectByExample((Object)ruleExample);
            for (ActivityRule rule : rules) {
                Example comExample = new Example(ActivityRuleCombination.class);
                comExample.createCriteria().andEqualTo("ruleId", (Object)rule.getId());
                List combinationList = this.activityRuleCombinationMapper.selectByExample((Object)comExample);
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < combinationList.size(); ++i) {
                    if (i == combinationList.size() - 1) {
                        sb.append(((ActivityRuleCombination)combinationList.get(i)).getGoodsId());
                        continue;
                    }
                    sb.append(((ActivityRuleCombination)combinationList.get(i)).getGoodsId()).append("-");
                }
                map.put(sb.toString(), rule.getAmount());
                rule.setPromotion(map);
            }
        }
        return map;
    }

    private List<ActivityRule> getRulesForMan(Integer merchantId) {
        ArrayList<ActivityRule> result = new ArrayList<ActivityRule>();
        Example example = new Example(Activity.class);
        example.orderBy("gmtCreate").desc();
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("status", (Object)Boolean.TRUE).andEqualTo("type", (Object)ActivitySanEnum.FULL_REDUCTION.getCode()).andCondition("DATE_FORMAT(NOW(),'%Y-%m-%d %H:%i:%S') BETWEEN DATE_FORMAT(begin_date,'%Y-%m-%d %H:%i:%S') AND DATE_FORMAT(end_date,'%Y-%m-%d %H:%i:%S')");
        List activities = this.activityMapper.selectByExample((Object)example);
        for (Activity activity : activities) {
            Example ruleExample = new Example(ActivityRule.class);
            ruleExample.setOrderByClause("enjoy_discount DESC,amount DESC");
            ruleExample.createCriteria().andEqualTo("activityId", (Object)activity.getId());
            List rules = this.activityRuleMapper.selectByExample((Object)ruleExample);
            result.addAll(rules);
        }
        return result;
    }

    private Goods getGiftGoodsByGoodsId(List<Goods> giftGoods, String goodSkuNo) {
        for (Goods giftGood : giftGoods) {
            if (!giftGood.getRelationSkuNo().equals(goodSkuNo)) continue;
            return giftGood;
        }
        return null;
    }

    private void checkGoodsItem(List<OrderItems> items) {
        if (items == null || items.isEmpty()) {
            throw new CustomException("\u672a\u9009\u62e9\u5546\u54c1");
        }
        for (OrderItems item : items) {
            if (item.getSaleQuantity() > 0) continue;
            throw new CustomException("\u5546\u54c1" + item.getGoodsName() + "[" + item.getGoodsSkuName() + "]\u6570\u91cf\u6709\u8bef");
        }
    }

    public int delete(Integer id) {
        Orders orders = new Orders();
        orders.setId(id);
        orders.setIsVisable(Boolean.valueOf(false));
        if (this.ordersMapper.updateByPrimaryKeySelective((Object)orders) == 0) {
            throw new CustomException("\u5220\u9664\u5931\u8d25");
        }
        return 1;
    }

    @Transactional(rollbackFor={Exception.class})
    public Orders add(Orders orders) {
        RestResult balanceResult;
        RestResult integralResult;
        List stockResponse;
        log.info("\u8ba2\u5355\u5165\u5e93\u7684\u53c2\u6570======> {}", (Object)JSONObject.toJSONString((Object)orders));
        String key = String.format(USER_ADD_ORDER_KEY, orders.getUserId());
        if (!this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)"").booleanValue()) {
            log.info("\u7528\u6237ID {} \u4e0b\u5355\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41", (Object)orders.getUserId());
            throw new CustomException("\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41");
        }
        this.stringRedisTemplate.expire((Object)key, 10L, TimeUnit.SECONDS);
        this.checkOrdersShippingInfo(orders);
        Orders newOrder = this.payConfirm(orders);
        if (orders.getPriceSystem() == null) {
            throw new CustomException("\u8ba2\u5355\u5f02\u5e38\u4f53\u7cfb\u4e3anull,\u8ba2\u5355\u7f16\u53f7:" + orders.getOrderNo());
        }
        if (!orders.getPriceSystem().equals(0)) {
            return ((OrdersServiceImpl)AopContext.currentProxy()).addIntegralPriceSystemOrders(newOrder, orders);
        }
        CouponDTO couponDTO = null;
        if (!StringUtils.isEmpty((Object)orders.getCouponNo())) {
            couponDTO = (CouponDTO)this.couponService.findById(Integer.valueOf(orders.getCouponNo()));
        }
        this.couponService.packCouponIsValid(couponDTO, orders);
        if (couponDTO != null && !couponDTO.getCanUse().booleanValue()) {
            throw new CustomException(couponDTO.getTip());
        }
        newOrder = OrdersBuilder.getBuilder((Orders)newOrder).fromCoupons(couponDTO).build();
        BigDecimal payableAmount = newOrder.getPayAmount();
        newOrder.setPayAmount(newOrder.getWxAmount());
        if (newOrder.getWxAmount().compareTo(BigDecimal.ZERO) == 0) {
            newOrder.setPayStatus(PayStatusEnum.SUCCESS);
            newOrder.setPayAt(new Date());
        }
        if (couponDTO != null) {
            this.couponService.lock(couponDTO.getCode(), newOrder.getUserNo());
        }
        if (!(stockResponse = this.goodsSkuDetailService.inventoryReduction(this.convertOrderItemsToSkuInfo(newOrder.getItems()))).isEmpty()) {
            StringBuffer sb = new StringBuffer("\u5546\u54c1");
            stockResponse.forEach(s -> sb.append(s.getGoodsName()).append("[").append(s.getSkuNo()).append("] "));
            sb.append("\u5e93\u5b58\u4e0d\u8db3");
            throw new CustomException(sb.toString());
        }
        if (newOrder.getDeductionIntegral() == null) {
            newOrder.setDeductionIntegral(Integer.valueOf(0));
        }
        if (newOrder.getIntegralAmount() == null) {
            newOrder.setIntegralAmount(BigDecimal.ZERO);
        }
        if (newOrder.getDeductionBalance() == null) {
            newOrder.setDeductionBalance(BigDecimal.ZERO);
        }
        log.info("insert order info...{}", (Object)JSONObject.toJSONString((Object)newOrder));
        this.ordersMapper.insertSelective((Object)newOrder);
        if (BigDecimal.ZERO.compareTo(newOrder.getWxAmount()) == 0) {
            if (!StringUtils.isEmpty((Object)newOrder.getCouponNo())) {
                this.couponService.verify(CouponDTO.builder().code(newOrder.getCouponNo()).userNo(newOrder.getUserNo()).deductionAmount(newOrder.getCouponDeduction()).verifyAmount(newOrder.getPayAmount()).merchantId(newOrder.getMerchantId()).build());
            }
            this.incrementSales(newOrder.getItems());
        }
        BigDecimal proportion = this.getIntegralProportion(newOrder.getUserNo()) == null ? BigDecimal.ZERO : this.getIntegralProportion(newOrder.getUserNo());
        BigDecimal integral = new BigDecimal(newOrder.getDeductionIntegral() == null ? 0 : newOrder.getDeductionIntegral());
        BigDecimal deductionBalance = newOrder.getDeductionBalance() == null ? BigDecimal.ZERO : newOrder.getDeductionBalance();
        BigDecimal shippingAmount = newOrder.getShippingFee().subtract(newOrder.getShippingDeduction());
        BigDecimal wxAmount = newOrder.getWxAmount().subtract(shippingAmount);
        Orders finalNewOrder = newOrder;
        Integer totalIntegral = 0;
        BigDecimal totalIntegralAmount = new BigDecimal(0);
        BigDecimal totalBalance = new BigDecimal(0);
        BigDecimal totalWepay = new BigDecimal(0);
        for (int i = 0; i < newOrder.getItems().size(); ++i) {
            ((OrderItems)newOrder.getItems().get(i)).setOrderId(finalNewOrder.getId());
            ((OrderItems)newOrder.getItems().get(i)).setOrderNo(finalNewOrder.getOrderNo());
            Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey((Object)((OrderItems)newOrder.getItems().get(i)).getGoodsId());
            ((OrderItems)newOrder.getItems().get(i)).setGoodsNo(goods != null ? goods.getGoodsNo() : null);
            if (i != newOrder.getItems().size() - 1) {
                BigDecimal scale = ((OrderItems)newOrder.getItems().get(i)).getItemsPayAmount().divide(payableAmount, 2, 4);
                BigDecimal svgIntegral = integral.multiply(scale).setScale(2, 4);
                ((OrderItems)newOrder.getItems().get(i)).setDeductionIntegral(Integer.valueOf(svgIntegral.intValue()));
                totalIntegral = totalIntegral + svgIntegral.intValue();
                BigDecimal svgIntegralAmount = svgIntegral.multiply(proportion).setScale(2, 4);
                ((OrderItems)newOrder.getItems().get(i)).setIntegralAmount(svgIntegralAmount);
                totalIntegralAmount = totalIntegralAmount.add(svgIntegralAmount);
                BigDecimal svgUserBalance = deductionBalance.multiply(scale).setScale(2, 4);
                ((OrderItems)newOrder.getItems().get(i)).setDeductionBalance(svgUserBalance);
                totalBalance = totalBalance.add(svgUserBalance);
                BigDecimal svgWx = wxAmount.multiply(scale).setScale(2, 4);
                ((OrderItems)newOrder.getItems().get(i)).setWepayAmount(svgWx);
                totalWepay = totalWepay.add(svgWx);
                continue;
            }
            if (BigDecimal.ZERO.compareTo(((OrderItems)newOrder.getItems().get(i)).getItemsPayAmount()) != -1) continue;
            BigDecimal lastSvgIntegral = integral.subtract(new BigDecimal(totalIntegral));
            ((OrderItems)newOrder.getItems().get(i)).setDeductionIntegral(Integer.valueOf(lastSvgIntegral.intValue()));
            BigDecimal lastSvgIntegralAmount = lastSvgIntegral.multiply(proportion).setScale(2, 4);
            ((OrderItems)newOrder.getItems().get(i)).setIntegralAmount(lastSvgIntegralAmount);
            BigDecimal lastSvgUserBalance = deductionBalance.subtract(totalBalance);
            ((OrderItems)newOrder.getItems().get(i)).setDeductionBalance(lastSvgUserBalance);
            BigDecimal lastWx = wxAmount.subtract(totalWepay);
            ((OrderItems)newOrder.getItems().get(i)).setWepayAmount(lastWx);
        }
        this.orderItemsMapper.insertList(newOrder.getItems());
        log.info("insert order successfully ! ");
        List noneStockGiftsInfo = this.saveGiftGoods(newOrder);
        if (newOrder.getFullGifts() != null && newOrder.getFullGifts().size() > 0) {
            for (Goods goods : newOrder.getFullGifts()) {
                Example example = new Example(GoodsSkuDetail.class);
                example.createCriteria().andEqualTo("goodsId", (Object)goods.getId());
                GoodsSkuDetail detail = (GoodsSkuDetail)this.goodsSkuDetailMapper.selectOneByExample((Object)example);
                if (detail == null) continue;
                Integer oldStock = detail.getStock();
                Integer count = goods.getCount();
                if (oldStock < count) {
                    GoodsStockChangeResponseDTO responseDTO = new GoodsStockChangeResponseDTO();
                    responseDTO.setGoodsId(goods.getId());
                    responseDTO.setGoodsName(goods.getGoodsName());
                    responseDTO.setSkuNo(detail.getSkuNo());
                    responseDTO.setFailReason("\u5e93\u5b58\u4e0d\u8db3");
                    responseDTO.setCount(oldStock);
                    noneStockGiftsInfo.add(responseDTO);
                    continue;
                }
                OrdersFullGift fullGift = new OrdersFullGift();
                fullGift.setOrderId(newOrder.getId());
                fullGift.setGoodId(goods.getId());
                fullGift.setGoodNum(goods.getCount());
                this.ordersFullGiftMapper.insertSelective((Object)fullGift);
                int stock = 0;
                if (oldStock >= count) {
                    stock = oldStock - count;
                }
                detail.setStock(Integer.valueOf(stock));
                this.goodsSkuDetailMapper.updateByPrimaryKeySelective((Object)detail);
            }
        }
        newOrder.setNoneStockGiftList(noneStockGiftsInfo);
        if (newOrder.getDeductionIntegral() != null && newOrder.getDeductionIntegral() > 0 && 0 != (integralResult = this.wscConsumeIntegralChange(newOrder.getUserNo(), newOrder.getDeductionIntegral(), newOrder.getOrderNo())).getCode()) {
            throw new CustomException("\u6263\u51cf\u79ef\u5206\u5931\u8d25");
        }
        if (newOrder.getDeductionBalance() != null && BigDecimal.ZERO.compareTo(newOrder.getDeductionBalance()) == -1 && 0 != (balanceResult = this.wscConsumeBalance(newOrder.getUserNo(), newOrder.getDeductionBalance(), newOrder.getOrderNo())).getCode()) {
            throw new CustomException("\u6263\u51cf\u4f59\u989d\u5931\u8d25");
        }
        Config config = new Config();
        config.setMerchantId(orders.getMerchantId());
        Config oneByCondition = (Config)this.configService.findOneByCondition((Serializable)config);
        OrdersServiceImpl ordersService = this;
        this.scheduledThreadPoolExecutor.schedule(() -> OrdersServiceImpl.lambda$add$7(orders, (OrdersService)ordersService), (long)oneByCondition.getAwaitOrderPayMinute().intValue(), TimeUnit.MINUTES);
        return newOrder;
    }

    @Transactional
    public Orders addIntegralPriceSystemOrders(Orders newOrder, Orders orders) {
        RestResult integralResult;
        log.info("\u8ba2\u5355\u5165\u5e93\u7279\u6b8a\u4ef7\u683c\u4f53\u7cfb\u5165\u53c2:\u539f\u59cb:[{}],\u5904\u7406\u5b8c\u6210:[{}]", JSONObject.toJSON((Object)newOrder), JSONObject.toJSON((Object)orders));
        if (newOrder.getPriceSystem().equals(2)) {
            newOrder.setPayStatus(PayStatusEnum.SUCCESS);
        }
        newOrder.setPayAt(new Date());
        List stockResponse = this.goodsSkuDetailService.inventoryReduction(this.convertOrderItemsToSkuInfo(newOrder.getItems()));
        if (!stockResponse.isEmpty()) {
            StringBuffer sb = new StringBuffer("\u5546\u54c1");
            stockResponse.forEach(s -> sb.append(s.getGoodsName()).append("[").append(s.getSkuNo()).append("] "));
            sb.append("\u5e93\u5b58\u4e0d\u8db3");
            throw new CustomException(sb.toString());
        }
        newOrder.setDeductionIntegral(Integer.valueOf(0));
        newOrder.setIntegralAmount(BigDecimal.ZERO);
        newOrder.setDeductionBalance(BigDecimal.ZERO);
        if (newOrder.getPriceSystem().equals(1)) {
            BigDecimal realPayAmount = newOrder.getPayAmount().add(newOrder.getShippingDeduction().multiply(new BigDecimal(new Double(-1.0))));
            newOrder.setPayAmount(realPayAmount);
            newOrder.setWxAmount(realPayAmount);
            newOrder.setSanPayAmount(realPayAmount);
            if (realPayAmount.compareTo(BigDecimal.ZERO) <= 0) {
                throw new CustomException("\u8ba2\u5355\u652f\u4ed8\u91d1\u989d\u5c0f\u4e8e0");
            }
        }
        log.info("insert order info...{}", (Object)JSONObject.toJSONString((Object)newOrder));
        this.ordersMapper.insertSelective((Object)newOrder);
        newOrder.getItems().forEach(orderItems -> {
            orderItems.setOrderId(newOrder.getId());
            orderItems.setItemsActiveDeduction(BigDecimal.ZERO);
            orderItems.setOrderNo(newOrder.getOrderNo());
        });
        this.orderItemsMapper.insertList(newOrder.getItems());
        log.info("insert order successfully ! ");
        List noneStockGiftsInfo = this.saveGiftGoods(newOrder);
        newOrder.setNoneStockGiftList(noneStockGiftsInfo);
        if (newOrder.getPoints() != null && newOrder.getPoints() > 0L && 0 != (integralResult = this.wscConsumeIntegralChange(newOrder.getUserNo(), Integer.valueOf(newOrder.getPoints().intValue()), newOrder.getOrderNo())).getCode()) {
            throw new CustomException("\u6263\u51cf\u79ef\u5206\u5931\u8d25");
        }
        Config config = new Config();
        config.setMerchantId(orders.getMerchantId());
        Config oneByCondition = (Config)this.configService.findOneByCondition((Serializable)config);
        OrdersServiceImpl ordersService = this;
        if (orders.getPriceSystem().equals(1)) {
            this.scheduledThreadPoolExecutor.schedule(() -> OrdersServiceImpl.lambda$addIntegralPriceSystemOrders$10(orders, (OrdersService)ordersService), (long)oneByCondition.getAwaitOrderPayMinute().intValue(), TimeUnit.MINUTES);
        }
        log.info("\u8ba2\u5355\u5165\u5e93\u7279\u6b8a\u4ef7\u683c\u4f53\u7cfb\u8fd4\u53c2:[{}]", JSONObject.toJSON((Object)newOrder));
        return newOrder;
    }

    private void incrementSales(List<OrderItems> items) {
        this.goodsSkuDetailService.incrementSales(items.stream().map(item -> GoodsSkuDetail.builder().goodsId(item.getGoodsId()).skuNo(item.getGoodsSkuNo()).actualSales(item.getSaleQuantity()).build()).collect(Collectors.toList()));
        this.goodsService.incrementSales(items.stream().map(item -> Goods.builder().id(item.getGoodsId()).actualSales(item.getSaleQuantity()).build()).collect(Collectors.toList()));
    }

    public void updateForPaySuccess(Orders orders) {
        InputValidator.checkEmpty((Object)orders.getOrderNo(), (String)"\u8ba2\u5355\u7f16\u53f7");
        String key = String.format(ORDERS_PAY_SUCCESS_KEY, orders.getOrderNo());
        if (!this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)"ok").booleanValue()) {
            log.warn("\u8ba2\u5355{}\u4ed8\u6b3e\u6210\u529f\u901a\u77e5\u91cd\u590d\uff0c\u5df2\u5ffd\u7565\u3002", (Object)orders.getOrderNo());
            return;
        }
        this.stringRedisTemplate.expire((Object)key, 7L, TimeUnit.DAYS);
        Date now = new Date();
        orders.setPayStatus(PayStatusEnum.SUCCESS);
        orders.setPayAt(now);
        orders.setGmtModified(now);
        Example example = new Example(Orders.class);
        example.createCriteria().andEqualTo("orderNo", (Object)orders.getOrderNo());
        Orders param = new Orders();
        param.setOrderNo(orders.getOrderNo());
        Orders od = this.ordersMapper.selectOrdersDetailById((Object)param);
        if (!StringUtils.isEmpty((Object)od.getCouponNo())) {
            this.couponService.verify(CouponDTO.builder().code(od.getCouponNo()).userNo(od.getUserNo()).deductionAmount(od.getCouponDeduction()).verifyAmount(od.getPayAmount()).merchantId(od.getMerchantId()).build());
        }
        this.incrementSales(od.getItems());
        OrderEvent addOrderEvent = new OrderEvent((Object)this.applicationContext, od);
        this.applicationContext.publishEvent((ApplicationEvent)addOrderEvent);
        int result = this.ordersMapper.updateByExampleSelective((Object)orders, (Object)example);
        if (result == 0) {
            throw new CustomException("\u4fee\u6539\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u5931\u8d25");
        }
        Example example1 = new Example(MarketActivityOrders.class);
        example1.createCriteria().andEqualTo("ordersNo", (Object)od.getOrderNo());
        MarketActivityOrders marketActivityOrders = (MarketActivityOrders)this.marketActivityOrdersMapper.selectOneByExample((Object)example1);
        marketActivityOrders.setTradeStatus("1");
        marketActivityOrders.setGmtModified(new Date());
        this.marketActivityOrdersMapper.updateByPrimaryKeySelective((Object)marketActivityOrders);
        Example example3 = new Example(MarketActivity.class);
        example3.createCriteria().andEqualTo("activityNo", (Object)marketActivityOrders.getActivityNo());
        MarketActivity marketActivity = (MarketActivity)this.marketActivityMapper.selectOneByExample((Object)example3);
        if (marketActivity == null) {
            throw new CustomException("\u6d3b\u52a8\u4e0d\u5b58\u5728\uff01");
        }
        if (marketActivityOrders.getLaunchUserNo().equals(marketActivityOrders.getUserNo())) {
            this.scheduledThreadPoolExecutor.schedule(() -> {
                log.info("close activity {} schedule start ...", (Object)marketActivityOrders.getActivityOrdersNo());
                this.assembleService.cancel(marketActivityOrders.getActivityOrdersNo());
            }, (long)marketActivity.getActivityTermValidity().intValue(), TimeUnit.HOURS);
        }
        Example goodQ = new Example(Goods.class);
        goodQ.createCriteria().andEqualTo("goodsNo", (Object)marketActivityOrders.getGoodsNo()).andEqualTo("isDel", (Object)Boolean.FALSE).andEqualTo("merchantId", (Object)marketActivity.getMerchantId());
        Goods goods = (Goods)this.goodsMapper.selectOneByExample((Object)goodQ);
        Example orderItemsQ = new Example(OrderItems.class);
        orderItemsQ.createCriteria().andEqualTo("orderNo", (Object)od.getOrderNo()).andEqualTo("goodsId", (Object)goods.getId()).andEqualTo("goodsSkuNo", (Object)marketActivityOrders.getGoodsSkuNo());
        OrderItems orderItems = (OrderItems)this.orderItemsMapper.selectOneByExample((Object)orderItemsQ);
        Integer num = goods.getAssembleNum() == null ? 0 : goods.getAssembleNum();
        goods.setAssembleNum(Integer.valueOf(num + orderItems.getSaleQuantity()));
        this.goodsMapper.updateByPrimaryKeySelective((Object)goods);
        if ("0".equals(marketActivityOrders.getActivityOrdersNo())) {
            MarketActivityGoods mag = new MarketActivityGoods();
            mag.setMarketActivityNo(od.getActivityNo());
            mag.setSkuNo(od.getGoodsSkuNo());
            mag.setGoodsNo(goods.getGoodsNo());
            mag = (MarketActivityGoods)this.marketActivityGoodsMapper.selectOne((Object)mag);
            if (mag != null && "0".equals(marketActivity.getActivityType())) {
                mag.setBargainNum(Integer.valueOf(mag.getBargainNum() + 1));
                this.marketActivityGoodsMapper.updateByPrimaryKeySelective((Object)mag);
                this.freeFreezeStockAndSubtractStock(goods, marketActivityOrders.getGoodsSkuNo());
            }
        }
        Example example2 = new Example(MarketActivityOrders.class);
        example2.createCriteria().andEqualTo("activityNo", (Object)marketActivityOrders.getActivityNo()).andEqualTo("goodsNo", (Object)marketActivityOrders.getGoodsNo()).andEqualTo("goodsSkuNo", (Object)marketActivityOrders.getGoodsSkuNo()).andEqualTo("launchUserNo", (Object)marketActivityOrders.getLaunchUserNo()).andEqualTo("tradeStatus", (Object)"1").andEqualTo("activityOrdersNo", (Object)marketActivityOrders.getActivityOrdersNo());
        List marketActivityOrdersList = this.marketActivityOrdersMapper.selectByExample((Object)example2);
        if (marketActivity.getActivityPersonNum().intValue() == marketActivityOrdersList.size()) {
            marketActivityOrdersList.forEach(marketActivityOrders1 -> {
                marketActivityOrders1.setOrdersStatus("1");
                marketActivityOrders1.setGmtModified(new Date());
                marketActivityOrders1.setSuccessTime(new Date());
                this.marketActivityOrdersMapper.updateByPrimaryKeySelective(marketActivityOrders1);
                Orders ors = new Orders();
                ors.setOrderNo(marketActivityOrders1.getOrdersNo());
                ors = (Orders)this.ordersMapper.selectOne((Object)ors);
                if (ors != null && ors.getOrdersActivityType().equals(2)) {
                    ors.setAssembleIsFull(Integer.valueOf(1));
                    this.ordersMapper.updateByPrimaryKeySelective((Object)ors);
                }
            });
        }
    }

    private void freeFreezeStockAndSubtractStock(Goods goods, String goodsSkuNo) {
        GoodsSkuDetail goodsSkuDetail = new GoodsSkuDetail();
        goodsSkuDetail.setGoodsId(goods.getId());
        goodsSkuDetail.setSkuNo(goodsSkuNo);
        goodsSkuDetail = (GoodsSkuDetail)this.goodsSkuDetailMapper.selectOne((Object)goodsSkuDetail);
        log.info("\u652f\u4ed8\u56de\u8c03:goodsId:[{}],skuNo:[{}]:\u5b9e\u9645\u5e93\u5b58stock:[{}]", new Object[]{goods.getId(), goodsSkuNo, goodsSkuDetail.getStock()});
        if (goodsSkuDetail != null) {
            this.goodsSkuDetailMapper.updateStockSelective(goodsSkuDetail);
        }
        String key = REDIS_FREEZE_STOCK_KEY + goods.getId() + "-" + goodsSkuNo;
        try {
            String s = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
            if (StringUtils.isEmpty((Object)s)) {
                log.error("\u652f\u4ed8\u56de\u8c03\u6263\u51cfredis\u51bb\u7ed3\u5e93\u5b58\u5931\u8d25_REASON:key\u4e3a\u7a7a:goodsId:[{}],skuNo:[{}]", (Object)goods.getId(), (Object)goodsSkuNo);
            } else if (Integer.parseInt(s) > 0) {
                this.stringRedisTemplate.opsForValue().increment((Object)key, -1L);
            } else {
                log.error("\u652f\u4ed8\u56de\u8c03\u6263\u51cfredis\u51bb\u7ed3\u5e93\u5b58\u5931\u8d25_REASON:\u51bb\u7ed3\u5e93\u5b58\u5c0f\u4e8e0:goodsId:[{}],skuNo:[{}]", (Object)goods.getId(), (Object)goodsSkuNo);
            }
        }
        catch (Exception e) {
            log.error("redis\u5f02\u5e38,\u5fae\u4fe1\u56de\u8c03\u6263\u51cf\u51bb\u7ed3\u5e93\u5b58\u5931\u8d25,goodsId:[{}],skuNo:[{}]", (Object)goods.getId(), (Object)goods.getGoodsNo());
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void cancel(String appid, Integer userId, Integer ordersId) {
        RestResult restResult;
        log.info("\u53d6\u6d88\u8ba2\u5355\u63a5\u53e3\u8fdb\u5165\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
        String key = String.format(ORDER_CLOSE_KEY, ordersId);
        log.info("\u53d6\u6d88\u8ba2\u5355:key:[{}]", (Object)key);
        if (!this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)"").booleanValue()) {
            log.warn("\u53d6\u6d88\u8ba2\u5355{},\u91cd\u590d\u7684\u8bf7\u6c42", (Object)ordersId);
            return;
        }
        this.stringRedisTemplate.expire((Object)key, 7L, TimeUnit.DAYS);
        Orders currentOrders = (Orders)this.commonOrdersServiceImpl.findById(ordersId);
        Assert.notNull((Object)currentOrders, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        InputValidator.checkEmpty((Object)userId, (String)"\u7528\u6237\u7f16\u53f7");
        Orders condition = new Orders();
        condition.setPayStatus(PayStatusEnum.UN_PAY);
        condition.setOrderNo(currentOrders.getOrderNo());
        condition.setUserId(userId);
        Orders orders = new Orders();
        orders.setOrderStatus(OrdersStatusEnum.FAIL);
        orders.setClosedAt(new Date());
        orders.setClosedReason("\u53d6\u6d88\u8ba2\u5355");
        Example example = new Example(Orders.class);
        example.createCriteria().andEqualTo("payStatus", (Object)condition.getPayStatus()).andEqualTo("orderNo", (Object)condition.getOrderNo()).andEqualTo("userId", (Object)condition.getUserId());
        int result = this.ordersMapper.updateByExampleSelective((Object)orders, (Object)example);
        if (result == 0) {
            log.error("\u53d6\u6d88\u8ba2\u5355\u5931\u8d25,\u7528\u6237ID {}, \u8ba2\u5355\u53f7 {}", (Object)userId, (Object)currentOrders.getOrderNo());
            return;
        }
        this.reserveStock(currentOrders);
        this.wepayService.closeOrders(appid, currentOrders.getOrderNo());
        if (!StringUtils.isEmpty((Object)currentOrders.getCouponNo())) {
            this.couponService.unLock(currentOrders.getCouponNo(), currentOrders.getUserNo());
        }
        if ("0".equals(orders.getOrdersActivityType()) && currentOrders.getDeductionIntegral() > 0 && (restResult = this.bizvaneInterface.operationIntegral(currentOrders.getUserNo(), currentOrders.getDeductionIntegral(), OperationTypeEnum.ADD.getCode(), currentOrders.getOrderNo())).getCode() != 0) {
            throw new RuntimeException();
        }
        if ("0".equals(orders.getOrdersActivityType()) && currentOrders.getDeductionBalance().compareTo(BigDecimal.ZERO) == 1 && (restResult = this.bizvaneInterface.operationBalance(currentOrders.getUserNo(), currentOrders.getDeductionBalance(), OperationTypeEnum.ADD.getCode(), currentOrders.getOrderNo())).getCode() != 0) {
            throw new RuntimeException();
        }
        Example example1 = new Example(MarketActivityOrders.class);
        example1.createCriteria().andEqualTo("ordersNo", (Object)currentOrders.getOrderNo());
        MarketActivityOrders marketActivityOrders = (MarketActivityOrders)this.marketActivityOrdersMapper.selectOneByExample((Object)example1);
        if (!"0".equals(orders.getOrdersActivityType())) {
            if (marketActivityOrders != null) {
                this.marketActivityOrdersMapper.deleteByPrimaryKey((Object)marketActivityOrders.getId());
            }
        } else if ("0".equals(orders.getOrdersActivityType())) {
            marketActivityOrders.setOrdersStatus("2");
            this.marketActivityOrdersMapper.updateByPrimaryKeySelective((Object)marketActivityOrders);
        }
    }

    private void reserveStock(Orders currentOrders) {
        List customSkuInfo = this.convertOrderItemsToSkuInfo(currentOrders.getItems());
        customSkuInfo.forEach(o -> o.setStock(Integer.valueOf(-o.getStock().intValue())));
        ArrayList gifts = new ArrayList();
        for (OrderItems items : currentOrders.getItems()) {
            items.getGifts().forEach(g -> g.setGiftCount(Integer.valueOf(-g.getGiftCount().intValue())));
            gifts.addAll(items.getGifts());
        }
        customSkuInfo.addAll(this.convertOrderGiftToSkuInfo(gifts));
        this.goodsSkuDetailService.inventoryReduction(customSkuInfo);
    }

    private BigDecimal getFreightDeduction(Orders orders) {
        Config config = this.configService.findSysConfig(orders.getMerchantId());
        if (config.getIsFreeShipping().booleanValue() && config.getFreePrice().compareTo(orders.getPayAmount()) <= 0) {
            return orders.getShippingFee();
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getFreightByOrderItems(AddressInfoDTO addressInfoDTO, List<OrderItems> orderItems) {
        return this.expressService.calcTemplate(FreightCalcDTO.builder().province(addressInfoDTO.getProvince()).city(addressInfoDTO.getCity()).area(addressInfoDTO.getDistrict()).msg(orderItems.stream().map(od -> FreightCalcDTO.Msg.builder().goodsId(od.getGoodsId()).skuNo(od.getGoodsSkuNo()).num(od.getSaleQuantity().intValue()).build()).collect(Collectors.toList())).build());
    }

    public FreightCalcResponse getFreight(Orders orders) {
        BigDecimal freight = this.getFreightByOrderItems(AddressInfoDTO.builder().province(orders.getShippingProvince()).city(orders.getShippingCity()).district(orders.getShippingDistrict()).build(), orders.getItems());
        log.info("Freight is {}", (Object)freight);
        orders.setShippingFee(freight);
        BigDecimal deduction = this.getFreightDeduction(orders);
        log.info("Freight Deduction {}", (Object)deduction);
        FreightCalcResponse response = new FreightCalcResponse();
        response.setFreightDeduction(deduction);
        response.setFreightFee(freight);
        return response;
    }

    private List<GoodsStockChangeResponseDTO> saveGiftGoods(Orders orders) {
        List itemGiff = this.goodsGiftRelationService.findGoodsByGoodsIdList(orders.getItems().stream().map(OrderItems::getGoodsId).collect(Collectors.toList()));
        HashMap goodsIdItemIdMap = new HashMap();
        orders.getItems().forEach(od -> goodsIdItemIdMap.put(od.getGoodsSkuNo(), od));
        itemGiff.forEach(g -> {
            if (goodsIdItemIdMap.get(g.getRelationSkuNo()) != null) {
                g.setCount(Integer.valueOf(g.getCount() * ((OrderItems)goodsIdItemIdMap.get(g.getRelationSkuNo())).getSaleQuantity()));
            }
        });
        List<Object> responseDTO = new ArrayList<GoodsStockChangeResponseDTO>();
        if (!itemGiff.isEmpty() && itemGiff.size() > 0) {
            responseDTO = this.goodsSkuDetailService.inventoryReduction(this.convertGoodsToSkuInfo(itemGiff));
            if (!responseDTO.isEmpty()) {
                for (GoodsStockChangeResponseDTO goodsStockChangeResponseDTO : responseDTO) {
                    itemGiff.removeIf(activeGood -> activeGood.getId().equals(noneStockGoods.getGoodsId()));
                }
            }
            ArrayList giftList = new ArrayList();
            itemGiff.forEach(g -> {
                if (goodsIdItemIdMap.get(g.getRelationSkuNo()) != null) {
                    OrderGift gift = OrderGift.builder().merchantId(orders.getMerchantId()).giftCount(g.getCount()).goodsId(g.getId()).goodsImg(g.getCoverImg()).goodsName(g.getGoodsName()).orderId(((OrderItems)goodsIdItemIdMap.get(g.getRelationSkuNo())).getOrderId()).orderItemId(((OrderItems)goodsIdItemIdMap.get(g.getRelationSkuNo())).getId()).skuNo(((OrderItems)goodsIdItemIdMap.get(g.getRelationSkuNo())).getGoodsSkuNo()).hasRefund(Boolean.valueOf(false)).build();
                    giftList.add(gift);
                }
            });
            this.ordersGiftService.add(giftList);
        }
        return responseDTO;
    }

    private void checkUserInfo(Orders orders) {
        if (orders.getUserId() == null && StringUtils.isEmpty((Object)orders.getUserNo())) {
            throw new IllegalArgumentException("\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
    }

    private Goods getGoodsById(Integer goodsId, List<Goods> dbGoods) {
        for (Goods dbGood : dbGoods) {
            if (!dbGood.getId().equals(goodsId)) continue;
            return dbGood;
        }
        throw new IllegalArgumentException("\u5546\u54c1ID" + goodsId + "\u672a\u627e\u5230");
    }

    private List<Goods> checkAndGetGoodsInfo(List<Goods> customGoodsList) {
        if (customGoodsList == null || customGoodsList.isEmpty()) {
            throw new CustomException("\u672a\u9009\u62e9\u4efb\u4f55\u5546\u54c1");
        }
        Integer merchantId = null;
        ArrayList<Integer> goodsIdList = new ArrayList<Integer>();
        for (Goods goods : customGoodsList) {
            goodsIdList.add(goods.getId());
            merchantId = goods.getMerchantId();
        }
        Goods queryCondition = new Goods();
        queryCondition.setIdList(goodsIdList);
        queryCondition.setMerchantId(merchantId);
        List dbGoodsInfo = this.goodsService.findByCondition((Serializable)queryCondition);
        if (dbGoodsInfo == null) {
            throw new CustomException("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        for (Goods customGoods : customGoodsList) {
            Goods extract = this.extractSkuInfoFromSkuList(customGoods, dbGoodsInfo);
            if (extract == null) {
                throw new CustomException("\u5546\u54c1[" + customGoods.getGoodsName() + "]\u4e0d\u5b58\u5728");
            }
            if (!extract.getIsShelved().booleanValue()) {
                throw new CustomException("\u5546\u54c1[" + customGoods.getGoodsName() + "]\u5df2\u4e0b\u67b6");
            }
            if (extract.getLimitation().equals(0) || extract.getLimitation().compareTo(customGoods.getCount()) >= 0) continue;
            throw new CustomException("\u5546\u54c1[" + customGoods.getGoodsName() + "]\u6bcf\u5355\u9650\u8d2d" + extract.getLimitation() + "\u4ef6");
        }
        return dbGoodsInfo;
    }

    private List<GoodsSkuDetail> checkAndGetSkuInfo(List<GoodsSkuDetail> customSkuInfoList) {
        List dbSkuInfoList = this.goodsSkuDetailService.findByCondition(customSkuInfoList);
        InputValidator.checkEmpty((Collection)dbSkuInfoList, (String)"\u5546\u54c1");
        for (GoodsSkuDetail customSku : customSkuInfoList) {
            GoodsSkuDetail extract = this.extractSkuInfoFromSkuList(customSku, dbSkuInfoList);
            Assert.notNull((Object)extract, (String)("\u5546\u54c1[" + this.getGoodsSkuName(customSku) + "]\u4e0d\u5b58\u5728"));
            if (extract.getStock() - customSku.getStock() >= 0) continue;
            throw new CustomException("\u5546\u54c1[" + this.getGoodsSkuName(customSku) + "]\u5e93\u5b58\u4e0d\u8db3");
        }
        return dbSkuInfoList;
    }

    private Goods extractSkuInfoFromSkuList(Goods qg, List<Goods> queryResultGoods) {
        for (Goods goods : queryResultGoods) {
            if (!goods.getId().equals(qg.getId())) continue;
            return goods;
        }
        return null;
    }

    private GoodsSkuDetail extractSkuInfoFromSkuList(GoodsSkuDetail goodsSkuDetail, List<GoodsSkuDetail> goodsSkuDetailList) {
        for (GoodsSkuDetail gsd : goodsSkuDetailList) {
            if (!gsd.getSkuNo().equals(goodsSkuDetail.getSkuNo()) || !gsd.getGoodsId().equals(goodsSkuDetail.getGoodsId())) continue;
            return gsd;
        }
        return null;
    }

    private List<GoodsSkuDetail> convertGoodsToSkuInfo(List<Goods> activeGoods) {
        ArrayList<GoodsSkuDetail> goodsSkuDetails = new ArrayList<GoodsSkuDetail>();
        for (Goods activeGood : activeGoods) {
            GoodsSkuDetail skuInfo = new GoodsSkuDetail();
            skuInfo.setGoodsId(activeGood.getId());
            skuInfo.setGoodsName(activeGood.getGoodsName());
            skuInfo.setStock(activeGood.getCount());
            goodsSkuDetails.add(skuInfo);
        }
        return goodsSkuDetails;
    }

    private List<GoodsSkuDetail> convertOrderGiftToSkuInfo(List<OrderGift> gifts) {
        ArrayList<GoodsSkuDetail> goodsSkuDetails = new ArrayList<GoodsSkuDetail>();
        for (OrderGift gift : gifts) {
            GoodsSkuDetail skuInfo = new GoodsSkuDetail();
            skuInfo.setGoodsId(gift.getGoodsId());
            skuInfo.setGoodsName(gift.getGoodsName());
            skuInfo.setStock(gift.getGiftCount());
            goodsSkuDetails.add(skuInfo);
        }
        return goodsSkuDetails;
    }

    private List<GoodsSkuDetail> convertOrderItemsToSkuInfo(List<OrderItems> orderItems) {
        ArrayList<GoodsSkuDetail> skuInfoList = new ArrayList<GoodsSkuDetail>();
        for (OrderItems item : orderItems) {
            GoodsSkuDetail skuInfo = new GoodsSkuDetail();
            skuInfo.setGoodsId(item.getGoodsId());
            skuInfo.setSkuNo(item.getGoodsSkuNo());
            skuInfo.setGoodsName(item.getGoodsName());
            skuInfo.setStock(item.getSaleQuantity());
            skuInfoList.add(skuInfo);
        }
        return skuInfoList;
    }

    private List<Goods> convertOrderItemsToGoods(List<OrderItems> orderItems) {
        HashMap<Integer, Goods> goodsMap = new HashMap<Integer, Goods>(3);
        for (OrderItems orderItem : orderItems) {
            Goods goods = new Goods();
            goods.setId(orderItem.getGoodsId());
            goods.setMerchantId(orderItem.getMerchantId());
            goods.setGoodsName(orderItem.getGoodsName());
            goods.setSpecNames(orderItem.getGoodsName());
            goods.setId(orderItem.getGoodsId());
            Integer quantity = orderItem.getSanSaleQuantity();
            if (goodsMap.containsKey(goods.getId())) {
                Goods goods1 = (Goods)goodsMap.get(goods.getId());
                goods.setCount(Integer.valueOf(goods1.getCount() + quantity));
            } else {
                goods.setCount(quantity);
            }
            goodsMap.put(goods.getId(), goods);
        }
        return new ArrayList<Goods>(goodsMap.values());
    }

    private String getGoodsSkuName(GoodsSkuDetail orderItems) {
        return orderItems.getGoodsName() + " " + orderItems.getSkuNo();
    }

    public Orders calcOrdersByCoupons(CouponDTO couponDTO, Orders orders) {
        if (couponDTO == null) {
            return null;
        }
        Orders confirmOrders = this.payConfirm(orders);
        this.couponService.packCouponIsValid(couponDTO, orders);
        if (!couponDTO.getCanUse().booleanValue()) {
            throw new CustomException(couponDTO.getTip());
        }
        confirmOrders = OrdersBuilder.getBuilder((Orders)confirmOrders).fromCoupons(couponDTO).getOrders();
        return confirmOrders;
    }

    public OrdersCountInfo getCountOrders(Orders orders) {
        return this.ordersMapper.selectCountOrders(orders);
    }

    public List<Orders> getOrdersList(OrdersQueryInfo orders) {
        if (StringUtils.isEmpty((Object)orders.getUserId()) && StringUtils.isEmpty((Object)orders.getUserNo())) {
            throw new CustomException("\u7528\u6237\u4fe1\u606f\u4e22\u5931,\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        List list = this.ordersMapper.selectOrderListByCondition(orders);
        list.forEach(orders1 -> {
            int queryStatus;
            int n = queryStatus = orders.getQueryStatus() == null ? 0 : orders.getQueryStatus();
            if (1 == queryStatus) {
                orders1.getItems().forEach(orderItems -> {
                    Goods goods = (Goods)this.goodsMapper.selectByPrimaryKey((Object)orderItems.getGoodsId());
                    orderItems.setGoodsNo(goods != null ? goods.getGoodsNo() : null);
                });
            }
        });
        return list;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void refundOrder(Integer itemId, RefundOrder refundOrder) {
        OrderItems orderItems = (OrderItems)this.orderItemsMapper.selectByPrimaryKey((Object)itemId);
        Orders orders = (Orders)this.ordersMapper.selectByPrimaryKey((Object)orderItems.getOrderId());
        if (!LogisticsStatusEnum.UN_SEND.equals((Object)orders.getLogisticsStatus())) {
            this.checkRefundCondition(orders);
            if (refundOrder.getRefundType() == 2) {
                InputValidator.checkEmpty((Object)refundOrder.getRefundShippingNo(), (String)"\u9000\u8d27\u7269\u6d41\u7f16\u53f7");
            }
            if (!orderItems.getRefundStatus().equals((Object)RefundStatus.NONE)) {
                throw new CustomException("\u5546\u54c1\u5df2\u7533\u8bf7\u9000\u6b3e\u4e2d");
            }
            Config config = this.CommonConfigServiceImpl.findSysConfig(refundOrder.getMerchantId());
            Integer awaitOrderReturn = config.getAwaitOrderReturn();
            Calendar cl = Calendar.getInstance();
            cl.setTime(orders.getGmtCreate());
            cl.add(5, awaitOrderReturn);
            Date returnDate = cl.getTime();
            if (returnDate.before(new Date())) {
                throw new CustomException("\u60a8\u7684\u8ba2\u5355\u5df2\u5b8c\u6210\u591a\u65e5\u65e0\u6cd5\u7533\u8bf7\u552e\u540e");
            }
        }
        Date date = new Date();
        refundOrder.setOrderNo(orderItems.getOrderNo());
        refundOrder.setMerchantId(orderItems.getMerchantId());
        refundOrder.setUserId(orders.getUserId());
        refundOrder.setUserName(orders.getUserName());
        refundOrder.setUserNo(orders.getUserNo());
        refundOrder.setItemId(orderItems.getId());
        refundOrder.setRefundAt(date);
        refundOrder.setGmtCreate(date);
        refundOrder.setRefundQuantity(orderItems.getSaleQuantity());
        refundOrder.setRefundNo(DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss") + RandomCodeUtil.randCode((int)10));
        if (orders.getPriceSystem().equals(0)) {
            refundOrder.setItemAmout(orderItems.getItemsPayAmount());
            refundOrder.setRefundIntegral(orderItems.getDeductionIntegral());
            refundOrder.setRefundBalance(orderItems.getDeductionBalance());
        } else {
            refundOrder.setRefundIntegral(Integer.valueOf(Integer.parseInt(orders.getPoints() + "")));
            refundOrder.setRefundBalance(BigDecimal.ZERO);
        }
        log.info("\u8ba2\u5355\u9000\u6b3e\u7684\u91d1\u989d\uff1a{}", (Object)orderItems.getWepayAmount());
        refundOrder.setRefundAmount(orderItems.getWepayAmount());
        this.refundOrderMapper.insertSelective((Object)refundOrder);
        orderItems.setRefundStatus(RefundStatus.REFUND);
        this.orderItemsMapper.updateByPrimaryKeySelective((Object)orderItems);
    }

    private void checkRefundCondition(Orders orders) {
        if (orders.getReceiptAt() == null) {
            return;
        }
        Config sysConfig = this.configService.findSysConfig(orders.getMerchantId());
        if (System.currentTimeMillis() - orders.getReceiptAt().getTime() > (long)(sysConfig.getAwaitOrderReturn() * 24 * 3600) * 1000L) {
            throw new CustomException("\u8ba2\u5355\u786e\u8ba4\u6536\u8d27" + sysConfig.getAwaitOrderReturn() + "\u5929\u540e\u4e0d\u80fd\u7533\u8bf7\u552e\u540e");
        }
    }

    public JsPayResponse payment(Integer ordersId, String appid) {
        InputValidator.checkNull((Object)ordersId, (String)"\u8ba2\u5355ID");
        Orders orders = (Orders)this.ordersMapper.selectByPrimaryKey((Object)ordersId);
        this.checkOrdersShippingInfo(orders);
        WechatJsPayDTO wechatJsPayDTO = WechatJsPayDTO.builder().appid(appid).isTest(Boolean.valueOf(this.wechatProperties.isTest())).body(this.wechatProperties.getPay().getBody()).notifyUrl((String)this.wechatProperties.getUrls().get("pay-notify")).openid(orders.getWechatOpenid()).orderNo(orders.getOrderNo()).totalFee(orders.getPayAmount()).build();
        log.info("\u83b7\u53d6\u5fae\u4fe1\u652f\u4ed8\u7b7e\u540d====>{}", (Object)JSONObject.toJSONString((Object)wechatJsPayDTO));
        return this.prePay(wechatJsPayDTO, orders.getMerchantId());
    }

    private JsPayResponse prePay(WechatJsPayDTO wechatJsPayDTO, Integer merchantId) {
        Example example = new Example(WechatMchNew.class);
        example.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        WechatMchNew mchNew = (WechatMchNew)this.wechatMchNewMapper.selectOneByExample((Object)example);
        if (mchNew == null) {
            throw new CustomException("\u54c1\u724cID:" + merchantId + ",\u672a\u64cd\u4f5c\u5fae\u4fe1\u652f\u4ed8\u914d\u7f6e");
        }
        WechatMp wechatMp = new WechatMp();
        wechatMp.setAppid(mchNew.getAppId());
        WechatMch wechatMch = new WechatMch();
        wechatMch.setMchKey(mchNew.getMchKey());
        wechatMch.setMchNo(mchNew.getMchNo());
        wechatMch.setP12(mchNew.getP12());
        Wepay wepay = this.wechatService.getWepay(wechatMp, wechatMch);
        JsPayRequest jsPayRequest = new JsPayRequest();
        jsPayRequest.setBody(wechatJsPayDTO.getBody());
        jsPayRequest.setOutTradeNo(wechatJsPayDTO.getOrderNo());
        jsPayRequest.setTotalFee(Integer.valueOf(wechatJsPayDTO.getTotalFee().multiply(new BigDecimal("100")).intValue()));
        jsPayRequest.setOpenId(wechatJsPayDTO.getOpenid());
        jsPayRequest.setClientIp(IpAddressHelper.getRemoteHost((HttpServletRequest)((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest()));
        jsPayRequest.setNotifyUrl(wechatJsPayDTO.getNotifyUrl());
        jsPayRequest.setTimeStart(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        log.info("\u5fae\u4fe1\u652f\u4ed8\u7b7e\u540d\u53c2\u6570===>{}", (Object)JSONObject.toJSONString((Object)jsPayRequest));
        log.info("\u5fae\u4fe1\u652f\u4ed8\u7b7e\u540d\u7684\u5fae\u4fe1\u4f53===>{}", (Object)JSONObject.toJSONString((Object)wepay));
        return wepay.pay().jsPay(jsPayRequest);
    }

    private void checkOrdersShippingInfo(Orders orders) {
        if (orders.getShippingMode().equals(0)) {
            InputValidator.checkEmpty((Object)orders.getShippingName(), (String)"\u6536\u8d27\u4eba\u59d3\u540d");
            InputValidator.checkEmpty((Object)orders.getShippingMobile(), (String)"\u624b\u673a\u53f7\u7801");
            InputValidator.checkEmpty((Object)orders.getShippingProvince(), (String)"\u7701\u4efd");
            InputValidator.checkEmpty((Object)orders.getShippingCity(), (String)"\u57ce\u5e02");
            InputValidator.checkEmpty((Object)orders.getShippingDistrict(), (String)"\u5730\u533a");
            InputValidator.checkEmpty((Object)orders.getShippingAddress(), (String)"\u8be6\u7ec6\u5730\u5740");
        } else {
            InputValidator.checkEmpty((Object)orders.getPickStoreId(), (String)"\u81ea\u63d0\u95e8\u5e97ID");
            InputValidator.checkEmpty((Object)orders.getPickStoreName(), (String)"\u81ea\u63d0\u95e8\u5e97\u540d\u79f0");
        }
    }

    public void updateRefundItems(OrderItems orderItems) {
        OrderItems items = (OrderItems)this.orderItemsMapper.selectByPrimaryKey((Object)orderItems.getId());
        Example example = new Example(OrderItems.class);
        example.createCriteria().andEqualTo("orderNo", (Object)items.getOrderNo()).andNotEqualTo("refundStatus", (Object)RefundStatus.SUCCESS);
        List list = this.orderItemsMapper.selectByExample((Object)example);
        if (list.size() < 1) {
            Orders orders = new Orders();
            orders.setId(items.getOrderId());
            orders.setOrderStatus(OrdersStatusEnum.FAIL);
            orders.setClosedAt(new Date());
            orders.setClosedReason("\u53d6\u6d88\u8ba2\u5355");
            this.ordersMapper.updateByPrimaryKeySelective((Object)orders);
        }
        log.info("\u9000\u6b3e\u56de\u8c03\u6210\u529f");
    }

    public BigDecimal getIntegralProportion(String memberCode) {
        return this.bizvaneInterface.getIntegralProportion(memberCode);
    }

    public RestResult wscConsumeIntegralChange(String memberCode, Integer integral, String orderNo) {
        return this.bizvaneInterface.operationIntegral(memberCode, integral, OperationTypeEnum.REDUCE.getCode(), orderNo);
    }

    public RestResult wscConsumeBalance(String memberCode, BigDecimal balance, String orderNo) {
        return this.bizvaneInterface.operationBalance(memberCode, balance, OperationTypeEnum.REDUCE.getCode(), orderNo);
    }

    private static /* synthetic */ void lambda$addIntegralPriceSystemOrders$10(Orders orders, OrdersService ordersService) {
        log.info("close order {} schedule start ...", (Object)orders.getOrderNo());
        ordersService.cancel(orders.getAppid(), orders.getUserId(), orders.getId());
    }

    private static /* synthetic */ void lambda$add$7(Orders orders, OrdersService ordersService) {
        log.info("close order {} schedule start ...", (Object)orders.getOrderNo());
        ordersService.cancel(orders.getAppid(), orders.getUserId(), orders.getId());
    }
}

