/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.dto.ReduceHelpResponse;
import com.wmeimob.fastboot.bizvane.dto.ReducePriceDto;
import com.wmeimob.fastboot.bizvane.entity.BargainPlayers;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.MarketActivity;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityGoods;
import com.wmeimob.fastboot.bizvane.entity.MarketActivityOrders;
import com.wmeimob.fastboot.bizvane.entity.Orders;
import com.wmeimob.fastboot.bizvane.entity.User;
import com.wmeimob.fastboot.bizvane.mapper.BargainPlayersMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityOrdersMapper;
import com.wmeimob.fastboot.bizvane.service.MarketActivityService;
import com.wmeimob.fastboot.core.exception.CustomException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

@Service(value="marketActivityService")
public class MarketActivityServiceImpl
implements MarketActivityService {
    private static final Logger log = LoggerFactory.getLogger(MarketActivityServiceImpl.class);
    @Resource
    private MarketActivityMapper marketActivityMapper;
    @Autowired
    private MarketActivityGoodsMapper marketActivityGoodsMapper;
    @Autowired
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private BargainPlayersMapper bargainPlayersMapper;
    @Autowired
    private MarketActivityOrdersMapper marketActivityOrdersMapper;
    public static String REDIS_FREEZE_STOCK_KEY = "wx_reducePrice_freeze_stock_";
    public static String REDIS_PRECALULATE_PRICE_ARRAY_KEY = "wx_reducePrice_preCal_";

    public PageInfo<ReducePriceDto> queryReducePage(int pageNum, int pageSize) {
        PageInfo activitys = this.getActivityPage(pageNum, pageSize);
        return this.getActivitySkuResult(activitys);
    }

    private Integer getActualStockByRedis(String goodsId, String skuNo, Integer stock) {
        String freezeStock = null;
        int i = 0;
        try {
            freezeStock = (String)this.stringRedisTemplate.opsForValue().get((Object)(REDIS_FREEZE_STOCK_KEY + goodsId + "_" + skuNo));
        }
        catch (Exception e1) {
            log.info(e1.getMessage());
        }
        i = freezeStock == null ? 0 : Integer.parseInt(freezeStock);
        return stock - i;
    }

    private PageInfo<ReducePriceDto> getActivitySkuResult(PageInfo<MarketActivity> activitys) {
        if (activitys != null && !CollectionUtils.isEmpty((Collection)activitys.getList())) {
            List collect = activitys.getList().stream().map(e -> {
                List select = this.marketActivityGoodsMapper.getGoodsDetail(e.getActivityNo(), null, null, null, null);
                Map stringObjectMap = this.chooseSkuByRule(select);
                MarketActivityGoods selectedOne = (MarketActivityGoods)stringObjectMap.get("marketActivityGoods");
                return this.activityAndSkuAdapt(selectedOne);
            }).collect(Collectors.toList());
            PageInfo reducePriceDtoPageInfo = new PageInfo(collect);
            BeanUtils.copyProperties(activitys, (Object)reducePriceDtoPageInfo);
            reducePriceDtoPageInfo.setList(collect);
            return reducePriceDtoPageInfo;
        }
        return null;
    }

    private ReducePriceDto activityAndSkuAdapt(MarketActivityGoods selectedOne) {
        ReducePriceDto reducePriceDto = new ReducePriceDto();
        BeanUtils.copyProperties((Object)selectedOne, (Object)reducePriceDto);
        reducePriceDto.setMinPrice(selectedOne.getAmount());
        reducePriceDto.setSalePrice(selectedOne.getPrice());
        reducePriceDto.setMark("\u53d1\u8d77\u780d\u4ef7");
        reducePriceDto.setMarketActivityNo(selectedOne.getMarketActivityNo());
        reducePriceDto.setShowSkuNo(selectedOne.getSkuNo());
        reducePriceDto.setActivitySign(Integer.valueOf(0));
        return reducePriceDto;
    }

    public Map<String, Object> chooseSkuByRule(List<MarketActivityGoods> select) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        MarketActivityGoods minsalePriceSku = select.stream().min(Comparator.comparing(MarketActivityGoods::getPrice)).get();
        List readyCompeteSku = select.stream().filter(e -> e.getPrice().equals(minsalePriceSku.getPrice())).collect(Collectors.toList());
        if (readyCompeteSku.size() > 1) {
            MarketActivityGoods marketActivityGoods = this.compareLowprice(readyCompeteSku, select);
            map.put("marketActivityGoods", marketActivityGoods);
        }
        map.put("marketActivityGoods", select.get(0));
        return map;
    }

    private MarketActivityGoods compareLowprice(List<MarketActivityGoods> collect, List<MarketActivityGoods> select) {
        ArrayList result = new ArrayList();
        MarketActivityGoods marketActivityGoods = collect.stream().min(Comparator.comparing(MarketActivityGoods::getAmount)).get();
        List collect1 = result.stream().filter(e -> e.getAmount().equals(marketActivityGoods.getAmount())).collect(Collectors.toList());
        if (collect1.size() > 1) {
            return (MarketActivityGoods)collect1.get(0);
        }
        return marketActivityGoods;
    }

    private PageInfo<MarketActivity> getActivityPage(int pageNum, int pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        Example example = new Example(MarketActivity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("activityStatus", (Object)true);
        criteria.andEqualTo("activityType", (Object)0);
        criteria.andCondition("now() >= activity_begin_time and now() <= activity_end_time");
        example.setOrderByClause("activity_begin_time desc");
        List marketActivities = this.marketActivityMapper.selectByExample((Object)example);
        return new PageInfo(marketActivities);
    }

    public ReduceHelpResponse handleHelpFriends(String goodsId, String goodsNo, User user, String activityOrdersNo) {
        BigDecimal bigDecimal;
        String reducePriceKey = REDIS_PRECALULATE_PRICE_ARRAY_KEY + activityOrdersNo;
        ReduceHelpResponse res = new ReduceHelpResponse();
        MarketActivityOrders mao = new MarketActivityOrders();
        mao.setActivityOrdersNo(activityOrdersNo);
        mao.setOrdersStatus("0");
        mao = (MarketActivityOrders)this.marketActivityOrdersMapper.selectOne((Object)mao);
        if (mao != null) {
            if ("1".equals(mao.getTradeStatus())) {
                throw new CustomException("\u53d1\u8d77\u780d\u4ef7\u7684\u8ba2\u5355\u5df2\u7ecf\u652f\u4ed8\u8fc7");
            }
            if (!StringUtils.isEmpty((Object)mao.getOrdersNo())) {
                log.info("\u8be5\u8425\u9500\u8ba2\u5355\u5df2\u7ecf\u652f\u4ed8\u8fc7:[{}]", (Object)activityOrdersNo);
                throw new CustomException("\u8ba2\u5355\u5df2\u521b\u5efa\uff0c\u4e0d\u80fd\u780d\u4ef7");
            }
            MarketActivity ma = new MarketActivity();
            ma.setActivityNo(mao.getActivityNo());
            MarketActivity marketActivity = (MarketActivity)this.marketActivityMapper.selectOne((Object)ma);
            long time = DateUtils.addHours((Date)mao.getGmtCreate(), (int)marketActivity.getActivityTermValidity()).getTime();
            long time1 = new Date().getTime();
            if (time < time1) {
                throw new CustomException("\u780d\u4ef7\u5df2\u8fc7\u671f");
            }
        } else {
            throw new CustomException("\u6d3b\u52a8\u672a\u627e\u5230");
        }
        if (this.checkFriend(user, activityOrdersNo)) {
            BargainPlayers bp = new BargainPlayers();
            String reducedPrice = this.getReducedPriceByRedis(reducePriceKey, mao, user);
            bp.setActivityOrdersNo(mao.getActivityOrdersNo());
            bigDecimal = new BigDecimal(reducedPrice);
            bp.setAmount(bigDecimal);
            bp.setWxHeadUrl(user.getHeadImgUrl());
            bp.setWxName(user.getFullName());
            bp.setOpenId(user.getOpenid());
            this.bargainPlayersMapper.insert((Object)bp);
            GoodsSkuDetail gsd = new GoodsSkuDetail();
            gsd.setGoodsId(Integer.valueOf(Integer.parseInt(goodsId)));
            gsd.setSkuNo(mao.getGoodsSkuNo());
            gsd = (GoodsSkuDetail)this.goodsSkuDetailMapper.selectOne((Object)gsd);
            if (gsd != null) {
                gsd.setBargainNum(Integer.valueOf(gsd.getBargainNum() + 1));
                this.goodsSkuDetailMapper.updateByPrimaryKeySelective((Object)gsd);
            }
        } else {
            throw new CustomException("\u5df2\u5e2e\u52a9\u597d\u53cb\u780d\u4ef7");
        }
        res.setSalePrice(bigDecimal);
        return res;
    }

    public Orders convertOrdersResult(Orders orders) {
        BigDecimal salePriceAll = orders.getItems().stream().map(e -> e.getSalePrice()).reduce(BigDecimal.ZERO, (x, y) -> y.add((BigDecimal)x));
        salePriceAll = salePriceAll == null ? BigDecimal.ZERO : salePriceAll;
        orders.setDiscountAmount(salePriceAll.subtract(orders.getPayAmount()));
        return orders;
    }

    private String getReducedPriceByRedis(String s, MarketActivityOrders mao, User user) {
        String resultPrice = null;
        ListOperations ops = this.stringRedisTemplate.opsForList();
        if (ops.getOperations().hasKey((Object)s).booleanValue()) {
            resultPrice = (String)ops.leftPop((Object)s, 100L, TimeUnit.MILLISECONDS);
            if (resultPrice == null) {
                log.error("redis\u53d6\u9884\u5904\u7406\u5e95\u4ef7\u4e3a\u7a7a_\u8425\u9500\u8ba2\u5355\u53f7:[{}],\u53c2\u4e0e\u4ebaNo:[{}]", (Object)mao.getActivityOrdersNo(), (Object)user.getUserNo());
            }
        } else {
            log.error("redis\u4e2d\u4e0d\u5b58\u5728\u8be5key_\u8425\u9500\u8ba2\u5355\u53f7:[{}],\u53c2\u4e0e\u4ebaNo:[{}]", (Object)mao.getActivityOrdersNo(), (Object)user.getUserNo());
        }
        return resultPrice;
    }

    public boolean checkFriend(User user, String activityOrdersNo) {
        BargainPlayers bargainPlayers = new BargainPlayers();
        bargainPlayers.setActivityOrdersNo(activityOrdersNo);
        bargainPlayers.setOpenId(user.getOpenid());
        bargainPlayers = (BargainPlayers)this.bargainPlayersMapper.selectOne((Object)bargainPlayers);
        if (bargainPlayers != null) {
            log.info("\u597d\u53cb\u5df2\u7ecf\u5e2e\u52a9\u780d\u4ef7\u8fc7_\u5f53\u524d\u53c2\u4e0e\u4eba:[{}],\u8425\u9500\u8ba2\u5355\u53f7:[{}]", (Object)user.getUserNo(), (Object)activityOrdersNo);
            return false;
        }
        return true;
    }
}

